/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import twilightforest.init.TFCaveCarvers;
import twilightforest.init.TFConfiguredFeatures;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFPlacedFeatures;

public abstract class BiomeHelper {
    public static BiomeGenerationSettings.Builder twilightForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder denseForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DENSE_CANOPY_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TreePlacements.f_195389_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FOREST_CANOPY_OAK_TREE);
        return biome;
    }

    public static BiomeGenerationSettings.Builder fireflyForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FIREFLY_FOREST_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LAMPPOST_PLACER);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MUSHGLOOM_CLUSTER);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195423_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        return biome;
    }

    public static BiomeGenerationSettings.Builder clearingGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195423_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        return biome;
    }

    public static BiomeGenerationSettings.Builder oakSavannaGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SAVANNAH_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SAVANNAH_CANOPY_OAK_TREE);
        return biome;
    }

    public static BiomeGenerationSettings.Builder enchantedForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_ENCHANTED_FOREST_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FIDDLEHEAD);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder spookyForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MAYAPPLE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEAD_CANOPY_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_PUMPKIN_LAMPPOST);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TF_OAK_FALLEN_LOG);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_CANOPY_FALLEN_LOG);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_WEBS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FALLEN_LEAVES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195450_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        biome.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, TFPlacedFeatures.PLACED_GRAVEYARD);
        return biome;
    }

    public static BiomeGenerationSettings.Builder mushroomForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MYCELIUM_BLOB);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        BiomeHelper.addCanopyMushrooms(biome, false);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder denseMushroomForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addForestVegetationAlt(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MYCELIUM_BLOB);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_TWILIGHT_OAK_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_LARGE_TWILIGHT_OAK_TREE);
        BiomeHelper.addCanopyMushrooms(biome, true);
        BiomeHelper.addCanopyTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder thornlandsGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeHelper.commonFeaturesWithoutBuildings(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_THORNS);
        return biome;
    }

    public static BiomeGenerationSettings.Builder highlandsGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HIGHLANDS_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.f_195262_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195457_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SPRUCE_FALLEN_LOG);
        BiomeHelper.addHighlandCaves(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder streamsAndLakes(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean isLake) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, isLake ? AquaticPlacements.f_195224_ : AquaticPlacements.f_195219_);
        BiomeDefaultFeatures.m_126761_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addLegacyOres(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder swampGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.commonFeatures(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MANGROVE_TREE);
        BiomeHelper.addSwampTrees(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195400_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195461_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MANGROVE_FALLEN_LOG);
        BiomeHelper.lilypads(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder fireSwampGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = BiomeHelper.defaultGenSettingBuilder(featureGetter, carverGetter);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.commonFeaturesWithoutBuildings(biome);
        BiomeHelper.addSwampTrees(biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FIRE_JET);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SMOKER);
        biome.m_255155_(GenerationStep.Decoration.LAKES, TFPlacedFeatures.PLACED_LAKE_LAVA);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195400_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195412_);
        return biome;
    }

    public static BiomeGenerationSettings.Builder darkForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FLOWER_PLACER);
        BiomeHelper.addDarkForestVegetation(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder darkForestCenterGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeHelper.addDarkForestVegetation(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder snowyForestGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SNOWY_FOREST_TREES);
        biome.m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, TFPlacedFeatures.PLACED_SNOW_UNDER_TREES);
        biome.m_255155_(GenerationStep.Decoration.LAKES, TFPlacedFeatures.PLACED_LAKE_WATER);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SPRUCE_FALLEN_LOG);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder glacierGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder undergroundGen(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.withWoodRoots(biome);
        BiomeHelper.addCaves(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static void withWoodRoots(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_WOOD_ROOTS_SPREAD);
    }

    public static void commonFeatures(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, TFPlacedFeatures.PLACED_DRUID_HUT);
        biome.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, TFPlacedFeatures.PLACED_WELL_PLACER);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_GROVE_RUINS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FOUNDATION);
        BiomeHelper.commonFeaturesWithoutBuildings(biome);
    }

    public static void commonFeaturesWithoutBuildings(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_STONE_CIRCLE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_OUTSIDE_STALAGMITE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MONOLITH);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HOLLOW_STUMP);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HOLLOW_LOG);
    }

    public static void lilypads(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HUGE_LILY_PAD);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HUGE_WATER_LILY);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
    }

    public static void addForestVegetation(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MAYAPPLE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FLOWER_PLACER);
    }

    public static void addForestVegetationAlt(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MAYAPPLE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_FLOWER_PLACER_ALT);
    }

    public static void addDarkForestVegetation(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195455_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_FOREST_TREE_MIX);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_FOREST_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARKWOOD_TREE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_GRASS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_FERNS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_MUSHGLOOMS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_DEAD_BUSHES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_PUMPKINS);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DARK_MUSHROOMS);
    }

    public static void addCanopyTrees(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_CANOPY_TREES);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_DEFAULT_FALLEN_LOGS);
    }

    public static void addCanopyMushrooms(BiomeGenerationSettings.Builder biome, boolean dense) {
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195408_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195409_);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_VANILLA_TF_BIG_MUSH);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, dense ? TFPlacedFeatures.PLACED_CANOPY_MUSHROOMS_DENSE : TFPlacedFeatures.PLACED_CANOPY_MUSHROOMS_SPARSE);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_MUSHGLOOM_CLUSTER);
    }

    public static void addHollowOakTrees(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_HOLLOW_OAK_TREE);
    }

    public static void addSwampTrees(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, TFPlacedFeatures.PLACED_SWAMPY_OAK_TREE);
    }

    public static void addSmallStoneClusters(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_SMALL_ANDESITE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_SMALL_DIORITE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_SMALL_GRANITE);
    }

    public static BiomeSpecialEffects.Builder whiteAshParticles(BiomeSpecialEffects.Builder builder) {
        builder.m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.05f));
        return builder;
    }

    public static BiomeSpecialEffects.Builder fireflyForestParticles(BiomeSpecialEffects.Builder builder) {
        builder.m_48029_(new AmbientParticleSettings((ParticleOptions)TFParticleType.WANDERING_FIREFLY.get(), 0.001f));
        return builder;
    }

    public static BiomeSpecialEffects.Builder fireflyParticles(BiomeSpecialEffects.Builder builder) {
        builder.m_48029_(new AmbientParticleSettings((ParticleOptions)TFParticleType.WANDERING_FIREFLY.get(), 2.5E-4f));
        return builder;
    }

    public static void addCaves(BiomeGenerationSettings.Builder biome) {
        biome.m_255308_(GenerationStep.Carving.AIR, TFCaveCarvers.TFCAVES_CONFIGURED);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_PLANT_ROOTS);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_TORCH_BERRIES);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_VANILLA_ROOTS);
        BiomeHelper.addLegacyOres(biome);
    }

    public static void addHighlandCaves(BiomeGenerationSettings.Builder biome) {
        biome.m_255308_(GenerationStep.Carving.AIR, TFCaveCarvers.HIGHLANDCAVES_CONFIGURED);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, TFPlacedFeatures.PLACED_TROLL_ROOTS);
        BiomeHelper.addLegacyOres(biome);
    }

    public static void addLegacyOres(BiomeGenerationSettings.Builder biome) {
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_COAL_ORE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_IRON_ORE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_GOLD_ORE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_REDSTONE_ORE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_DIAMOND_ORE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_LAPIS_ORE);
        biome.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, TFPlacedFeatures.PLACED_LEGACY_COPPER_ORE);
    }

    public static MobSpawnSettings.Builder penguinSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.2f);
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.PENGUIN.get(), 10, 2, 4));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder darkForestSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.05f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 2, 1, 2)).m_48370_(EntityType.f_20566_, 0.75, 0.15);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 5, 1, 2)).m_48370_(EntityType.f_20501_, 0.75, 0.15);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 5, 1, 2)).m_48370_(EntityType.f_20524_, 0.85, 0.15);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MIST_WOLF.get(), 5, 1, 1)).m_48370_((EntityType)TFEntities.MIST_WOLF.get(), 0.5, 0.35);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SKELETON_DRUID.get(), 5, 1, 1)).m_48370_((EntityType)TFEntities.SKELETON_DRUID.get(), 0.85, 0.4);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KING_SPIDER.get(), 1, 1, 1)).m_48370_((EntityType)TFEntities.KING_SPIDER.get(), 1.0, 0.5);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 1, 3)).m_48370_((EntityType)TFEntities.KOBOLD.get(), 0.7, 0.11);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 2, 1, 1)).m_48370_(EntityType.f_20495_, 0.75, 0.11);
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder snowForestSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.05f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.WINTER_WOLF.get(), 5, 1, 1)).m_48370_((EntityType)TFEntities.WINTER_WOLF.get(), 0.8, 0.11);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.YETI.get(), 5, 1, 1)).m_48370_((EntityType)TFEntities.YETI.get(), 0.8, 0.11);
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder ravenSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.3f);
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.RAVEN.get(), 10, 4, 4));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder swampSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.1f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 10, 1, 2)).m_48370_(EntityType.f_20501_, 0.75, 0.2);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.MOSQUITO_SWARM.get(), 10, 1, 1)).m_48370_((EntityType)TFEntities.MOSQUITO_SWARM.get(), 0.75, 0.2);
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder spookSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.2f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 50, 1, 2)).m_48370_(EntityType.f_20479_, 0.75, 0.25);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 20, 1, 2)).m_48370_(EntityType.f_20524_, 0.85, 0.25);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SKELETON_DRUID.get(), 5, 1, 1)).m_48370_((EntityType)TFEntities.SKELETON_DRUID.get(), 0.95, 0.25);
        spawnInfo.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 20, 2, 4));
        return spawnInfo;
    }

    public static BiomeSpecialEffects.Builder defaultAmbientBuilder() {
        return new BiomeSpecialEffects.Builder().m_48019_(12648408).m_48034_(4159204).m_48037_(329011).m_48040_(2105930).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(TFConfiguredFeatures.TFMUSICTYPE);
    }

    public static BiomeGenerationSettings.Builder defaultGenSettingBuilder(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126724_((BiomeGenerationSettings.Builder)biome);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biome);
        biome.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195403_);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.withWoodRoots(biome);
        BiomeHelper.addCaves(biome);
        BiomeHelper.addSmallStoneClusters(biome);
        return biome;
    }

    public static MobSpawnSettings.Builder defaultMobSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.1f);
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.BIGHORN_SHEEP.get(), 12, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.BOAR.get(), 10, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 10, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.DEER.get(), 15, 4, 5));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 5, 4, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.TINY_BIRD.get(), 15, 4, 8));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.SQUIRREL.get(), 10, 2, 4));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.DWARF_RABBIT.get(), 10, 4, 5));
        spawnInfo.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.RAVEN.get(), 10, 1, 2));
        return spawnInfo;
    }

    public static MobSpawnSettings.Builder undergroundMobSpawning() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.m_48368_(0.1f);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 10, 2, 3)).m_48370_(EntityType.f_20479_, 0.6, 0.1);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 10, 1, 2)).m_48370_(EntityType.f_20501_, 0.7, 0.1);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 10, 1, 1)).m_48370_(EntityType.f_20524_, 0.7, 0.1);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 1, 1, 1)).m_48370_(EntityType.f_20558_, 0.5, 0.1);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 10, 2, 4)).m_48370_(EntityType.f_20526_, 0.2, 0.1);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 1, 1, 2)).m_48370_(EntityType.f_20566_, 0.3, 0.1);
        spawnInfo.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TFEntities.KOBOLD.get(), 10, 1, 3)).m_48370_((EntityType)TFEntities.KOBOLD.get(), 0.2, 0.1);
        spawnInfo.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 1, 1));
        return spawnInfo;
    }

    public static Biome.BiomeBuilder biomeWithDefaults(BiomeSpecialEffects.Builder biomeAmbience, MobSpawnSettings.Builder mobSpawnInfo, BiomeGenerationSettings.Builder biomeGenerationSettings) {
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.5f).m_47611_(0.5f).m_47603_(biomeAmbience.m_48018_()).m_47605_(mobSpawnInfo.m_48381_()).m_47601_(biomeGenerationSettings.m_255380_()).m_47599_(Biome.TemperatureModifier.NONE);
    }
}

