/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_dungeon;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonContext;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SmallDungeonChestProcessor
extends StructureProcessor {
    public static final SmallDungeonChestProcessor INSTANCE = new SmallDungeonChestProcessor();
    public static final Codec<SmallDungeonChestProcessor> CODEC = Codec.unit(() -> INSTANCE);

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_.m_60734_() instanceof ChestBlock) {
            DungeonContext context = DungeonContext.peek();
            int chestCount = DungeonContext.peek().getChestCount();
            if (chestCount < BetterDungeonsCommon.CONFIG.smallDungeons.chestMinCount) {
                context.incrementChestCount();
            } else if (chestCount < BetterDungeonsCommon.CONFIG.smallDungeons.chestMaxCount) {
                RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_);
                if (random.m_188501_() > 0.2f) {
                    return new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, Blocks.f_50627_.m_49966_(), blockInfoGlobal.f_74677_);
                }
                context.incrementChestCount();
            } else {
                return new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, Blocks.f_50627_.m_49966_(), blockInfoGlobal.f_74677_);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.SMALL_DUNGEON_CHEST_PROCESSOR;
    }
}

