/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.module;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterCreativeTab;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegisterField;
import com.yungnickyoung.minecraft.yungsapi.autoregister.AutoRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CreativeModeTabModuleForge {
    private static final Map<String, AutoRegisterCreativeTab> initializedTabs = new HashMap<String, AutoRegisterCreativeTab>();

    public static void processEntries() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CreativeModeTabModuleForge::initializeTabs);
    }

    private static void initializeTabs(CreativeModeTabEvent.Register event) {
        AutoRegistrationManager.CREATIVE_MODE_TABS.stream().filter(data -> !data.processed()).forEach(data -> CreativeModeTabModuleForge.registerTab(data, event));
    }

    private static void registerTab(AutoRegisterField data, CreativeModeTabEvent.Register event) {
        ResourceLocation resourceLocation = data.name();
        String name = String.format("%s.%s", resourceLocation.m_135827_(), resourceLocation.m_135815_());
        if (initializedTabs.containsKey(name)) {
            return;
        }
        AutoRegisterCreativeTab autoRegisterCreativeTab = (AutoRegisterCreativeTab)data.object();
        Supplier<ItemStack> itemStackSupplier = autoRegisterCreativeTab.getIconItemStackSupplier();
        CreativeModeTab creativeModeTab = event.registerCreativeModeTab(data.name(), builder -> builder.m_257941_((Component)Component.m_237115_((String)("itemGroup." + name))).m_257737_(itemStackSupplier).m_257501_((enabledFlags, populator) -> {}).m_257652_());
        autoRegisterCreativeTab.setSupplier(() -> creativeModeTab);
        initializedTabs.put(name, autoRegisterCreativeTab);
        data.markProcessed();
    }
}

