/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.particlemimicry.blocks.entity;

import com.mrbysco.particlemimicry.registry.MimicryRegistry;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ParticleEmitterBlockEntity
extends BlockEntity {
    public String particleType;
    public String offset;
    public String specialParameters;
    public String delta;
    public String speed;
    public String count;
    public String particleCommand;

    public ParticleEmitterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MimicryRegistry.PARTICLE_EMITTER_ENTITY.get(), pos, state);
        this.setData("", "", "", "", "", "");
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ParticleEmitterBlockEntity blockEntity) {
        if (level.m_46467_() % 20L == 0L) {
            MinecraftServer minecraftserver = level.m_7654_();
            blockEntity.constructCommand();
            if (minecraftserver.m_6993_() && !StringUtil.m_14408_((String)blockEntity.particleCommand)) {
                try {
                    CommandSourceStack commandsourcestack = minecraftserver.m_129893_().m_81348_(Vec3.m_82512_((Vec3i)pos)).m_81324_().m_81327_((ServerLevel)level);
                    minecraftserver.m_129892_().m_230957_(commandsourcestack, blockEntity.particleCommand);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Executing particle emitter block");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Particle command to be executed");
                    crashreportcategory.m_128159_("Command", (Object)blockEntity.particleCommand);
                    crashreportcategory.m_128165_("Name", () -> state.m_60734_().m_49954_().getString());
                    throw new ReportedException(crashreport);
                }
            }
        }
    }

    public void setData(String particleType, String offset, String specialParameters, String delta, String speed, String count) {
        this.particleType = particleType;
        this.offset = this.checkOffset(offset);
        this.specialParameters = specialParameters;
        this.delta = delta;
        this.speed = speed;
        this.count = count;
    }

    private String checkOffset(String offset) {
        String offsetString = offset;
        if (!offsetString.isEmpty()) {
            CharSequence[] offsetArray = offsetString.split(" ");
            for (int i = 0; i < offsetArray.length; ++i) {
                Object offsetValue = offsetArray[i];
                if (((String)offsetValue).contains("~")) {
                    boolean startingWith = ((String)offsetValue).startsWith("~");
                    boolean endingWith = ((String)offsetValue).endsWith("~");
                    if (this.isNumeric((String)(offsetValue = ((String)offsetValue).replace("~", ""))) && Integer.parseInt((String)offsetValue) > 5) {
                        offsetValue = "5";
                    }
                    if (startingWith) {
                        offsetValue = "~" + (String)offsetValue;
                    } else if (endingWith) {
                        offsetValue = (String)offsetValue + "~";
                    }
                } else if (this.isNumeric((String)offsetValue) && Integer.parseInt((String)offsetValue) > 5) {
                    offsetValue = "5";
                }
                offsetArray[i] = offsetValue;
            }
            offsetString = String.join((CharSequence)" ", offsetArray);
        }
        return offsetString;
    }

    public boolean isNumeric(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void constructCommand() {
        StringBuilder commandBuilder = new StringBuilder("particle");
        commandBuilder.append(" " + this.particleType);
        if (!this.offset.isEmpty()) {
            commandBuilder.append(" " + this.offset);
        } else {
            commandBuilder.append(" ~ ~ ~");
        }
        if (!this.specialParameters.isEmpty()) {
            commandBuilder.append(" " + this.specialParameters);
        } else if (this.particleType.equalsIgnoreCase("block")) {
            commandBuilder.append(" " + ForgeRegistries.BLOCKS.getKey((Object)this.m_58900_().m_60734_()));
        }
        if (!this.delta.isEmpty()) {
            commandBuilder.append(" " + this.delta);
        } else {
            commandBuilder.append(" 0 0 0");
        }
        if (!this.speed.isEmpty()) {
            commandBuilder.append(" " + this.speed);
        } else {
            commandBuilder.append(" 0");
        }
        if (!this.count.isEmpty()) {
            commandBuilder.append(" " + this.count);
        } else {
            commandBuilder.append(" 1");
        }
        this.particleCommand = commandBuilder.toString();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.particleType = tag.m_128461_("ParticleType");
        this.offset = tag.m_128461_("Offset");
        this.specialParameters = tag.m_128461_("SpecialParameters");
        this.delta = tag.m_128461_("Delta");
        this.speed = tag.m_128461_("Speed");
        this.count = tag.m_128461_("Count");
        this.constructCommand();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("ParticleType", this.particleType);
        tag.m_128359_("Offset", this.offset);
        tag.m_128359_("SpecialParameters", this.specialParameters);
        tag.m_128359_("Delta", this.delta);
        tag.m_128359_("Speed", this.speed);
        tag.m_128359_("Count", this.count);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void refreshClient() {
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }
}

