/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.particlemimicry.client.screen.components;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.LocalCoordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.util.Mth;

public class DeltaSuggestions
extends CommandSuggestions {
    private EditBox textBox;
    private String previous = "";
    private Font font;
    private boolean active;
    private List<Suggestion> currentSuggestions;
    private boolean centerCorrect;

    public DeltaSuggestions(Minecraft minecraft, Screen screen, EditBox editBox, Font font, boolean centerCorrect) {
        super(minecraft, screen, editBox, font, true, true, 0, 7, false, Integer.MIN_VALUE);
        this.textBox = editBox;
        this.font = font;
        this.currentSuggestions = new ArrayList<Suggestion>();
        this.centerCorrect = centerCorrect;
    }

    public void tick() {
        if (this.f_93866_ == null) {
            this.textBox.m_94167_("");
        }
        if (this.active == this.textBox.m_93696_()) {
            return;
        }
        this.active = this.textBox.m_93696_();
        this.m_93881_();
    }

    public void m_93881_() {
        String value = this.textBox.m_94155_();
        if (value.equals(this.previous)) {
            return;
        }
        if (!this.active) {
            this.f_93866_ = null;
            return;
        }
        this.previous = value;
        SuggestionsBuilder builder = new SuggestionsBuilder(value, 0);
        CompletableFuture<Suggestions> suggestionProvider = this.listSuggestions(builder);
        try {
            this.currentSuggestions = suggestionProvider.get().getList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_93930_(false);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(SuggestionsBuilder suggestionsBuilder) {
        String s = suggestionsBuilder.getRemaining();
        Set<SharedSuggestionProvider.TextCoordinates> collection = !s.isEmpty() && s.charAt(0) == '^' ? Collections.singleton(SharedSuggestionProvider.TextCoordinates.f_82987_) : Collections.singleton(SharedSuggestionProvider.TextCoordinates.f_82988_);
        return SharedSuggestionProvider.m_82952_((String)s, collection, (SuggestionsBuilder)suggestionsBuilder, (Predicate)Commands.m_82120_(this::parse));
    }

    public Coordinates parse(StringReader reader) throws CommandSyntaxException {
        return reader.canRead() && reader.peek() == '^' ? LocalCoordinates.m_119906_((StringReader)reader) : WorldCoordinates.m_120889_((StringReader)reader, (boolean)this.centerCorrect);
    }

    public void m_93930_(boolean narrateFirstSuggestion) {
        if (this.currentSuggestions.isEmpty()) {
            this.f_93866_ = null;
            return;
        }
        int width = 0;
        for (Suggestion suggestion : this.currentSuggestions) {
            width = Math.max(width, this.font.m_92895_(suggestion.getText()));
        }
        int x = Mth.m_14045_((int)this.textBox.m_94211_(0), (int)0, (int)(this.textBox.m_94211_(0) + this.textBox.m_94210_() - width));
        this.f_93866_ = new CommandSuggestions.SuggestionsList((CommandSuggestions)this, x, 72, width, this.currentSuggestions, false);
    }
}

