/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.particlemimicry.client.screen.components;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.util.Mth;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleSuggestions
extends CommandSuggestions {
    private EditBox textBox;
    private String previous = "";
    private Font font;
    private boolean active;
    private List<Suggestion> currentSuggestions;

    public ParticleSuggestions(Minecraft minecraft, Screen screen, EditBox editBox, Font font) {
        super(minecraft, screen, editBox, font, true, true, 0, 7, false, Integer.MIN_VALUE);
        this.textBox = editBox;
        this.font = font;
        this.currentSuggestions = new ArrayList<Suggestion>();
    }

    public void tick() {
        if (this.f_93866_ == null) {
            this.textBox.m_94167_("");
        }
        if (this.active == this.textBox.m_93696_()) {
            return;
        }
        this.active = this.textBox.m_93696_();
        this.m_93881_();
    }

    public void m_93881_() {
        String value = this.textBox.m_94155_();
        if (value.equals(this.previous)) {
            return;
        }
        if (!this.active) {
            this.f_93866_ = null;
            return;
        }
        this.previous = value;
        ArrayList<String> particleTypes = new ArrayList<String>(ForgeRegistries.PARTICLE_TYPES.getKeys().stream().map(it -> it.m_135827_().equals("minecraft") ? it.m_135815_() : it.toString()).toList());
        if (value.length() > 0) {
            particleTypes.removeIf(it -> !it.contains(value));
        }
        SuggestionsBuilder builder = new SuggestionsBuilder(value, 0);
        CompletableFuture suggestionProvider = SharedSuggestionProvider.m_82970_(particleTypes, (SuggestionsBuilder)builder);
        try {
            this.currentSuggestions = ((Suggestions)suggestionProvider.get()).getList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_93930_(false);
    }

    public void m_93930_(boolean narrateFirstSuggestion) {
        if (this.currentSuggestions.isEmpty()) {
            this.f_93866_ = null;
            return;
        }
        int width = 0;
        for (Suggestion suggestion : this.currentSuggestions) {
            width = Math.max(width, this.font.m_92895_(suggestion.getText()));
        }
        int x = Mth.m_14045_((int)this.textBox.m_94211_(0), (int)0, (int)(this.textBox.m_94211_(0) + this.textBox.m_94210_() - width));
        this.f_93866_ = new CommandSuggestions.SuggestionsList((CommandSuggestions)this, x, 72, width, this.currentSuggestions, false);
    }
}

