/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.particlemimicry.datagen;

import com.mrbysco.particlemimicry.datagen.assets.MimicryItemModelProvider;
import com.mrbysco.particlemimicry.datagen.assets.MimicryLanguageProvider;
import com.mrbysco.particlemimicry.datagen.assets.MimicryStateProvider;
import com.mrbysco.particlemimicry.datagen.data.MimicryBlockTagProvider;
import com.mrbysco.particlemimicry.datagen.data.MimicryItemTagProvider;
import com.mrbysco.particlemimicry.datagen.data.MimicryLootProvider;
import com.mrbysco.particlemimicry.datagen.data.MimicryRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MimicryDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new MimicryLootProvider(packOutput));
            generator.addProvider(true, (DataProvider)new MimicryRecipeProvider(packOutput));
            MimicryBlockTagProvider provider = new MimicryBlockTagProvider(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)provider);
            generator.addProvider(true, (DataProvider)new MimicryItemTagProvider(packOutput, lookupProvider, (TagsProvider<Block>)provider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new MimicryLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new MimicryStateProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new MimicryItemModelProvider(packOutput, helper));
        }
    }
}

