/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import java.util.Map;

public class Pair<K, V>
implements Map.Entry<K, V> {
    protected K key;
    protected V value;

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    public Pair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Pair<K, V> of(K key, V value) {
        return new Pair<K, V>(key, value);
    }

    public static <K, V> UnmodifiablePair<K, V> ofUnmodifiable(K key, V value) {
        return new UnmodifiablePair<K, V>(key, value);
    }

    public UnmodifiablePair<K, V> toUnmodifiable() {
        return new UnmodifiablePair<K, V>(this.key, this.value);
    }

    public String toString() {
        return this.key + "=" + this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public Pair<K, V> copy() {
        return new Pair<K, V>(this.key, this.value);
    }

    public static class UnmodifiablePair<K, V>
    extends Pair<K, V> {
        public UnmodifiablePair(K key, V value) {
            super(key, value);
        }

        @Override
        public void setKey(K key) {
            throw new UnsupportedOperationException("Cannot set the key of an UnmodifiablePair");
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("Cannot set the value of an UnmodifiablePair");
        }

        @Override
        public UnmodifiablePair<K, V> toUnmodifiable() {
            return this;
        }
    }
}

