/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.VBufferOut;
import com.tom.cpm.client.optifine.OptifineTexture;
import com.tom.cpm.client.optifine.RedirectModelRendererOF;
import com.tom.cpm.client.optifine.proxy.ModelPartOF;
import com.tom.cpm.client.vr.VRPlayerRenderer;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.BatchedBuffers;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class PlayerRenderManager
extends ModelRenderManager<MultiBufferSource, ModelTexture, ModelPart, Model> {
    public static final Function<ResourceLocation, RenderType> armor = RenderType::m_110431_;
    public static final Function<ResourceLocation, RenderType> entity = RenderType::m_110473_;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<MultiBufferSource, ModelTexture, ModelPart>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, MultiBufferSource, ModelTexture, ModelPart> create(M model, String arg) {
                if ("api".equals(arg) && model instanceof HumanoidModel) {
                    return new RedirectHolderApi(PlayerRenderManager.this, (HumanoidModel<LivingEntity>)((HumanoidModel)model));
                }
                if (CustomPlayerModelsClient.vrLoaded && VRPlayerRenderer.isVRPlayer(model)) {
                    return VRPlayerRenderer.createVRPlayer(PlayerRenderManager.this, model);
                }
                if (model instanceof PlayerModel) {
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (PlayerModel<LivingEntity>)((PlayerModel)model));
                }
                if (model instanceof SkullModel) {
                    return new RedirectHolderSkull(PlayerRenderManager.this, (SkullModel)model);
                }
                if (model instanceof ElytraModel) {
                    return new RedirectHolderElytra(PlayerRenderManager.this, (ElytraModel<LivingEntity>)((ElytraModel)model));
                }
                if (model instanceof HumanoidModel && "armor1".equals(arg)) {
                    return new RedirectHolderArmor1(PlayerRenderManager.this, (HumanoidModel<LivingEntity>)((HumanoidModel)model));
                }
                if (model instanceof HumanoidModel && "armor2".equals(arg)) {
                    return new RedirectHolderArmor2(PlayerRenderManager.this, (HumanoidModel<LivingEntity>)((HumanoidModel)model));
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<Model, ModelTexture, ModelPart>(){

            @Override
            public ModelRenderManager.RedirectRenderer<ModelPart> create(Model model, ModelRenderManager.RedirectHolder<Model, ?, ModelTexture, ModelPart> access, Supplier<ModelPart> modelPart, VanillaModelPart part) {
                return CustomPlayerModelsClient.optifineLoaded ? new RedirectModelRendererOF((RDH)access, modelPart, part) : new RedirectModelRendererVanilla((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.f_104207_, (m, v) -> {
            m.f_104207_ = v;
        });
        this.setModelPosGetters(m -> m.f_104200_, m -> m.f_104201_, m -> m.f_104202_);
        this.setModelRotGetters(m -> m.f_104203_, m -> m.f_104204_, m -> m.f_104205_);
        this.setModelSetters((m, x, y, z) -> {
            m.f_104200_ = x;
            m.f_104201_ = y;
            m.f_104202_ = z;
        }, (m, x, y, z) -> {
            m.f_104203_ = x;
            m.f_104204_ = y;
            m.f_104205_ = z;
        });
        this.setRenderPart(new ModelPart(Collections.emptyList(), Collections.emptyMap()));
    }

    public static void multiplyStacks(MatrixStack.Entry e, PoseStack stack) {
        stack.m_85850_().m_252922_().mul((Matrix4fc)new Matrix4f().setTransposed(e.getMatrixArray()));
        stack.m_85850_().m_252943_().mul((Matrix3fc)new Matrix3f().set(e.getNormalArray3()).transpose());
    }

    public static class RedirectModelRendererVanilla
    extends RedirectModelRendererBase {
        private PoseStack matrixStackIn;
        private VertexConsumer bufferIn;
        private int packedLightIn;
        private int packedOverlayIn;

        public RedirectModelRendererVanilla(RDH holder, Supplier<ModelPart> parent, VanillaModelPart part) {
            super(holder, parent, part);
        }

        public void m_104306_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            if (!this.holder.renderTypes.isInitialized()) {
                this.holder.copyModel(this, this.parent);
                this.parent.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                this.holder.logWarning();
                return;
            }
            this.matrixStackIn = matrixStackIn;
            this.bufferIn = bufferIn;
            this.packedLightIn = packedLightIn;
            this.packedOverlayIn = packedOverlayIn;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.buffers = this.holder.nextBatch(() -> new VBufferOut(packedLightIn, packedOverlayIn, matrixStackIn), bufferIn);
            this.render();
            this.matrixStackIn = null;
            this.bufferIn = null;
        }

        @Override
        public void renderParent() {
            this.parent.m_104306_(this.matrixStackIn, this.bufferIn, this.packedLightIn, this.packedOverlayIn, this.red, this.green, this.blue, this.alpha);
        }
    }

    public static abstract class RedirectModelRendererBase
    extends ModelPart
    implements ModelRenderManager.RedirectRenderer<ModelPart> {
        protected final RDH holder;
        protected final VanillaModelPart part;
        protected final Supplier<ModelPart> parentProvider;
        protected ModelPart parent;
        protected VBuffers buffers;
        protected float red;
        protected float green;
        protected float blue;
        protected float alpha;

        public RedirectModelRendererBase(RDH holder, Supplier<ModelPart> parent, VanillaModelPart part) {
            super(Collections.emptyList(), Collections.emptyMap());
            this.part = part;
            this.holder = holder;
            this.parentProvider = parent;
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public ModelPart swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            this.holder.copyModel(this.parent, this);
            this.m_233560_(this.parent.m_233566_());
            return this;
        }

        @Override
        public ModelPart swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            ModelPart p = this.parent;
            this.parent = null;
            return p;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, ModelPart> getHolder() {
            return this.holder;
        }

        @Override
        public ModelPart getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public Vec4f getColor() {
            return new Vec4f(this.red, this.green, this.blue, this.alpha);
        }

        public void m_104299_(PoseStack stack) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e, stack);
            } else {
                super.m_104299_(stack);
            }
        }

        public ModelPart.Cube m_233558_(RandomSource pRandom) {
            if (this.parent != null) {
                return this.parent.m_233558_(pRandom);
            }
            return super.m_233558_(pRandom);
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, HumanoidModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102810_, v -> {
                model.f_102810_ = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102813_, v -> {
                model.f_102813_ = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102814_, v -> {
                model.f_102814_ = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, HumanoidModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102808_, v -> {
                model.f_102808_ = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102810_, v -> {
                model.f_102810_ = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102811_, v -> {
                model.f_102811_ = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102812_, v -> {
                model.f_102812_ = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102813_, v -> {
                model.f_102813_ = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102814_, v -> {
                model.f_102814_ = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102809_, v -> {
                model.f_102809_ = v;
            }, null));
        }
    }

    private static class RedirectHolderElytra
    extends RDH {
        public RedirectHolderElytra(PlayerRenderManager mngr, ElytraModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102532_, v -> {
                model.f_102532_ = v;
            }, RootModelType.ELYTRA_RIGHT));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102533_, v -> {
                model.f_102533_ = v;
            }, RootModelType.ELYTRA_LEFT));
        }
    }

    private static class RedirectHolderSkull
    extends RDH {
        public RedirectHolderSkull(PlayerRenderManager mngr, SkullModel model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103804_, v -> {
                model.f_170943_.f_104213_.put("head", v);
                model.f_103804_ = v;
                if (model.f_170943_ instanceof ModelPartOF) {
                    ((ModelPartOF)model.f_170943_).cpm$updateChildModelsList();
                }
            }, PlayerModelParts.HEAD));
        }
    }

    private static class RedirectHolderApi
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelPart> head = this.registerHead(new ModelRenderManager.Field<ModelPart>(() -> model.f_102808_, v -> {
            model.f_102808_ = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderApi(PlayerRenderManager mngr, HumanoidModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102810_, v -> {
                model.f_102810_ = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102811_, v -> {
                model.f_102811_ = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102812_, v -> {
                model.f_102812_ = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102813_, v -> {
                model.f_102813_ = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102814_, v -> {
                model.f_102814_ = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102809_, v -> {
                model.f_102809_ = v;
            }, null)).setCopyFrom(this.head);
            if (model instanceof PlayerModel) {
                PlayerModel mp = (PlayerModel)model;
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.f_103374_, v -> {
                    mp.f_103374_ = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.f_103375_, v -> {
                    mp.f_103375_ = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.f_103376_, v -> {
                    mp.f_103376_ = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.f_103377_, v -> {
                    mp.f_103377_ = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.f_103378_, v -> {
                    mp.f_103378_ = v;
                }, null));
                this.register(new ModelRenderManager.Field<ModelPart>(() -> mp.f_103373_, v -> {
                    mp.f_103373_ = v;
                }, RootModelType.CAPE));
            }
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<ModelPart> head = this.registerHead(new ModelRenderManager.Field<ModelPart>(() -> model.f_102808_, v -> {
            model.f_102808_ = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderPlayer(PlayerRenderManager mngr, PlayerModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102810_, v -> {
                model.f_102810_ = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102811_, v -> {
                model.f_102811_ = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102812_, v -> {
                model.f_102812_ = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102813_, v -> {
                model.f_102813_ = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102814_, v -> {
                model.f_102814_ = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_102809_, v -> {
                model.f_102809_ = v;
            }, null)).setCopyFrom(this.head);
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103374_, v -> {
                model.f_103374_ = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103375_, v -> {
                model.f_103375_ = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103376_, v -> {
                model.f_103376_ = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103377_, v -> {
                model.f_103377_ = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103378_, v -> {
                model.f_103378_ = v;
            }, null));
            this.register(new ModelRenderManager.Field<ModelPart>(() -> model.f_103373_, v -> {
                model.f_103373_ = v;
            }, RootModelType.CAPE));
        }
    }

    public static abstract class RDH
    extends ModelRenderManager.RedirectHolder<Model, MultiBufferSource, ModelTexture, ModelPart> {
        public RDH(ModelRenderManager<MultiBufferSource, ModelTexture, ModelPart, Model> mngr, Model model) {
            super(mngr, model);
            this.batch = new BatchedBuffers<MultiBufferSource, RenderType, VertexConsumer>(this, MultiBufferSource::m_6299_);
        }

        @Override
        public void setupRenderSystem(ModelTexture cbi, TextureSheetType tex) {
            CustomPlayerModelsClient.mc.renderBuilder.build((RenderTypes<RenderMode>)this.renderTypes, (ResourceLocation)cbi);
        }

        @Override
        protected void bindTexture(ModelTexture cbi, TextureProvider skin) {
            skin.bind();
            OptifineTexture.applyOptifineTexture(cbi.getTexture(), skin);
            cbi.setTexture(MinecraftObject.DynTexture.getBoundLoc());
        }

        @Override
        public void swapOut0() {
        }

        @Override
        public void swapIn0() {
        }
    }
}

