/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;

public class AnimationHandler {
    private final Supplier<ModelDefinition> player;
    private final AnimationEngine.AnimationMode mode;
    private List<PlayingAnim> currentAnimations = new ArrayList<PlayingAnim>();
    private List<NextAnim> nextAnims = new ArrayList<NextAnim>();
    private Gesture currentGesture;

    public AnimationHandler(Supplier<ModelDefinition> player, AnimationEngine.AnimationMode mode) {
        this.player = player;
        this.mode = mode;
    }

    public void animate(AnimationState state, long currentTime) {
        boolean needsSort = false;
        this.currentAnimations.removeIf(a -> this.nextAnims.stream().noneMatch(n -> n.animation == a.currentAnimation) && a.currentAnimation.checkAndUpdateRemove(this.mode));
        for (NextAnim animation : this.nextAnims) {
            boolean found = false;
            for (int i = 0; i < this.currentAnimations.size(); ++i) {
                if (this.currentAnimations.get((int)i).currentAnimation != animation.animation) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.currentAnimations.add(new PlayingAnim(animation, currentTime, this.currentGesture != null ? (this.currentGesture.animation.contains(animation.animation) ? this.currentGesture.isLoop : true) : true, this.mode));
            needsSort = true;
        }
        if (needsSort) {
            this.currentAnimations.sort(Comparator.comparingInt(e -> e.currentAnimation.getPriority(this.mode)));
        }
        this.player.get().resetAnimationPos();
        for (PlayingAnim a2 : this.currentAnimations) {
            if (a2.finished) continue;
            long currentStep = currentTime - a2.currentStart;
            a2.currentAnimation.animate(a2.getTime(state, currentStep), this.player.get(), this.mode);
            if (a2.loop || currentStep <= (long)a2.currentAnimation.getDuration(this.mode)) continue;
            a2.finished = true;
        }
        this.nextAnims.clear();
    }

    public void addAnimations(List<? extends IAnimation> next, IPose pose) {
        Player<?> pl = this.player.get().getPlayerObj();
        next.stream().filter(a -> a.canPlay(pl, this.mode)).map(a -> new NextAnim((IAnimation)a, pose)).forEach(this.nextAnims::add);
    }

    public void setGesture(Gesture next) {
        this.currentGesture = next;
        if (next != null) {
            this.addAnimations(next.animation, null);
        }
    }

    public void clear() {
        this.currentGesture = null;
        this.nextAnims.clear();
        this.currentAnimations.clear();
    }

    private static class NextAnim {
        private IAnimation animation;
        private IPose pose;

        public NextAnim(IAnimation animation, IPose pose) {
            this.animation = animation;
            this.pose = pose;
        }
    }

    private static class PlayingAnim {
        private IAnimation currentAnimation;
        private IPose pose;
        private long currentStart;
        private boolean loop;
        private boolean finished;

        public PlayingAnim(NextAnim anim, long currentStart, boolean loop, AnimationEngine.AnimationMode mode) {
            this.currentAnimation = anim.animation;
            this.currentAnimation.prepare(mode);
            this.pose = anim.pose;
            this.currentStart = currentStart;
            this.loop = loop;
            this.finished = false;
        }

        public long getTime(AnimationState state, long time) {
            if (this.pose == null) {
                return time;
            }
            return this.pose.getTime(state, time);
        }
    }
}

