/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class StagedAnimation {
    private Map<AnimationEngine.AnimationMode, Stage> currentStage = new EnumMap<AnimationEngine.AnimationMode, Stage>(AnimationEngine.AnimationMode.class);
    private List<Anim> pre = new ArrayList<Anim>();
    private List<Anim> play = new ArrayList<Anim>();
    private List<Anim> post = new ArrayList<Anim>();
    private List<IAnimation> all = new ArrayList<IAnimation>();

    public IAnimation addPre(IAnimation anim) {
        Anim a = new Anim(anim, Stage.SETUP);
        this.pre.add(a);
        this.all.add(a);
        return a;
    }

    public IAnimation addPlay(IAnimation anim) {
        if (anim instanceof Anim) {
            return anim;
        }
        Anim a = new Anim(anim, Stage.PLAY);
        this.play.add(a);
        this.all.add(a);
        return a;
    }

    public IAnimation addPost(IAnimation anim) {
        Anim a = new Anim(anim, Stage.FINISH);
        this.post.add(a);
        this.all.add(a);
        return a;
    }

    public List<IAnimation> getAll() {
        return this.all;
    }

    private class Anim
    implements IAnimation {
        private final IAnimation parent;
        private final Stage stage;
        private Map<AnimationEngine.AnimationMode, AnimData> data = new EnumMap<AnimationEngine.AnimationMode, AnimData>(AnimationEngine.AnimationMode.class);

        public Anim(IAnimation parent, Stage stage) {
            this.parent = parent;
            this.stage = stage;
        }

        @Override
        public int getDuration(AnimationEngine.AnimationMode mode) {
            if (this.stage == Stage.FINISH) {
                return Integer.MAX_VALUE;
            }
            return this.parent.getDuration(mode);
        }

        @Override
        public int getPriority(AnimationEngine.AnimationMode mode) {
            return this.parent.getPriority(mode);
        }

        @Override
        public void animate(long millis, ModelDefinition def, AnimationEngine.AnimationMode mode) {
            AnimData d = this.data.get((Object)mode);
            d.lastFrame = millis;
            if (StagedAnimation.this.currentStage.get((Object)mode) == this.stage) {
                if (this.stage == Stage.FINISH && d.lastFrame >= d.offset + (long)this.parent.getDuration(mode)) {
                    return;
                }
                if (this.stage == Stage.SETUP && millis - d.offset >= (long)this.parent.getDuration(mode)) {
                    d.finished = true;
                    if (StagedAnimation.this.pre.stream().allMatch(a -> a.data.get((Object)((Object)((Object)mode))).finished)) {
                        StagedAnimation.this.currentStage.put(mode, Stage.PLAY);
                    }
                } else {
                    this.parent.animate(millis - d.offset, def, mode);
                }
            } else {
                d.offset = millis;
            }
        }

        @Override
        public boolean checkAndUpdateRemove(AnimationEngine.AnimationMode mode) {
            AnimData d = this.data.get((Object)mode);
            if (d == null) {
                return true;
            }
            if (this.stage == Stage.FINISH) {
                StagedAnimation.this.currentStage.put(mode, Stage.FINISH);
                if (d.lastFrame >= d.offset + (long)this.parent.getDuration(mode)) {
                    d.offset = 0L;
                    return true;
                }
                return false;
            }
            d.finished = false;
            d.offset = 0L;
            return true;
        }

        @Override
        public void prepare(AnimationEngine.AnimationMode mode) {
            StagedAnimation.this.currentStage.put(mode, StagedAnimation.this.pre.isEmpty() ? Stage.PLAY : Stage.SETUP);
            StagedAnimation.this.all.forEach(a -> ((Anim)a).reset(mode));
        }

        private void reset(AnimationEngine.AnimationMode mode) {
            AnimData d = this.data.get((Object)mode);
            if (d == null) {
                d = new AnimData();
                this.data.put(mode, d);
            }
            d.offset = 0L;
            d.finished = false;
        }
    }

    public static enum Stage {
        SETUP,
        PLAY,
        FINISH;

    }

    private static class AnimData {
        private long offset;
        private long lastFrame;
        private boolean finished;

        private AnimData() {
        }
    }
}

