/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.google.common.collect.Multimap;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.EnumMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public abstract class Player<P> {
    private static boolean enableRendering = true;
    private static boolean enableNames = true;
    private CompletableFuture<ModelDefinition> definition;
    private EnumMap<AnimationEngine.AnimationMode, AnimationHandler> animHandler = new EnumMap(AnimationEngine.AnimationMode.class);
    private PlayerTextureLoader textures;
    public AnimationState animState = new AnimationState();
    public VanillaPose prevPose;
    public IPose currentPose;
    public boolean forcedSkin;
    public boolean sentEventSubs;
    public String unique;

    public PlayerTextureLoader getTextures() {
        if (this.textures == null) {
            this.textures = this.initTextures();
            this.textures.load();
        }
        return this.textures;
    }

    public abstract SkinType getSkinType();

    protected abstract PlayerTextureLoader initTextures();

    public abstract String getName();

    public abstract UUID getUUID();

    public abstract void updateFromPlayer(P var1);

    public abstract Object getGameProfile();

    public abstract void updateFromModel(Object var1);

    public void updatePlayer(P player) {
        this.updateFromPlayer(player);
        NetHandler<?, ?, ?> net = MinecraftClientAccess.get().getNetHandler();
        net.updatePlayer(player, this.animState.localState);
        this.animState.speakLevel = (float)MinecraftCommonAccess.get().getApi().clientApi().getVoiceProviders().stream().mapToDouble(f -> f.apply(player)).max().orElse(0.0);
        this.animState.voiceMuted = MinecraftCommonAccess.get().getApi().clientApi().getVoiceMutedProviders().stream().anyMatch(p -> p.test(player));
    }

    public void setModelDefinition(CompletableFuture<ModelDefinition> definition) {
        this.definition = definition.exceptionally(e -> new ModelDefinition((Throwable)e, (Player<?>)this));
    }

    public ModelDefinition getModelDefinition0() {
        try {
            return enableRendering && this.definition != null ? (ModelDefinition)this.definition.getNow(null) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ModelDefinition getModelDefinition() {
        ModelDefinition def = this.getModelDefinition0();
        if (def != null) {
            if (def.getResolveState() == ModelDefinition.ModelLoadingState.NEW) {
                def.startResolve();
            } else if (def.getResolveState() == ModelDefinition.ModelLoadingState.LOADED && def.doRender()) {
                return def;
            }
        }
        return null;
    }

    public CompletableFuture<ModelDefinition> getDefinitionFuture() {
        return this.definition;
    }

    public AnimationHandler getAnimationHandler(AnimationEngine.AnimationMode mode) {
        return this.animHandler.computeIfAbsent(mode, k -> new AnimationHandler(this::getModelDefinition, (AnimationEngine.AnimationMode)((Object)k)));
    }

    public static boolean isEnableRendering() {
        return enableRendering;
    }

    public static void setEnableRendering(boolean enableRendering) {
        Player.enableRendering = enableRendering;
    }

    public static boolean isEnableNames() {
        return enableNames;
    }

    public static void setEnableNames(boolean enableNames) {
        Player.enableNames = enableNames;
    }

    public static boolean isEnableLoadingInfo() {
        return ModConfig.getCommonConfig().getBoolean("showLoadingInfo", true);
    }

    public void cleanup() {
        ModelDefinition def = this.getModelDefinition0();
        if (def != null) {
            MinecraftClientAccess.get().executeOnGameThread(def::cleanup);
        }
    }

    public boolean isClientPlayer() {
        return this.getUUID().equals(MinecraftClientAccess.get().getCurrentClientPlayer().getUUID());
    }

    public void sendEventSubs() {
        ModelDefinition def = this.getModelDefinition();
        if (!this.sentEventSubs && def != null) {
            this.sentEventSubs = true;
            MinecraftClientAccess.get().getNetHandler().sendEventSubs(def);
        }
    }

    public static <P> void cloneProperties(Multimap<String, P> from, Multimap<String, P> to) {
        try {
            if (from.containsKey((Object)"textures")) {
                to.putAll((Object)"textures", (Iterable)from.get((Object)"textures"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

