/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec3i;
import com.tom.cpm.shared.editor.CopyTransformEffect;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.Effect;
import com.tom.cpm.shared.editor.FormatLimits;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.MultiSelector;
import com.tom.cpm.shared.editor.elements.RootGroups;
import com.tom.cpm.shared.editor.gui.ModeDisplayType;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import com.tom.cpm.shared.editor.gui.popup.CopyTransformSettingsPopup;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.editor.util.QuickTask;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ItemRenderer;
import com.tom.cpm.shared.model.render.PerFaceUV;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelElement
extends Cube
implements IElem,
TreeElement {
    private static final Pattern DUP_PATTERN = Pattern.compile("(.*) \\((\\d+)\\)$");
    private static boolean movePopupShown = false;
    public Editor editor;
    public String name;
    public ModelElement parent;
    public List<ModelElement> children = new ArrayList<ModelElement>();
    public ElementType type;
    public Object typeData;
    public RenderedCube rc;
    public boolean showInEditor = true;
    public boolean texture;
    public boolean mirror;
    public int textureSize;
    public boolean glow;
    public boolean recolor;
    public boolean singleTex;
    public boolean extrude;
    public long storeID;
    public boolean templateElement;
    public boolean generated;
    public boolean duplicated;
    public boolean disableVanillaAnim;
    public boolean locked;
    public PerFaceUV faceUV;
    public ItemRenderer itemRenderer;
    public CopyTransformEffect copyTransform;
    public Mat4f matrixPosition;
    public int partNameColor;

    public ModelElement(ModelElement element, ModelElement parent) {
        this(element.editor);
        this.parent = parent;
        element.children.forEach(c -> this.children.add(new ModelElement((ModelElement)c, this)));
        if (element.itemRenderer == null) {
            int count;
            String nm;
            Matcher m = DUP_PATTERN.matcher(element.name);
            if (m.find()) {
                nm = m.group(1);
                try {
                    count = Integer.parseInt(m.group(2)) + 1;
                }
                catch (NumberFormatException e) {
                    count = 2;
                }
            } else {
                nm = element.name;
                count = 2;
            }
            this.name = nm + " (" + count + ")";
        } else {
            this.name = element.name;
        }
        this.showInEditor = element.showInEditor;
        this.texture = element.texture;
        this.textureSize = element.textureSize;
        this.offset = new Vec3f(element.offset);
        this.pos = new Vec3f(element.pos);
        this.rotation = new Vec3f(element.rotation);
        this.size = new Vec3f(element.size);
        this.scale = new Vec3f(element.scale);
        this.u = element.u;
        this.v = element.v;
        this.rgb = element.rgb;
        this.mirror = element.mirror;
        this.mcScale = element.mcScale;
        this.glow = element.glow;
        this.recolor = element.recolor;
        this.hidden = element.hidden;
        this.singleTex = element.singleTex;
        this.extrude = element.extrude;
        if (element.faceUV != null) {
            this.faceUV = new PerFaceUV(element.faceUV);
        }
        if (element.itemRenderer != null) {
            this.itemRenderer = new ItemRenderer(element.itemRenderer);
        }
    }

    public ModelElement(Editor editor) {
        this(editor, ElementType.NORMAL, null);
    }

    @Deprecated
    public ModelElement(Editor editor, ElementType type, Object typeData, IGui gui) {
        this(editor, type, typeData);
    }

    public ModelElement(Editor editor, ElementType type, Object typeData) {
        this.type = type;
        this.typeData = typeData;
        this.editor = editor;
        type.buildElement(editor, this, typeData);
    }

    public void preRender() {
        this.type.preRenderUpdate(this);
        this.children.forEach(ModelElement::preRender);
    }

    public void postRender() {
        if (this.copyTransform != null) {
            this.copyTransform.apply();
        }
        this.children.forEach(ModelElement::postRender);
    }

    @Override
    public Vec3f getPosition() {
        return this.pos;
    }

    @Override
    public Vec3f getRotation() {
        return this.rotation;
    }

    @Override
    public Vec3f getScale() {
        return new Vec3f(1.0f, 1.0f, 1.0f);
    }

    @Override
    public Vec3f getColor() {
        int r = (this.rgb & 0xFF0000) >> 16;
        int g = (this.rgb & 0xFF00) >> 8;
        int b = this.rgb & 0xFF;
        return new Vec3f(r, g, b);
    }

    @Override
    public boolean isVisible() {
        return !this.hidden;
    }

    @Override
    public String getName() {
        String name = this.name;
        if (this.type == ElementType.ROOT_PART) {
            String n = this.editor.ui.i18nFormat("label.cpm.elem." + ((VanillaModelPart)this.typeData).getName(), new Object[0]);
            if (this.duplicated) {
                n = this.editor.ui.i18nFormat("label.cpm.tree.duplicated", n);
            }
            name = name.isEmpty() ? n : this.editor.ui.i18nFormat("label.cpm.tree.renamedRoot", name, n);
        }
        if (this.hidden) {
            name = this.editor.ui.i18nFormat("label.cpm.tree.hidden", name);
        }
        if (this.copyTransform != null) {
            name = this.editor.ui.i18nFormat("label.cpm.copyTransformFlag", name);
        }
        if (this.disableVanillaAnim) {
            name = this.editor.ui.i18nFormat("label.cpm.tree.disableVanillaAnim", name);
        }
        return name;
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        for (ModelElement e : this.children) {
            if (e.templateElement) continue;
            c.accept(e);
        }
    }

    @Override
    public int textColor(IGui gui) {
        if (this.itemRenderer != null && this.editor.definition.rendererObjectMap.get(this.itemRenderer) == this.itemRenderer) {
            return gui.getColors().link_normal;
        }
        int p = this.partNameColor & 0xFFFFFF;
        if (p != 0) {
            return p | 0xFF000000;
        }
        return !this.showInEditor || this.locked ? gui.getColors().button_text_disabled : 0;
    }

    @Override
    public void accept(TreeElement elem) {
        this.editor.moveElement((ModelElement)elem, this);
    }

    @Override
    public boolean canAccept(TreeElement elem) {
        return !this.locked && elem instanceof ModelElement;
    }

    @Override
    public boolean canMove() {
        return !this.locked && this.type == ElementType.NORMAL;
    }

    public void markDirty() {
        this.rc.updateObject = true;
    }

    @Override
    public void setVec(Vec3f v, VecType object) {
        if (this.locked) {
            return;
        }
        if (this.type == ElementType.ROOT_PART && this.generated && object == VecType.POSITION && !movePopupShown) {
            movePopupShown = true;
            this.editor.ui.displayMessagePopup(this.editor.ui.i18nFormat("label.cpm.info", new Object[0]), this.editor.ui.i18nFormat("label.cpm.warnMoveGenPart", new Object[0]));
        }
        switch (object) {
            case SIZE: {
                v.round(10);
                this.editor.action("set", "label.cpm.size").updateValueOp(this, this.size, v, 0, FormatLimits.getSizeLimit(), false, (a, b) -> {
                    a.size = b;
                }, this.editor.setSize).onAction(this::markDirty).execute();
                break;
            }
            case OFFSET: {
                this.editor.action("set", "label.cpm.offset").updateValueOp(this, this.offset, v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, (a, b) -> {
                    a.offset = b;
                }, this.editor.setOffset).onAction(this::markDirty).execute();
                break;
            }
            case ROTATION: {
                this.editor.action("set", "label.cpm.rotation").updateValueOp(this, this.rotation, v, 0, 360, true, (a, b) -> {
                    a.rotation = b;
                }, this.editor.setRot).execute();
                break;
            }
            case POSITION: {
                this.editor.action("set", "label.cpm.position").updateValueOp(this, this.pos, v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, (a, b) -> {
                    a.pos = b;
                }, this.editor.setPosition).execute();
                break;
            }
            case SCALE: {
                this.editor.action("set", "label.cpm.scale").updateValueOp(this, this.scale, v, 0, FormatLimits.getSizeLimit(), false, (a, b) -> {
                    a.scale = b;
                }, this.editor.setScale).onAction(this::markDirty).execute();
                break;
            }
            case TEXTURE: {
                this.editor.action("set", "action.cpm.texUV").updateValueOp(this, this.u, (int)v.x, 0, Integer.MAX_VALUE, (a, b) -> {
                    a.u = b;
                }, __ -> this.editor.setTexturePanel.accept(new Vec3i(this.u, this.v, this.textureSize))).updateValueOp(this, this.v, (int)v.y, 0, Integer.MAX_VALUE, (a, b) -> {
                    a.v = b;
                }, __ -> this.editor.setTexturePanel.accept(new Vec3i(this.u, this.v, this.textureSize))).updateValueOp(this, this.textureSize, (int)v.z, 0, 64, (a, b) -> {
                    a.textureSize = b;
                }, __ -> this.editor.setTexturePanel.accept(new Vec3i(this.u, this.v, this.textureSize))).onAction(this::markDirty).execute();
                break;
            }
        }
    }

    @Override
    public Vec3f getVec(VecType v) {
        switch (v) {
            case OFFSET: {
                return new Vec3f(this.offset);
            }
            case POSITION: {
                return new Vec3f(this.pos);
            }
            case ROTATION: {
                return new Vec3f(this.rotation);
            }
            case SCALE: {
                return new Vec3f(this.scale);
            }
            case SIZE: {
                return new Vec3f(this.size);
            }
            case TEXTURE: {
                return new Vec3f(this.u, this.v, this.textureSize);
            }
        }
        return null;
    }

    @Override
    public void setVecTemp(VecType vt, Vec3f v) {
        switch (vt) {
            case OFFSET: {
                ActionBuilder.limitVec(v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false);
                this.offset = v;
                this.editor.setOffset.accept(this.offset);
                this.markDirty();
                break;
            }
            case POSITION: {
                ActionBuilder.limitVec(v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false);
                this.pos = v;
                this.editor.setPosition.accept(this.pos);
                break;
            }
            case ROTATION: {
                ActionBuilder.limitVec(v, 0, 360, true);
                this.rotation = v;
                this.editor.setRot.accept(this.rotation);
                break;
            }
            case SCALE: {
                ActionBuilder.limitVec(v, 0, FormatLimits.getSizeLimit(), false);
                this.scale = v;
                this.editor.setScale.accept(this.scale);
                this.markDirty();
                break;
            }
            case SIZE: {
                ActionBuilder.limitVec(v, 0, FormatLimits.getSizeLimit(), false);
                v.round(10);
                this.size = v;
                this.editor.setSize.accept(this.size);
                this.markDirty();
                break;
            }
            case TEXTURE: {
                this.u = Math.max((int)v.x, 0);
                this.v = Math.max((int)v.y, 0);
                this.textureSize = Math.max((int)v.z, 1);
                this.editor.setTexturePanel.accept(new Vec3i(this.u, this.v, this.textureSize));
                this.markDirty();
                break;
            }
        }
    }

    @Override
    public void setElemName(String name) {
        this.name = name;
    }

    @Override
    public String getElemName() {
        return this.name;
    }

    @Override
    public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
        if (this.locked) {
            return;
        }
        if (this.texture && (this.showInEditor || this.editor.selectedElement == this)) {
            TextureDisplay.drawBoxTextureOverlay(gui, this, x, y, xs, ys, TextureDisplay.getAlphaForBox(this.editor.selectedElement == this));
        }
    }

    @Override
    public ETextures getTexture() {
        ETextures tex;
        RootGroups gr;
        if (this.type == ElementType.ROOT_PART && this.typeData instanceof RootModelType && (gr = RootGroups.getGroup((RootModelType)this.typeData)) != null && (tex = this.editor.textures.get((Object)gr.getTexSheet((RootModelType)this.typeData))) != null) {
            return tex;
        }
        if (this.parent != null) {
            return this.parent.getTexture();
        }
        return this.editor.textures.get((Object)TextureSheetType.SKIN);
    }

    @Override
    public void modeSwitch() {
        this.editor.action("switch", "action.cpm.cubeMode").updateValueOp(this, this.texture, !this.texture, (a, b) -> {
            a.texture = b;
        }).onAction(this::markDirty).execute();
        this.editor.updateGui();
    }

    @Override
    public void updateGui() {
        this.editor.setVis.accept(this.showInEditor);
        this.editor.setAddEn.accept(!this.templateElement && this.itemRenderer == null);
        switch (this.type) {
            case NORMAL: {
                this.editor.setOffset.accept(this.offset);
                this.editor.setRot.accept(this.rotation);
                this.editor.setPosition.accept(this.pos);
                if (this.itemRenderer == null) {
                    this.editor.setSize.accept(this.size);
                }
                this.editor.setScale.accept(this.scale);
                if (this.itemRenderer == null) {
                    this.editor.setMCScale.accept(Float.valueOf(this.mcScale));
                    this.editor.setMirror.accept(this.mirror);
                    this.editor.setModeBtn.accept(this.texture ? this.editor.ui.i18nFormat("button.cpm.mode.tex", new Object[0]) : this.editor.ui.i18nFormat("button.cpm.mode.color", new Object[0]));
                    this.editor.setModePanel.accept(this.faceUV != null ? ModeDisplayType.TEX_FACE : (this.texture ? ModeDisplayType.TEX : ModeDisplayType.COLOR));
                    this.editor.setTexturePanel.accept(new Vec3i(this.u, this.v, this.textureSize));
                    if (!this.texture || this.recolor) {
                        this.editor.setPartColor.accept(this.rgb);
                    }
                }
                this.editor.setCopyTransformEffect.accept(this.copyTransform != null);
                this.editor.setDelEn.accept(!this.templateElement);
                this.editor.setHiddenEffect.accept(this.hidden);
                if (this.itemRenderer != null) break;
                this.editor.setGlow.accept(this.glow);
                if (this.texture) {
                    this.editor.setReColor.accept(this.recolor);
                    if (this.faceUV == null) {
                        this.editor.setSingleTex.accept(this.singleTex);
                        this.editor.setExtrudeEffect.accept(this.extrude);
                    } else {
                        this.editor.setFaceRot.accept(this.faceUV.getRot(this.editor.perfaceFaceDir.get()));
                        this.editor.setFaceUVs.accept(this.faceUV.getVec(this.editor.perfaceFaceDir.get()));
                        this.editor.setAutoUV.accept(this.faceUV.isAutoUV(this.editor.perfaceFaceDir.get()));
                        this.editor.setSingleTex.accept(null);
                    }
                    if (!this.singleTex) {
                        this.editor.setPerFaceUV.accept(this.faceUV != null);
                    } else {
                        this.editor.setPerFaceUV.accept(null);
                    }
                }
                this.editor.updateName.accept(this.name);
                break;
            }
            case ROOT_PART: {
                this.editor.setPosition.accept(this.pos);
                this.editor.setRot.accept(this.rotation);
                this.editor.setHiddenEffect.accept(this.hidden);
                this.editor.setDelEn.accept(this.duplicated || this.typeData instanceof RootModelType);
                this.editor.setDisableVanillaEffect.accept(this.disableVanillaAnim);
                this.editor.updateName.accept(this.name);
                break;
            }
        }
    }

    @Override
    public void addNew() {
        if (this.templateElement) {
            return;
        }
        ModelElement elem = new ModelElement(this.editor);
        elem.parent = this;
        this.editor.selectedElement = elem;
        this.editor.action("add", "action.cpm.cube").addToList(this.children, elem).execute();
        this.editor.updateGui();
    }

    @Override
    public void delete() {
        if (this.templateElement) {
            return;
        }
        if (this.type == ElementType.NORMAL || this.duplicated || this.typeData instanceof RootModelType) {
            List<ModelElement> lst = this.type == ElementType.NORMAL ? this.parent.children : this.editor.elements;
            ActionBuilder ab = this.editor.action("remove", "action.cpm.cube").removeFromList(lst, this).onRun(() -> {
                this.editor.selectedElement = null;
            });
            ArrayList<ModelElement> allRemoved = new ArrayList<ModelElement>();
            allRemoved.add(this);
            Editor.walkElements(this.children, allRemoved::add);
            this.editor.animations.stream().flatMap(a -> a.getFrames().stream()).forEach(f -> allRemoved.forEach(e -> f.clearSelectedData(ab, (ModelElement)e)));
            ab.onAction(() -> this.editor.animations.forEach(EditorAnim::clearCache));
            ab.execute();
            this.editor.updateGui();
        }
    }

    @Override
    public void setElemColor(int color) {
        this.editor.action("set", "action.cpm.color").updateValueOp(this, this.rgb, color, (a, b) -> {
            a.rgb = b;
        }, this.editor.setPartColor).onAction(this::markDirty).execute();
    }

    @Override
    public void setMCScale(float value) {
        this.editor.action("set", "label.cpm.mcScale").updateValueOp(this, Float.valueOf(this.mcScale), Float.valueOf(value), Float.valueOf(-7.0f), Float.valueOf(7.0f), (a, b) -> {
            a.mcScale = b.floatValue();
        }, this.editor.setMCScale).onAction(this::markDirty).execute();
    }

    @Override
    public void switchVis() {
        this.showInEditor = !this.showInEditor;
        this.editor.setVis.accept(this.showInEditor);
    }

    @Override
    public void switchEffect(Effect effect) {
        switch (effect) {
            case GLOW: {
                this.editor.action("switch", "label.cpm.glow").updateValueOp(this, this.glow, !this.glow, (a, b) -> {
                    a.glow = b;
                }, this.editor.setGlow).execute();
                break;
            }
            case HIDE: {
                this.editor.action("switch", "label.cpm.hidden_effect").updateValueOp(this, this.hidden, !this.hidden, (a, b) -> {
                    a.hidden = b;
                }, this.editor.setHiddenEffect).execute();
                this.editor.treeHandler.update();
                this.editor.updateGui.accept(null);
                break;
            }
            case MIRROR: {
                this.editor.action("switch", "label.cpm.mirror").updateValueOp(this, this.mirror, !this.mirror, (a, b) -> {
                    a.mirror = b;
                }, this.editor.setMirror).onAction(this::markDirty).execute();
                break;
            }
            case RECOLOR: {
                this.editor.action("switch", "label.cpm.recolor").updateValueOp(this, this.recolor, !this.recolor, (a, b) -> {
                    a.recolor = b;
                }, this.editor.setReColor).onAction(this::markDirty).execute();
                if (!this.texture || this.recolor) {
                    this.editor.setPartColor.accept(this.rgb);
                    break;
                }
                this.editor.setPartColor.accept(null);
                break;
            }
            case SINGLE_TEX: {
                this.editor.action("switch", "label.cpm.singleTex").updateValueOp(this, this.singleTex, !this.singleTex, (a, b) -> {
                    a.singleTex = b;
                }, this.editor.setSingleTex).onAction(this::markDirty).execute();
                break;
            }
            case EXTRUDE: {
                this.editor.action("switch", "label.cpm.extrude_effect").updateValueOp(this, this.extrude, !this.extrude, (a, b) -> {
                    a.extrude = b;
                }, this.editor.setExtrudeEffect).onAction(this::markDirty).execute();
                break;
            }
            case PER_FACE_UV: {
                this.editor.action("switch", "label.cpm.perfaceUV").updateValueOp(this, this.texture, true, (a, b) -> {
                    a.texture = b;
                }).update(this.editor.setModePanel, ModeDisplayType.TEX_FACE).updateValueOp(this, this.faceUV, this.faceUV == null ? new PerFaceUV(this) : null, (a, b) -> {
                    a.faceUV = b;
                }, v -> this.editor.setPerFaceUV.accept(v != null)).onAction(this::markDirty).execute();
                this.editor.updateGui();
                break;
            }
            case COPY_TRANSFORM: {
                this.editor.action("switch", "label.cpm.copyTransform").updateValueOp(this, this.copyTransform, this.copyTransform == null ? new CopyTransformEffect(this) : null, (a, b) -> {
                    a.copyTransform = b;
                }, v -> this.editor.setCopyTransformEffect.accept(v != null)).execute();
                this.editor.updateGui();
                if (this.copyTransform == null) break;
                this.editor.ui.displayPopup(f -> new CopyTransformSettingsPopup((Frame)f, this.editor, this.copyTransform));
                break;
            }
            case DISABLE_VANILLA_ANIM: {
                if (this.type != ElementType.ROOT_PART) break;
                this.editor.action("switch", "label.cpm.disableVanillaAnim").updateValueOp(this, this.disableVanillaAnim, !this.disableVanillaAnim, (a, b) -> {
                    a.disableVanillaAnim = b;
                }).execute();
                this.editor.updateGui();
                break;
            }
        }
    }

    @Override
    public Box getTextureBox() {
        if (this.locked) {
            return null;
        }
        if (this.type == ElementType.ROOT_PART) {
            PartValues pv = ((VanillaModelPart)this.typeData).getDefaultSize(this.editor.skinType);
            Vec3f size = pv.getSize();
            Vec2i uv = pv.getUV();
            int dx = MathHelper.ceil(size.x);
            int dy = MathHelper.ceil(size.y);
            int dz = MathHelper.ceil(size.z);
            EditorTexture skin = this.getTexture().provider;
            return new Box((int)((float)uv.x / 64.0f * (float)skin.size.x), (int)((float)uv.y / 64.0f * (float)skin.size.y), (int)((float)(2 * (dx + dz)) / 64.0f * (float)skin.size.x), (int)((float)(dz + dy) / 64.0f * (float)skin.size.y));
        }
        if (!this.texture) {
            return new Box(0, 0, 0, 0);
        }
        int dx = MathHelper.ceil(this.size.x);
        int dy = MathHelper.ceil(this.size.y);
        int dz = MathHelper.ceil(this.size.z);
        if (this.extrude) {
            return new Box(this.u * this.textureSize, this.v * this.textureSize, dx * this.textureSize, dy * this.textureSize);
        }
        if (this.singleTex) {
            if (this.mcScale == 0.0f && (this.size.x == 0.0f || this.size.y == 0.0f || this.size.z == 0.0f)) {
                if (this.size.x == 0.0f) {
                    return new Box(this.u * this.textureSize, this.v * this.textureSize, dz * this.textureSize, dy * this.textureSize);
                }
                if (this.size.y == 0.0f) {
                    return new Box(this.u * this.textureSize, this.v * this.textureSize, dx * this.textureSize, dz * this.textureSize);
                }
                if (this.size.z == 0.0f) {
                    return new Box(this.u * this.textureSize, this.v * this.textureSize, dx * this.textureSize, dy * this.textureSize);
                }
            }
            int txS = Math.max(dx, Math.max(dy, dz));
            return new Box(this.u * this.textureSize, this.v * this.textureSize, txS * this.textureSize, txS * this.textureSize);
        }
        if (this.faceUV != null) {
            return null;
        }
        return new Box(this.u * this.textureSize, this.v * this.textureSize, 2 * (dx + dz) * this.textureSize, (dz + dy) * this.textureSize);
    }

    @Override
    public void populatePopup(PopupMenu popup) {
        if (this.locked) {
            popup.addButton(this.editor.ui.i18nFormat("button.cpm.unlock", new Object[0]), () -> {
                this.locked = false;
                this.editor.updateGui();
            });
            return;
        }
        popup.addButton(this.editor.ui.i18nFormat("button.cpm.duplicate", new Object[0]), this::duplicate);
        if (this.type == ElementType.NORMAL && this.copyTransform != null) {
            popup.addButton(this.editor.ui.i18nFormat("button.cpm.editCopyTransform", new Object[0]), () -> popup.getGui().getFrame().openPopup(new CopyTransformSettingsPopup(popup.getGui().getFrame(), this.editor, this.copyTransform)));
        }
        Checkbox boxHidden = popup.addCheckbox(this.editor.ui.i18nFormat("label.cpm.hidden_effect", new Object[0]), () -> this.switchEffect(Effect.HIDE));
        boxHidden.setSelected(this.hidden);
        boxHidden.setTooltip(new Tooltip(popup.getGui().getFrame(), this.editor.ui.i18nFormat("tooltip.cpm.hidden_effect", new Object[0])));
        popup.addButton(this.editor.ui.i18nFormat("button.cpm.lock", new Object[0]), () -> {
            this.locked = true;
            this.editor.updateGui();
        });
        int p = this.partNameColor & 0xFFFFFF;
        ColorButton textColor = new ColorButton(popup.getGui(), this.editor.ui.i18nFormat("button.cpm.setNameColor", new Object[0]), popup.getGui().getFrame(), t -> {
            this.partNameColor = t;
        });
        textColor.setColor(p == 0 ? popup.getGui().getColors().label_text_color : p);
        popup.add(textColor);
    }

    private void duplicate() {
        if (this.type == ElementType.NORMAL) {
            elem = new ModelElement(this, this.parent);
            this.editor.action("duplicate").addToList(this.parent.children, elem).onUndo(() -> {
                this.editor.selectedElement = null;
            }).execute();
            this.editor.selectedElement = elem;
            this.editor.updateGui();
        } else if (this.type == ElementType.ROOT_PART) {
            elem = new ModelElement(this.editor, ElementType.ROOT_PART, this.typeData);
            elem.duplicated = true;
            elem.storeID = Math.abs(new Random().nextLong());
            this.editor.action("duplicate").addToList(this.editor.elements, elem).onUndo(() -> {
                this.editor.selectedElement = null;
            }).execute();
            this.editor.selectedElement = elem;
            this.editor.updateGui();
        }
        ModelElement el = this.editor.getSelectedElement();
        if (!this.editor.animations.isEmpty()) {
            this.editor.setQuickAction.accept(new QuickTask(this.editor.ui.i18nFormat("button.cpm.dupAnimations", new Object[0]), this.editor.ui.i18nFormat("tooltip.cpm.dupAnimations", new Object[0]), () -> {
                ActionBuilder ab = this.editor.action("duplicate");
                this.editor.animations.forEach(a -> a.getFrames().forEach(f -> this.dupAnim(ab, this, el, (AnimFrame)f)));
                ab.onAction(() -> this.editor.animations.forEach(EditorAnim::clearCache));
                ab.execute();
            }).add(this.editor.ui.i18nFormat("button.cpm.copyFromOriginal", new Object[0]), this.editor.ui.i18nFormat("tooltip.cpm.copyFromOriginal", new Object[0]), () -> this.addCts(el)));
        } else {
            this.editor.setQuickAction.accept(new QuickTask(this.editor.ui.i18nFormat("button.cpm.copyFromOriginal", new Object[0]), this.editor.ui.i18nFormat("tooltip.cpm.copyFromOriginal", new Object[0]), () -> this.addCts(el), true));
        }
    }

    private void addCts(ModelElement el) {
        ActionBuilder ab = this.editor.action("switch", "label.cpm.copyTransform");
        this.addCts(ab, this, el);
        ab.onAction(this.editor::updateGui);
        ab.execute();
    }

    private void addCts(ActionBuilder ab, ModelElement from, ModelElement to) {
        CopyTransformEffect c = new CopyTransformEffect(to);
        c.from = from;
        c.setAll(true);
        ab.updateValueOp(to, null, c, (a, b) -> {
            a.copyTransform = b;
        });
        for (int i = 0; i < from.children.size(); ++i) {
            ModelElement f = from.children.get(i);
            ModelElement t = to.children.get(i);
            this.addCts(ab, f, t);
        }
    }

    private void dupAnim(ActionBuilder ab, ModelElement from, ModelElement to, AnimFrame frm) {
        AnimFrame.FrameData fd = frm.getComponents().get(from);
        if (fd != null) {
            frm.importFrameData(ab, to, fd);
        }
        for (int i = 0; i < from.children.size(); ++i) {
            ModelElement f = from.children.get(i);
            ModelElement t = to.children.get(i);
            this.dupAnim(ab, f, t, frm);
        }
    }

    @Override
    public int bgColor(IGui gui) {
        if (this.editor.selectedElement != this) {
            ModelElement me = this.editor.getSelectedElement();
            if (me != null && me.copyTransform != null && me.copyTransform.from == this) {
                return gui.getColors().ct_src_background;
            }
            if (this.editor.selectedAnim != null && this.editor.applyAnim) {
                if (this.editor.selectedAnim.getSelectedFrame() != null && this.editor.selectedAnim.getSelectedFrame().getAllElementsFiltered().anyMatch(e -> e == this)) {
                    return gui.getColors().anim_part_background;
                }
                if (this.editor.selectedAnim.getComponentsFiltered().contains(this)) {
                    return gui.getColors().anim_part_background2;
                }
            }
        }
        return 0;
    }

    public ModelElement getRoot() {
        return this.type == ElementType.ROOT_PART ? this : (this.parent != null ? this.parent.getRoot() : null);
    }

    @Override
    public Tooltip getTooltip(IGui gui) {
        StringBuilder sb = new StringBuilder();
        if (this.copyTransform != null) {
            sb.append(this.copyTransform.getTooltip(this.editor.ui));
        }
        return sb.length() == 0 ? null : new Tooltip(gui.getFrame(), sb.toString());
    }

    @Override
    public void onClick(IGui gui, Editor e, MouseEvent evt) {
        if (this.locked) {
            return;
        }
        if (gui.isCtrlDown()) {
            if (e.selectedElement instanceof MultiSelector) {
                if (((MultiSelector)e.selectedElement).add(this)) {
                    e.selectedElement = null;
                }
            } else if (e.getSelectedElement() == null) {
                e.selectedElement = this;
            } else {
                MultiSelector.ElementImpl ms = new MultiSelector.ElementImpl(e);
                ms.add(e.getSelectedElement());
                ms.add(this);
                e.selectedElement = ms;
            }
        } else {
            e.selectedElement = this;
        }
    }

    @Override
    public boolean canEditVec(VecType type) {
        if (this.locked) {
            return false;
        }
        if (this.type == ElementType.ROOT_PART) {
            return type == VecType.POSITION || type == VecType.ROTATION;
        }
        if (this.itemRenderer != null) {
            return type == VecType.POSITION || type == VecType.ROTATION || type == VecType.SCALE || type == VecType.OFFSET;
        }
        return true;
    }

    @Override
    public List<TreeElement.TreeSettingElement> getSettingsElements() {
        if (this.locked) {
            return Collections.emptyList();
        }
        return this.faceUV != null ? this.faceUV.getDragBoxes(this) : Collections.emptyList();
    }

    @Override
    public boolean canSelect() {
        return !this.locked;
    }

    @Override
    public void drawName(IGui gui, int x, int y, int color) {
        if (this.locked) {
            gui.drawTexture(x, y, 8, 8, 16, 8, "editor", color);
        }
    }

    @Override
    public int getExtraWidth(IGui gui) {
        return this.locked ? 10 : 0;
    }
}

