/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tom.cpl.gui.UI;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.template.TemplateArgHandler;
import com.tom.cpm.shared.editor.util.ExportHelper;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.TextureSheetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class TemplateExporter {
    public static final Gson sgson = new GsonBuilder().serializeSpecialFloatingPointValues().create();

    public static void exportTemplate(Editor e, UI gui, ModelDescription desc, Consumer<String> templateOut) {
        try {
            ArrayList<Cube> flatList = new ArrayList<Cube>();
            ExportHelper.flattenElements(e.elements, new int[]{10000}, flatList);
            HashMap<String, Object> data = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> cubesList = new ArrayList<HashMap<String, Object>>();
            data.put("cubes", cubesList);
            HashMap cubeDataList = new HashMap();
            flatList.sort((a, b) -> Integer.compare(a.id, b.id));
            for (Cube cube : flatList) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                Cube.saveTemplateCube(m, cube);
                cubesList.add(m);
                HashMap dtMap = new HashMap();
                m.put("data", dtMap);
                m.put("id", cube.id);
                cubeDataList.put(cube.id, dtMap);
            }
            ExportHelper.walkElements(e.elements, el -> {
                if (el.type == ElementType.NORMAL && !el.templateElement) {
                    Map dt = (Map)cubeDataList.get(el.id);
                    dt.put("hidden", el.hidden);
                    dt.put("recolor", el.recolor);
                    dt.put("glow", el.glow);
                }
            });
            ArrayList argsList = new ArrayList();
            data.put("args", argsList);
            for (TemplateArgHandler a2 : e.templateSettings.templateArgs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                argsList.add(map);
                map.put("name", a2.name);
                map.put("desc", a2.desc);
                map.put("type", a2.type.baseType.name().toLowerCase(Locale.ROOT));
                map.put("elem_type", a2.type.name().toLowerCase(Locale.ROOT));
                HashMap<String, Object> d = new HashMap<String, Object>();
                a2.handler.export().export(d);
                map.put("data", d);
                a2.handler.applyArgs(data, a2.effectedElems);
            }
            if (e.textures.get((Object)TextureSheetType.SKIN).isEdited()) {
                IOHelper iOHelper = new IOHelper();
                e.textures.get((Object)TextureSheetType.SKIN).write(iOHelper);
                data.put("texture", iOHelper.toB64());
            }
            data.put("name", desc.name);
            data.put("desc", desc.desc);
            if (desc.icon != null) {
                try (IOHelper iOHelper = new IOHelper();){
                    iOHelper.writeImage(desc.icon);
                    data.put("icon", iOHelper.toB64());
                }
            }
            String string = sgson.toJson(data);
            templateOut.accept(string);
        }
        catch (Exporter.ExportException ex) {
            gui.displayMessagePopup(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("label.cpm.export_error", gui.i18nFormat(ex.getMessage(), new Object[0])));
        }
        catch (Exception ex) {
            gui.onGuiException("Error while exporting", ex, false);
        }
    }
}

