/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.render.PerFaceUV;
import java.io.IOException;

public class EffectPerFaceUV
implements IRenderEffect {
    private int id;
    private PerFaceUV uv;

    public EffectPerFaceUV() {
    }

    public EffectPerFaceUV(int id, PerFaceUV uv) {
        this.id = id;
        this.uv = uv;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        this.id = in.readVarInt();
        this.uv = new PerFaceUV();
        this.uv.readFaces(in);
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVarInt(this.id);
        this.uv.writeFaces(out);
    }

    @Override
    public void apply(ModelDefinition def) {
        RenderedCube cube = def.getElementById(this.id);
        if (cube != null) {
            cube.faceUVs = this.uv;
        }
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.PER_FACE_UV;
    }

    public String toString() {
        return "Per Face UV [" + this.id + "] " + this.uv;
    }
}

