/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.util.PlayerSkinLayer;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimatorChannel;
import com.tom.cpm.shared.parts.anim.ConstantTimeBool;
import com.tom.cpm.shared.parts.anim.ConstantTimeFloat;
import com.tom.cpm.shared.parts.anim.SerializedAnimation;
import com.tom.cpm.shared.parts.anim.SerializedTrigger;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AnimLoaderState {
    private Map<Integer, SerializedAnimation> anims = new HashMap<Integer, SerializedAnimation>();
    private Map<Integer, SerializedTrigger> triggers = new HashMap<Integer, SerializedTrigger>();
    private int trID = 0;
    private int anID = 0;
    private SerializedAnimation cA = null;
    private SerializedTrigger cT = null;
    private int blankId;
    private int resetId;
    private String modelProfilesId;
    private int defGidMask;
    private int valGidMask;
    private List<PlayerSkinLayer> allLayers;

    public SerializedTrigger getTrigger() {
        return this.cT;
    }

    public SerializedAnimation getAnim() {
        return this.cA;
    }

    public int newTrigger(SerializedTrigger tr) {
        int id = this.trID++;
        this.triggers.put(id, tr);
        this.cT = tr;
        return id;
    }

    public int newAnimation(SerializedAnimation an) {
        int id = this.anID++;
        this.anims.put(id, an);
        this.cA = an;
        return id;
    }

    public Map<Integer, SerializedAnimation> getAnims() {
        return this.anims;
    }

    public Map<Integer, SerializedTrigger> getTriggers() {
        return this.triggers;
    }

    private void loadInfo(Editor e) {
        this.valGidMask = e.animEnc == null ? 0 : PlayerSkinLayer.encode(e.animEnc.freeLayers);
        this.defGidMask = e.animEnc == null ? 0 : PlayerSkinLayer.encode(e.animEnc.defaultLayerValue) & ~this.valGidMask;
        this.resetId = this.defGidMask | this.valGidMask;
        this.blankId = this.defGidMask | 0;
        this.modelProfilesId = e.modelId;
        this.allLayers = e.animEnc != null ? new ArrayList<PlayerSkinLayer>(e.animEnc.freeLayers) : new ArrayList();
        Collections.sort(this.allLayers);
    }

    public void loadFromEditor(Editor e) {
        this.loadInfo(e);
        HashMap triggers = new HashMap();
        HashMap<EditorAnim, SerializedTrigger> stagingIds = new HashMap<EditorAnim, SerializedTrigger>();
        HashMap animTriggers = new HashMap();
        HashSet allElems = new HashSet();
        Editor.walkElements(e.elements, allElems::add);
        e.animations.forEach(a -> {
            SerializedTrigger tr = new SerializedTrigger();
            if (a.pose instanceof VanillaPose) {
                tr.pose = (VanillaPose)a.pose;
            } else if (a.type == AnimationType.CUSTOM_POSE || a.type == AnimationType.GESTURE || a.type.isLayer()) {
                tr.name = a.getId();
                tr.anim = a.type;
                tr.group = a.group;
                tr.layerCtrl = a.layerControlled;
                tr.command = a.command;
                tr.isProperty = a.isProperty;
                tr.order = a.order;
                tr.defaultValue = (byte)(a.layerDefault * 255.0f);
                tr.looping = a.loop;
            } else if (a.type.isStaged()) {
                tr.anim = a.type;
                tr.triggerID = stagingIds.size();
                stagingIds.put((EditorAnim)a, tr);
            }
            int id = triggers.computeIfAbsent(tr, this::newTrigger);
            animTriggers.put(a, id);
            SerializedAnimation anim = new SerializedAnimation();
            anim.triggerID = id;
            anim.priority = a.priority;
            anim.duration = a.duration;
            this.newAnimation(anim);
            List<ModelElement> elems = a.getComponentsFiltered();
            List<AnimFrame> frames = a.getFrames();
            elems.forEach(me -> {
                if (!allElems.contains(me)) {
                    return;
                }
                Map<InterpolatorChannel, Integer> c = AnimatorChannel.addCubeToChannels(anim, me.id, a.add);
                if (frames.stream().anyMatch(f -> f.hasPosChanges((ModelElement)me))) {
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.POS_X, a, 0.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.POS_Y, a, 0.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.POS_Z, a, 0.0f);
                }
                if (frames.stream().anyMatch(f -> f.hasRotChanges((ModelElement)me))) {
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.ROT_X, a, 0.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.ROT_Y, a, 0.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.ROT_Z, a, 0.0f);
                }
                if (frames.stream().anyMatch(f -> f.hasColorChanges((ModelElement)me))) {
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.COLOR_R, a, 0.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.COLOR_G, a, 0.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.COLOR_B, a, 0.0f);
                }
                if (frames.stream().anyMatch(f -> f.hasVisChanges((ModelElement)me))) {
                    boolean[] array = new boolean[frames.size()];
                    for (int i = 0; i < frames.size(); ++i) {
                        AnimFrame frm = (AnimFrame)frames.get(i);
                        IElem dt = frm.getData((ModelElement)me);
                        array[i] = dt == null ? me.isVisible() : dt.isVisible();
                    }
                    anim.animatorChannels.get((Object)c.get(null)).frameData = new ConstantTimeBool(array);
                }
                if (frames.stream().anyMatch(f -> f.hasScaleChanges((ModelElement)me))) {
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.SCALE_X, a, 1.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.SCALE_Y, a, 1.0f);
                    AnimLoaderState.addChannel(anim, c, me, InterpolatorChannel.SCALE_Z, a, 1.0f);
                }
            });
        });
        stagingIds.forEach((ea, t) -> {
            EditorAnim a = ea.findLinkedAnim();
            Integer id = (Integer)animTriggers.get(a);
            if (id != null) {
                t.triggerID = id;
            }
        });
        this.handleLayers();
    }

    private static void addChannel(SerializedAnimation anim, Map<InterpolatorChannel, Integer> c, ModelElement elem, InterpolatorChannel chn, EditorAnim ea, float empty) {
        List<AnimFrame> frames = ea.getFrames();
        float[] array = new float[frames.size()];
        for (int i = 0; i < frames.size(); ++i) {
            AnimFrame frm = frames.get(i);
            IElem dt = frm.getData(elem);
            if (dt == null) {
                if (ea.add) {
                    array[i] = empty;
                    continue;
                }
                array[i] = elem.part(chn);
                continue;
            }
            array[i] = dt.part(chn);
        }
        anim.animatorChannels.get((Object)c.get((Object)chn)).frameData = new ConstantTimeFloat(ea.intType, array);
    }

    public static void parseInfo(IOHelper block, AnimLoaderState state) throws IOException {
        state.blankId = block.read();
        state.resetId = block.read();
        state.modelProfilesId = block.readUTF();
    }

    public void writeInfo(IOHelper dout) throws IOException {
        try (IOHelper d = dout.writeNextObjectBlock(TagType.CONTROL_INFO);){
            d.write(this.blankId);
            d.write(this.resetId);
            if (this.modelProfilesId == null) {
                d.writeVarInt(0);
            } else {
                d.writeUTF(this.modelProfilesId);
            }
        }
    }

    public void applyInfos(AnimationRegistry reg) {
        reg.setBlankGesture(this.blankId);
        reg.setPoseResetId(this.resetId);
        reg.setProfileId(this.modelProfilesId);
    }

    public void handleLayers() {
        SerializedTrigger.handleLayers(this.triggers, this.allLayers, this.blankId, this.resetId, this.valGidMask, this.defGidMask);
    }

    public void processTriggers() {
        SerializedTrigger.handleGestures(this.triggers, this.blankId, this.resetId);
    }
}

