/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.util.PlayerSkinLayer;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.TagType;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class SerializedTrigger {
    public static final int LAYER_CTRL = 1;
    public static final int COMMAND_CTRL = 2;
    public static final int PROPERTY = 4;
    public static final int GROUPPED = 8;
    public static final int LOOPING = 16;
    private boolean init;
    public int animID = -1;
    public int triggerID = -1;
    public AnimationType anim;
    public String name;
    public VanillaPose pose;
    public byte defaultValue;
    public int order;
    public boolean isProperty;
    public String group;
    public boolean command;
    public boolean layerCtrl;
    public boolean looping;
    private int gid = -1;

    public static void newTrigger(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger t = new SerializedTrigger();
        state.newTrigger(t);
    }

    public static void initBuiltin(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger t = state.getTrigger();
        t.pose = (VanillaPose)block.readEnum(VanillaPose.values());
        t.anim = AnimationType.POSE;
        t.init = true;
    }

    public static void initNamed(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger cT = state.getTrigger();
        cT.anim = (AnimationType)block.readEnum(AnimationType.VALUES);
        cT.name = block.readUTF();
        int flags = block.read();
        cT.command = (flags & 2) != 0;
        cT.layerCtrl = (flags & 1) != 0;
        cT.isProperty = (flags & 4) != 0;
        cT.looping = (flags & 0x10) != 0;
        cT.order = block.readVarInt();
        cT.defaultValue = block.readByte();
        if (cT.layerCtrl) {
            cT.gid = block.read();
        }
        if ((flags & 8) != 0) {
            cT.group = block.readUTF();
        }
        cT.init = true;
    }

    public static void initTriggerStaged(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger cT = state.getTrigger();
        cT.anim = (AnimationType)block.readEnum(AnimationType.VALUES);
        cT.triggerID = block.readVarInt();
        cT.init = true;
    }

    public static void initAnimStaged(IOHelper block, AnimLoaderState state) throws IOException {
        SerializedTrigger cT = state.getTrigger();
        cT.anim = (AnimationType)block.readEnum(AnimationType.VALUES);
        cT.animID = block.readVarInt();
        cT.init = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(IOHelper dout) throws IOException {
        IOHelper d = dout.writeNextObjectBlock(TagType.NEW_TRIGGER);
        if (d != null) {
            d.close();
        }
        if (this.pose != null) {
            d = dout.writeNextObjectBlock(TagType.INIT_BUILTIN_TRIGGER);
            try {
                d.writeEnum(this.pose);
                return;
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (this.name != null) {
            d = dout.writeNextObjectBlock(TagType.INIT_NAMED_TRIGGER);
            try {
                d.writeEnum(this.anim);
                d.writeUTF(this.name);
                int flags = 0;
                if (this.group != null) {
                    flags |= 8;
                }
                if (this.layerCtrl) {
                    flags |= 1;
                }
                if (this.command) {
                    flags |= 2;
                }
                if (this.isProperty) {
                    flags |= 4;
                }
                if (this.looping) {
                    flags |= 0x10;
                }
                d.write(flags);
                d.writeVarInt(this.order);
                d.writeByte(this.defaultValue);
                if (this.layerCtrl) {
                    d.write(this.gid);
                }
                if (this.group == null) return;
                d.writeUTF(this.group);
                return;
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        if (!this.anim.isStaged()) return;
        if (this.triggerID != -1) {
            d = dout.writeNextObjectBlock(TagType.INIT_TRIGGER_STAGED_TRIGGER);
            try {
                d.writeEnum(this.anim);
                d.writeVarInt(this.triggerID);
                return;
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        d = dout.writeNextObjectBlock(TagType.INIT_ANIM_STAGED_TRIGGER);
        try {
            d.writeEnum(this.anim);
            d.writeVarInt(this.animID);
            return;
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
    }

    public static void handleLayers(Map<Integer, SerializedTrigger> triggers, List<PlayerSkinLayer> allLayers, int blank, int reset, int valMask, int defMask) {
        SerializedTrigger t;
        int layerId = 1;
        ArrayDeque allIds = new ArrayDeque(triggers.size());
        IntStream.range(0, Math.min(triggers.size(), 255)).forEach(allIds::add);
        allIds.remove(reset);
        allIds.remove(blank);
        for (int I = 0; I < triggers.size(); ++I) {
            t = triggers.get(I);
            if (t.anim != AnimationType.CUSTOM_POSE && t.anim != AnimationType.GESTURE || !t.layerCtrl) continue;
            if (allLayers.size() < 2) {
                throw new Exporter.ExportException("error.cpm.custom_anims_not_supported");
            }
            int gid = layerId++;
            HashSet<PlayerSkinLayer> encL = new HashSet<PlayerSkinLayer>();
            for (int i = 0; i < allLayers.size(); ++i) {
                PlayerSkinLayer l = allLayers.get(i);
                if ((gid & 1 << i) == 0) continue;
                encL.add(l);
            }
            if (encL.containsAll(allLayers)) {
                throw new Exporter.ExportException("error.cpm.too_many_animations");
            }
            t.gid = PlayerSkinLayer.encode(encL);
            t.gid &= valMask;
            t.gid |= defMask;
            allIds.remove(t.gid);
        }
        for (int i = 0; i < triggers.size(); ++i) {
            t = triggers.get(i);
            if (t.anim != AnimationType.CUSTOM_POSE && t.anim != AnimationType.GESTURE || t.layerCtrl) continue;
            if (allIds.isEmpty()) {
                throw new Exporter.ExportException("error.cpm.too_many_animations");
            }
            t.gid = (Integer)allIds.remove();
        }
    }

    public static void handleGestures(Map<Integer, SerializedTrigger> triggers, int blank, int reset) {
        ArrayDeque allGIds = new ArrayDeque(triggers.size());
        ArrayDeque allPIds = new ArrayDeque(triggers.size());
        IntStream.range(0, Math.min(triggers.size(), 255)).forEach(allGIds::add);
        allGIds.remove(blank);
        allGIds.remove(reset);
        allPIds.addAll(allGIds);
        ArrayList<SerializedTrigger> tL = new ArrayList<SerializedTrigger>();
        for (int i = 0; i < triggers.size(); ++i) {
            tL.add(triggers.get(i));
        }
        tL.forEach(s -> {
            if ((s.anim == AnimationType.CUSTOM_POSE || s.anim == AnimationType.GESTURE) && s.layerCtrl) {
                (s.anim == AnimationType.CUSTOM_POSE ? allPIds : allGIds).remove(s.gid);
            }
        });
        tL.forEach(s -> {
            if (!(s.anim != AnimationType.CUSTOM_POSE && s.anim != AnimationType.GESTURE || s.layerCtrl)) {
                s.gid = (Integer)(s.anim == AnimationType.CUSTOM_POSE ? allPIds : allGIds).remove();
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anim == null ? 0 : this.anim.hashCode());
        result = 31 * result + this.animID;
        result = 31 * result + this.triggerID;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pose == null ? 0 : this.pose.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedTrigger other = (SerializedTrigger)obj;
        if (this.anim != other.anim) {
            return false;
        }
        if (this.animID != other.animID) {
            return false;
        }
        if (this.triggerID != other.triggerID) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.pose == null ? other.pose != null : !this.pose.equals(other.pose));
    }

    public void registerOld(AnimationRegistry reg, List<IAnimation> a) {
        if (this.pose != null) {
            a.forEach(e -> reg.register(this.pose, (IAnimation)e));
        } else if (this.name != null) {
            if (this.anim == AnimationType.CUSTOM_POSE) {
                CustomPose p = new CustomPose(this.name, this.order);
                a.forEach(e -> reg.register(p, (IAnimation)e));
                p.command = this.command;
                p.layerCtrl = this.layerCtrl;
                reg.register(p);
                if (this.gid != -1) {
                    reg.register(this.gid, p);
                }
            } else {
                Gesture g = new Gesture(this.anim, a, this.name, this.looping, this.order);
                g.defVal = this.defaultValue;
                g.isProperty = this.isProperty;
                g.group = this.group;
                g.command = this.command;
                g.layerCtrl = this.layerCtrl;
                reg.register(g);
                if (this.gid != -1) {
                    reg.register(this.gid, g);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trigger");
        if (this.pose != null) {
            sb.append(" Pose ");
            sb.append(this.pose.name());
        } else if (this.name != null) {
            sb.append(" ");
            sb.append(this.anim.name());
            sb.append("\n\tName: ");
            sb.append(this.name);
            sb.append(" ");
            sb.append(this.layerCtrl);
            sb.append(" ");
            sb.append(this.gid);
            sb.append(" ");
            sb.append(this.looping);
        } else if (this.anim.isStaged()) {
            sb.append(" ");
            sb.append(this.anim.name());
            sb.append(" ");
            if (this.animID != -1) {
                sb.append(this.animID);
                sb.append(" Anim");
            } else {
                sb.append(this.triggerID);
                sb.append(" Trigger");
            }
        }
        return sb.toString();
    }
}

