/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.client.entity.fancypainting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.handcrafted.client.entity.fancypainting.FancyPaintingModel;
import earth.terrarium.handcrafted.common.entity.FancyPainting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FancyPaintingRenderer
extends EntityRenderer<FancyPainting> {
    public static final ResourceLocation SMALL_FRAME_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/small_painting_frame.png");
    public static final ResourceLocation MEDIUM_FRAME_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/medium_painting_frame.png");
    public static final ResourceLocation LARGE_FRAME_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/large_painting_frame.png");
    public static final ResourceLocation WIDE_FRAME_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/wide_painting_frame.png");
    public static final ResourceLocation TALL_FRAME_TEXTURE = new ResourceLocation("handcrafted", "textures/painting/tall_painting_frame.png");

    public FancyPaintingRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(FancyPainting entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ResourceLocation frameTexture;
        FancyPaintingModel model;
        EntityModelSet modelSet = Minecraft.m_91087_().m_167973_();
        PaintingVariant variant = (PaintingVariant)entity.m_28554_().m_203334_();
        Direction dir = entity.m_6350_();
        int width = variant.m_218908_();
        int height = variant.m_218909_();
        if (width == 32 && height == 32) {
            model = new FancyPaintingModel(modelSet.m_171103_(FancyPaintingModel.LAYER_LOCATION_MEDIUM));
            frameTexture = MEDIUM_FRAME_TEXTURE;
            poseStack.m_85837_(0.0, -0.4, 0.0);
            if (dir == Direction.NORTH) {
                poseStack.m_85837_(-0.4, 0.0, 0.0);
            }
            if (dir == Direction.SOUTH) {
                poseStack.m_85837_(0.4, 0.0, 0.0);
            }
        } else if (width == 48 && height == 32) {
            model = new FancyPaintingModel(modelSet.m_171103_(FancyPaintingModel.LAYER_LOCATION_LARGE));
            frameTexture = LARGE_FRAME_TEXTURE;
            poseStack.m_85837_(0.0, -0.4, 0.0);
            if (dir == Direction.EAST) {
                poseStack.m_85837_(0.0, 0.0, 0.4);
            }
            if (dir == Direction.WEST) {
                poseStack.m_85837_(0.0, 0.0, -0.4);
            }
        } else if (width == 16 && height == 32) {
            model = new FancyPaintingModel(modelSet.m_171103_(FancyPaintingModel.LAYER_LOCATION_TALL));
            frameTexture = TALL_FRAME_TEXTURE;
            poseStack.m_85837_(0.0, -0.4, 0.0);
            if (dir == Direction.EAST) {
                poseStack.m_85837_(0.0, 0.0, 0.4);
            }
            if (dir == Direction.WEST) {
                poseStack.m_85837_(0.0, 0.0, -0.4);
            }
        } else if (width == 32 && height == 16) {
            model = new FancyPaintingModel(modelSet.m_171103_(FancyPaintingModel.LAYER_LOCATION_WIDE));
            frameTexture = WIDE_FRAME_TEXTURE;
            if (dir == Direction.NORTH) {
                poseStack.m_85837_(-0.4, 0.0, 0.0);
            }
            if (dir == Direction.SOUTH) {
                poseStack.m_85837_(0.4, 0.0, 0.0);
            }
        } else {
            model = new FancyPaintingModel(modelSet.m_171103_(FancyPaintingModel.LAYER_LOCATION_SMALL));
            frameTexture = SMALL_FRAME_TEXTURE;
            if (dir == Direction.EAST) {
                poseStack.m_85837_(0.0, 0.0, 0.4);
            }
            if (dir == Direction.WEST) {
                poseStack.m_85837_(0.0, 0.0, -0.4);
            }
        }
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        switch (dir) {
            case NORTH: {
                poseStack.m_85837_(0.0, 0.0, -0.023);
                break;
            }
            case EAST: {
                poseStack.m_85837_(0.023, 0.0, -0.5);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.0, 0.0, 0.023);
                break;
            }
            case WEST: {
                poseStack.m_85837_(-0.023, 0.0, 0.5);
            }
        }
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.0, 0.875, 0.0);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(dir.m_122424_().m_122435_()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)frameTexture)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_252880_(0.0f, 0.0f, 0.01f);
            poseStack.m_85841_((float)width / 16.0f, (float)height / 16.0f, 1.0f);
            if (width == 32 && height == 32) {
                poseStack.m_252880_(-0.25f, -0.3125f, 0.0f);
            } else if (width == 48 && height == 32) {
                poseStack.m_252880_(-0.5f, -0.3125f, 0.0f);
            } else if (width == 16 && height == 32) {
                poseStack.m_252880_(-0.5f, -0.3125f, 0.0f);
            } else if (width == 32 && height == 16) {
                poseStack.m_252880_(-0.25f, 0.375f, 0.0f);
            } else {
                poseStack.m_252880_(-0.5f, 0.375f, 0.0f);
            }
            FancyPaintingRenderer.renderPainting(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity))), dir, packedLight, OverlayTexture.f_118083_);
        }
    }

    private static void renderPainting(PoseStack poseStack, VertexConsumer consumer, Direction dir, int light, int overlay) {
        Vec3i normal = dir.m_122436_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 0.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        consumer.m_252986_(poseStack.m_85850_().m_252922_(), 1.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(poseStack.m_85850_().m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(FancyPainting entity) {
        return new ResourceLocation("handcrafted", "textures/painting/" + BuiltInRegistries.f_257051_.m_7981_((Object)((PaintingVariant)entity.m_28554_().m_203334_())).m_135815_() + ".png");
    }
}

