/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;
import org.slf4j.Logger;

public abstract class BookProvider
implements DataProvider {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected final PackOutput packOutput;
    protected final LanguageProvider lang;
    protected final Map<ResourceLocation, BookModel> bookModels;
    protected final String modid;

    public BookProvider(PackOutput packOutput, String modid, LanguageProvider lang) {
        this.modid = modid;
        this.packOutput = packOutput;
        this.lang = lang;
        this.bookModels = new HashMap<ResourceLocation, BookModel>();
    }

    protected abstract void generate();

    protected ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    protected BookModel add(BookModel bookModel) {
        if (this.bookModels.containsKey(bookModel.getId())) {
            throw new IllegalStateException("Duplicate book " + bookModel.getId());
        }
        this.bookModels.put(bookModel.getId(), bookModel);
        return bookModel;
    }

    private Path getPath(Path dataFolder, BookModel bookModel) {
        ResourceLocation id = bookModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(id.m_135815_() + "/book.json");
    }

    private Path getPath(Path dataFolder, BookCategoryModel bookCategoryModel) {
        ResourceLocation id = bookCategoryModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(bookCategoryModel.getBook().getId().m_135815_()).resolve("categories").resolve(id.m_135815_() + ".json");
    }

    private Path getPath(Path dataFolder, BookCommandModel bookCommandModel) {
        ResourceLocation id = bookCommandModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(bookCommandModel.getBook().getId().m_135815_()).resolve("commands").resolve(id.m_135815_() + ".json");
    }

    private Path getPath(Path dataFolder, BookEntryModel bookEntryModel) {
        ResourceLocation id = bookEntryModel.getId();
        return dataFolder.resolve(id.m_135827_()).resolve("modonomicon/books").resolve(bookEntryModel.getCategory().getBook().getId().m_135815_()).resolve("entries").resolve(id.m_135815_() + ".json");
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        Path dataFolder = this.packOutput.m_247566_(PackOutput.Target.DATA_PACK);
        this.generate();
        for (BookModel bookModel : this.bookModels.values()) {
            Path bookPath = this.getPath(dataFolder, bookModel);
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookModel.toJson(), (Path)bookPath));
            for (BookCategoryModel bookCategoryModel : bookModel.getCategories()) {
                Path bookCategoryPath = this.getPath(dataFolder, bookCategoryModel);
                futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookCategoryModel.toJson(), (Path)bookCategoryPath));
                for (BookEntryModel bookEntryModel : bookCategoryModel.getEntries()) {
                    Path bookEntryPath = this.getPath(dataFolder, bookEntryModel);
                    futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookEntryModel.toJson(), (Path)bookEntryPath));
                }
            }
            for (BookCommandModel bookCommandModel : bookModel.getCommands()) {
                Path bookCommandPath = this.getPath(dataFolder, bookCommandModel);
                futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)bookCommandModel.toJson(), (Path)bookCommandPath));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Books: " + this.modid;
    }
}

