/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book.condition;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import net.minecraft.network.chat.Component;

public class BookModLoadedConditionModel
extends BookConditionModel {
    private final String modId;

    protected BookModLoadedConditionModel(String modId, Component tooltip, String tooltipString) {
        super(ModonomiconConstants.Data.Condition.MOD_LOADED, tooltip, tooltipString);
        this.modId = modId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        json.addProperty("mod_id", this.modId);
        return json;
    }

    public String getModId() {
        return this.modId;
    }

    public static final class Builder {
        private String modId;
        private Component tooltip;
        private String tooltipString;

        private Builder() {
        }

        public Builder withModId(String advancementId) {
            this.modId = advancementId;
            return this;
        }

        public Builder withTooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder withTooltipString(String tooltipString) {
            this.tooltipString = tooltipString;
            return this;
        }

        public String getModId() {
            return this.modId;
        }

        public Component getTooltip() {
            return this.tooltip;
        }

        public String getTooltipString() {
            return this.tooltipString;
        }

        public BookModLoadedConditionModel build() {
            BookModLoadedConditionModel model = new BookModLoadedConditionModel(this.modId, this.tooltip, this.tooltipString);
            return model;
        }
    }
}

