/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.capability;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.capability.bookstate.BookState;
import com.klikli_dev.modonomicon.capability.bookstate.CategoryState;
import com.klikli_dev.modonomicon.capability.bookstate.EntryState;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.network.messages.SyncBookStateCapabilityMessage;
import com.klikli_dev.modonomicon.registry.CapabilityRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BookStateCapability
implements INBTSerializable<CompoundTag> {
    public ConcurrentMap<ResourceLocation, BookState> bookStates = new ConcurrentHashMap<ResourceLocation, BookState>();

    public static BookState getBookStateFor(Player player, Book book) {
        return player.getCapability(CapabilityRegistry.BOOK_STATE).map(c -> c.getBookState(book)).orElse(null);
    }

    public static CategoryState getCategoryStateFor(Player player, BookCategory category) {
        return player.getCapability(CapabilityRegistry.BOOK_STATE).map(c -> c.getCategoryState(category)).orElse(null);
    }

    public static EntryState getEntryStateFor(Player player, BookEntry entry) {
        return player.getCapability(CapabilityRegistry.BOOK_STATE).map(c -> c.getEntryState(entry)).orElse(null);
    }

    public static void setEntryStateFor(Player player, BookEntry entry, EntryState state) {
        player.getCapability(CapabilityRegistry.BOOK_STATE).ifPresent(c -> c.setEntryState(entry, state));
    }

    public static void setCategoryStateFor(Player player, BookCategory category, CategoryState state) {
        player.getCapability(CapabilityRegistry.BOOK_STATE).ifPresent(c -> c.setCategoryState(category, state));
    }

    public static void setBookStateFor(Player player, Book book, BookState state) {
        player.getCapability(CapabilityRegistry.BOOK_STATE).ifPresent(c -> c.setBookState(book, state));
    }

    public static void syncFor(ServerPlayer player) {
        player.getCapability(CapabilityRegistry.BOOK_STATE).ifPresent(capability -> capability.sync(player));
    }

    public void clone(BookStateCapability other) {
        this.bookStates = other.bookStates;
    }

    public void sync(ServerPlayer player) {
        Networking.sendTo(player, new SyncBookStateCapabilityMessage(this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("modonomicon:nbt_version", "1.0.0");
        ListTag bookStatesList = new ListTag();
        compound.m_128365_("book_states", (Tag)bookStatesList);
        this.bookStates.forEach((bookId, state) -> {
            CompoundTag stateCompound = new CompoundTag();
            stateCompound.m_128359_("book_id", bookId.toString());
            stateCompound.m_128365_("state", (Tag)state.serializeNBT());
            bookStatesList.add((Object)stateCompound);
        });
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.bookStates.clear();
        ListTag bookStatesList = nbt.m_128437_("book_states", 10);
        for (Tag bookStateEntry : bookStatesList) {
            if (!(bookStateEntry instanceof CompoundTag)) continue;
            CompoundTag bookStateCompound = (CompoundTag)bookStateEntry;
            ResourceLocation bookId = new ResourceLocation(bookStateCompound.m_128461_("book_id"));
            CompoundTag stateCompound = bookStateCompound.m_128469_("state");
            BookState state = new BookState();
            state.deserializeNBT(stateCompound);
            this.bookStates.put(bookId, state);
        }
    }

    public BookState getBookState(Book book) {
        return this.bookStates.computeIfAbsent(book.getId(), id -> new BookState());
    }

    public CategoryState getCategoryState(BookCategory category) {
        return this.getBookState((Book)category.getBook()).categoryStates.computeIfAbsent(category.getId(), id -> new CategoryState());
    }

    public EntryState getEntryState(BookEntry entry) {
        return this.getCategoryState((BookCategory)entry.getCategory()).entryStates.computeIfAbsent(entry.getId(), id -> new EntryState());
    }

    public void setEntryState(BookEntry entry, EntryState state) {
        this.getCategoryState((BookCategory)entry.getCategory()).entryStates.put(entry.getId(), state);
    }

    public void setCategoryState(BookCategory category, CategoryState state) {
        this.getBookState((Book)category.getBook()).categoryStates.put(category.getId(), state);
    }

    public void setBookState(Book book, BookState state) {
        this.bookStates.put(book.getId(), state);
    }

    public static class Dispatcher
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<BookStateCapability> bookStateCapability = LazyOptional.of(BookStateCapability::new);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityRegistry.BOOK_STATE) {
                return this.bookStateCapability.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.bookStateCapability.map(BookStateCapability::serializeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.bookStateCapability.ifPresent(capability -> capability.deserializeNBT(nbt));
        }
    }
}

