/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.datagen;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.datagen.BookLangHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryLocationHelper;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryReadConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookEntryUnlockedConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookFalseConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookBlastingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCampfireCookingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookCraftingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookEmptyPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookEntityPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookImagePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookLegacySmithingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmeltingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmithingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSmokingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookStonecuttingRecipePageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.LanguageProvider;

public class DemoBookProvider
extends BookProvider {
    public DemoBookProvider(PackOutput packOutput, String modid, LanguageProvider lang) {
        super(packOutput, modid, lang);
    }

    private BookModel makeDemoBook() {
        BookLangHelper helper = ModonomiconAPI.get().getLangHelper(this.modid);
        helper.book("demo");
        BookCategoryModel featuresCategory = this.makeFeaturesCategory(helper);
        BookCategoryModel formattingCategory = this.makeFormattingCategory(helper);
        BookCategoryModel hiddenCategory = this.makeHiddenCategory(helper);
        BookCategoryModel conditionalCategory = this.makeConditionalCategory(helper);
        conditionalCategory.withCondition(BookEntryReadConditionModel.builder().withEntry(this.modLoc("features/condition_root")).build());
        BookCommandModel commandEntryCommand = BookCommandModel.create(this.modLoc("test_command"), "/give @s minecraft:apple 1").withPermissionLevel(2).withSuccessMessage("modonomicon.command.test_command.success");
        this.lang.add(commandEntryCommand.getSuccessMessage(), "You got an apple, because reading is cool!");
        BookCommandModel commandEntryLinkCommand = BookCommandModel.create(this.modLoc("test_command2"), "/give @s minecraft:wheat 1").withPermissionLevel(2).withSuccessMessage("modonomicon.command.test_command2.success");
        this.lang.add(commandEntryLinkCommand.getSuccessMessage(), "You got wheat, because clicking is cool!");
        BookModel demoBook = BookModel.create(this.modLoc("demo"), helper.bookName()).withTooltip(helper.bookTooltip()).withModel(new ResourceLocation("modonomicon:modonomicon_green")).withBookTextOffsetX(5).withBookTextOffsetY(0).withBookTextOffsetWidth(-5).withCategory(featuresCategory).withCategory(formattingCategory).withCategory(hiddenCategory).withCategory(conditionalCategory).withCommand(commandEntryCommand).withCommand(commandEntryLinkCommand);
        return demoBook;
    }

    private BookCategoryModel makeFeaturesCategory(BookLangHelper helper) {
        helper.category("features");
        EntryLocationHelper entryHelper = ModonomiconAPI.get().getEntryLocationHelper();
        entryHelper.setMap("___           _____5____________", "__(multiblock)______________d___", "___           _______r__________", "__c           __________________", "___           _______2___3___i__", "__s           _____e____________", "___           __________________", "___           _____f____________");
        BookEntryModel multiblockEntry = this.makeMultiblockEntry(helper, entryHelper);
        List<BookEntryModel> conditionEntries = this.makeConditionEntries(helper, entryHelper);
        BookEntryModel recipeEntry = this.makeRecipeEntry(helper, entryHelper).build();
        BookEntryModel.Builder spotlightEntry = this.makeSpotlightEntry(helper, entryHelper);
        spotlightEntry.withParent(BookEntryParentModel.builder().withEntryId(recipeEntry.getId()).build());
        BookEntryModel.Builder emptyEntry = this.makeEmptyPageEntry(helper, entryHelper);
        emptyEntry.withParent(BookEntryParentModel.builder().withEntryId(spotlightEntry.id).build());
        BookEntryModel.Builder commandEntry = this.makeCommandEntry(helper, entryHelper);
        commandEntry.withParent(emptyEntry);
        commandEntry.withCommandToRunOnFirstRead(this.modLoc("test_command"));
        BookEntryModel.Builder entityEntry = this.makeEntityEntry(helper, entryHelper);
        BookEntryModel.Builder imageEntry = this.makeImageEntry(helper, entryHelper);
        imageEntry.withParent(BookEntryParentModel.builder().withEntryId(emptyEntry.id).build());
        BookEntryModel redirectEntry = this.makeRedirectEntry(helper, entryHelper).build();
        return BookCategoryModel.create(this.modLoc("features"), helper.categoryName()).withIcon("minecraft:nether_star").withBackgroundParallaxLayers(new BookCategoryBackgroundParallaxLayer(this.modLoc("textures/gui/parallax/flow/base.png"), 0.7f, -1.0f), new BookCategoryBackgroundParallaxLayer(this.modLoc("textures/gui/parallax/flow/1.png"), 1.0f, -1.0f), new BookCategoryBackgroundParallaxLayer(this.modLoc("textures/gui/parallax/flow/2.png"), 1.4f, -1.0f)).withEntry(multiblockEntry).withEntry(recipeEntry).withEntries(conditionEntries).withEntry(spotlightEntry.build()).withEntry(emptyEntry.build()).withEntry(entityEntry.build()).withEntry(imageEntry.build()).withEntry(redirectEntry).withEntry(commandEntry.build());
    }

    private BookEntryModel makeMultiblockEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("multiblock");
        helper.page("intro");
        BookTextPageModel multiBlockIntroPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("preview");
        BookMultiblockPageModel multiblockPreviewPage = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("blockentity")).withMultiblockName("multiblocks.modonomicon.blockentity").withText(helper.pageText()).build();
        helper.page("preview2");
        BookMultiblockPageModel multiblockPreviewPage2 = BookMultiblockPageModel.builder().withMultiblockId(this.modLoc("tag")).build();
        return BookEntryModel.builder().withId(this.modLoc("features/multiblock")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:furnace").withLocation(entryHelper.get("multiblock")).withPages(multiBlockIntroPage, multiblockPreviewPage, multiblockPreviewPage2).build();
    }

    private List<BookEntryModel> makeConditionEntries(BookLangHelper helper, EntryLocationHelper entryHelper) {
        ArrayList<BookEntryModel> result = new ArrayList<BookEntryModel>();
        helper.entry("condition_root");
        helper.page("info");
        BookTextPageModel conditionRootEntryInfoPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        BookEntryModel conditionRootEntry = BookEntryModel.builder().withId(this.modLoc("features/condition_root")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:redstone_torch").withLocation(entryHelper.get(Character.valueOf('r'))).withEntryBackground(1, 0).withPages(conditionRootEntryInfoPage).build();
        result.add(conditionRootEntry);
        helper.entry("condition_level_1");
        helper.page("info");
        BookTextPageModel conditionLevel1EntryInfoPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        BookEntryReadConditionModel conditionLevel1EntryCondition = BookEntryReadConditionModel.builder().withEntry(conditionRootEntry.getId()).build();
        BookEntryModel conditionLevel1Entry = BookEntryModel.builder().withId(this.modLoc("features/condition_level_1")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:lever").withLocation(entryHelper.get(Character.valueOf('2'))).withPages(conditionLevel1EntryInfoPage).withCondition(conditionLevel1EntryCondition).withParent(BookEntryParentModel.builder().withEntryId(conditionRootEntry.getId()).build()).build();
        result.add(conditionLevel1Entry);
        helper.entry("condition_level_2");
        helper.page("info");
        BookTextPageModel conditionLevel2EntryInfoPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        BookEntryUnlockedConditionModel conditionLevel2EntryCondition = BookEntryUnlockedConditionModel.builder().withEntry(conditionLevel1Entry.getId()).build();
        BookEntryModel conditionLevel2Entry = BookEntryModel.builder().withId(this.modLoc("features/condition_level_2")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:torch").withLocation(entryHelper.get(Character.valueOf('3'))).withPages(conditionLevel2EntryInfoPage).withCondition(conditionLevel2EntryCondition).withParent(BookEntryParentModel.builder().withEntryId(conditionLevel1Entry.getId()).build()).build();
        result.add(conditionLevel2Entry);
        return result;
    }

    private BookEntryModel.Builder makeRecipeEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("recipe");
        helper.page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("crafting");
        BookCraftingRecipePageModel crafting = ((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)((BookCraftingRecipePageModel.Builder)BookCraftingRecipePageModel.builder().withRecipeId1("minecraft:crafting_table")).withRecipeId2("minecraft:oak_planks")).withText(helper.pageText())).withTitle2("test.test.test")).build();
        helper.page("smelting");
        BookSmeltingRecipePageModel smelting = ((BookSmeltingRecipePageModel.Builder)((BookSmeltingRecipePageModel.Builder)BookSmeltingRecipePageModel.builder().withRecipeId1("minecraft:charcoal")).withRecipeId2("minecraft:cooked_beef")).build();
        helper.page("smoking");
        BookSmokingRecipePageModel smoking = ((BookSmokingRecipePageModel.Builder)((BookSmokingRecipePageModel.Builder)BookSmokingRecipePageModel.builder().withRecipeId1("minecraft:cooked_beef_from_smoking")).withText(helper.pageText())).build();
        helper.page("blasting");
        BookBlastingRecipePageModel blasting = ((BookBlastingRecipePageModel.Builder)BookBlastingRecipePageModel.builder().withRecipeId2("minecraft:iron_ingot_from_blasting_iron_ore")).build();
        helper.page("campfire_cooking");
        BookCampfireCookingRecipePageModel campfireCooking = ((BookCampfireCookingRecipePageModel.Builder)BookCampfireCookingRecipePageModel.builder().withRecipeId1("minecraft:cooked_beef_from_campfire_cooking")).build();
        helper.page("stonecutting");
        BookStonecuttingRecipePageModel stonecutting = ((BookStonecuttingRecipePageModel.Builder)BookStonecuttingRecipePageModel.builder().withRecipeId1("minecraft:andesite_slab_from_andesite_stonecutting")).build();
        helper.page("legacy_smithing");
        BookLegacySmithingRecipePageModel legacySmithing = ((BookLegacySmithingRecipePageModel.Builder)((BookLegacySmithingRecipePageModel.Builder)BookLegacySmithingRecipePageModel.builder().withRecipeId1("minecraft:netherite_axe_smithing")).withTitle1(helper.pageTitle())).build();
        this.lang.add(helper.pageTitle(), "Legacy Smithing Recipe");
        helper.page("smithing");
        BookSmithingRecipePageModel smithing = ((BookSmithingRecipePageModel.Builder)((BookSmithingRecipePageModel.Builder)((BookSmithingRecipePageModel.Builder)BookSmithingRecipePageModel.builder().withRecipeId1("minecraft:netherite_axe_smithing")).withTitle1(helper.pageTitle())).withRecipeId2("minecraft:netherite_chestplate_smithing")).build();
        this.lang.add(helper.pageTitle(), "1.20+ Smithing Recipe");
        helper.page("missing");
        BookLegacySmithingRecipePageModel missing = ((BookLegacySmithingRecipePageModel.Builder)BookLegacySmithingRecipePageModel.builder().withRecipeId1("minecraft:netherite_axe_smithing_does_not_exist")).build();
        return BookEntryModel.builder().withId(this.modLoc("features/recipe")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:crafting_table").withLocation(entryHelper.get(Character.valueOf('c'))).withPages(introPage, crafting, smelting, smoking, blasting, campfireCooking, stonecutting, legacySmithing, smithing, missing);
    }

    private BookEntryModel.Builder makeSpotlightEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("spotlight");
        helper.page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("spotlight1");
        BookSpotlightPageModel spotlight1 = BookSpotlightPageModel.builder().withTitle(helper.pageTitle()).withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_})).build();
        helper.page("spotlight2");
        BookSpotlightPageModel spotlight2 = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})).build();
        return BookEntryModel.builder().withId(this.modLoc("features/spotlight")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:beacon").withLocation(entryHelper.get(Character.valueOf('s'))).withPages(introPage, spotlight1, spotlight2);
    }

    private BookEntryModel.Builder makeEmptyPageEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("empty");
        helper.page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("empty");
        BookEmptyPageModel empty = BookEmptyPageModel.builder().build();
        helper.page("empty2");
        BookEmptyPageModel empty2 = BookEmptyPageModel.builder().build();
        return BookEntryModel.builder().withId(this.modLoc("features/empty")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:obsidian").withLocation(entryHelper.get(Character.valueOf('e'))).withPages(introPage, empty, empty2);
    }

    private BookEntryModel.Builder makeCommandEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("command");
        this.lang.add(helper.entryName(), "Entry Read Commands");
        this.lang.add(helper.entryDescription(), "This entry runs a command when you first read it.");
        helper.page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        this.lang.add(helper.pageTitle(), "Entry Read Commands");
        this.lang.add(helper.pageText(), "This entry just ran a command when you first read it. Look into your chat!");
        helper.page("command_link");
        BookTextPageModel commandLink = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        this.lang.add(helper.pageTitle(), "Command Link");
        this.lang.add(helper.pageText(), "[Click me to run the command!](command://test_command2)");
        return BookEntryModel.builder().withId(this.modLoc("features/command")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:oak_sign").withLocation(entryHelper.get(Character.valueOf('f'))).withPages(introPage, commandLink);
    }

    private BookEntryModel.Builder makeEntityEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("entity");
        helper.page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("entity1");
        BookEntityPageModel entity1 = BookEntityPageModel.builder().withEntityName(helper.pageTitle()).withEntityId("minecraft:ender_dragon").withScale(0.5f).build();
        helper.page("entity2");
        BookEntityPageModel entity2 = BookEntityPageModel.builder().withText(helper.pageText()).withEntityId("minecraft:spider").withScale(1.0f).build();
        return BookEntryModel.builder().withId(this.modLoc("features/entity")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:spider_eye").withLocation(entryHelper.get(Character.valueOf('d'))).withPages(introPage, entity1, entity2);
    }

    private BookEntryModel.Builder makeImageEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("image");
        helper.page("intro");
        BookTextPageModel introPage = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("image");
        BookImagePageModel imagePage = BookImagePageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).withImages(new ResourceLocation("modonomicon:textures/gui/default_background.png"), new ResourceLocation("modonomicon:textures/gui/dark_slate_seamless.png")).build();
        helper.page("test_spotlight");
        BookSpotlightPageModel testSpotlight = BookSpotlightPageModel.builder().withText(helper.pageText()).withItem(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50085_})).build();
        helper.page("test_image");
        BookImagePageModel testImage = BookImagePageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).withImages(new ResourceLocation("modonomicon:textures/gui/default_background.png"), new ResourceLocation("modonomicon:textures/gui/dark_slate_seamless.png")).build();
        return BookEntryModel.builder().withId(this.modLoc("features/image")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:item_frame").withLocation(entryHelper.get(Character.valueOf('i'))).withPages(introPage, imagePage, testSpotlight, testImage);
    }

    private BookEntryModel.Builder makeRedirectEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("redirect");
        return BookEntryModel.builder().withId(this.modLoc("features/redirect")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:ender_pearl").withLocation(entryHelper.get(Character.valueOf('5'))).withCategoryToOpen(new ResourceLocation("modonomicon:hidden"));
    }

    private BookCategoryModel makeFormattingCategory(BookLangHelper helper) {
        helper.category("formatting");
        EntryLocationHelper entryHelper = new EntryLocationHelper();
        entryHelper.setMap("_____________________", "__b___a______________", "__________l_____x____", "_____________________", "_____________________");
        BookEntryModel.Builder basicFormattingEntry = this.makeBasicFormattingEntry(helper, entryHelper);
        BookEntryModel.Builder advancedFormattingEntry = this.makeAdvancedFormattingEntry(helper, entryHelper);
        BookEntryModel.Builder linkFormattingEntry = this.makeLinkFormattingEntry(helper, entryHelper);
        BookEntryModel.Builder alwaysLockedEntry = this.makeAlwaysLockedEntry(helper, entryHelper);
        alwaysLockedEntry.withCondition(BookFalseConditionModel.builder().build());
        linkFormattingEntry.withParent(BookEntryParentModel.builder().withEntryId(advancedFormattingEntry.id).build());
        advancedFormattingEntry.withParent(BookEntryParentModel.builder().withEntryId(basicFormattingEntry.id).build());
        return BookCategoryModel.create(this.modLoc("formatting"), helper.categoryName()).withIcon("minecraft:textures/item/book.png").withEntry(basicFormattingEntry.build()).withEntry(advancedFormattingEntry.build()).withEntry(linkFormattingEntry.build()).withEntry(alwaysLockedEntry.build());
    }

    private BookEntryModel.Builder makeBasicFormattingEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("basic");
        helper.page("page1");
        BookTextPageModel page1 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("page2");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        BookEntryModel.Builder formattingEntry = BookEntryModel.builder().withId(this.modLoc("formatting/basic")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:paper").withLocation(entryHelper.get(Character.valueOf('b'))).withPage(page1).withPage(page2);
        return formattingEntry;
    }

    private BookEntryModel.Builder makeAdvancedFormattingEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("advanced");
        helper.page("page1");
        BookTextPageModel page1 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("page2");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(helper.pageText()).build();
        helper.page("page3");
        BookTextPageModel page3 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        BookEntryModel.Builder formattingEntry = BookEntryModel.builder().withId(this.modLoc("formatting/advanced")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:feather").withLocation(entryHelper.get(Character.valueOf('a'))).withEntryBackground(0, 1).withPage(page1).withPage(page2).withPage(page3);
        return formattingEntry;
    }

    private BookEntryModel.Builder makeLinkFormattingEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("link");
        helper.page("page1");
        BookTextPageModel page1 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("page2");
        BookTextPageModel page2 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        helper.page("page3");
        BookTextPageModel page3 = BookTextPageModel.builder().withText(helper.pageText()).withTitle(helper.pageTitle()).build();
        BookEntryModel.Builder formattingEntry = BookEntryModel.builder().withId(this.modLoc("formatting/link")).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:writable_book").withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 2).withPages(page1, page2, page3);
        return formattingEntry;
    }

    private BookEntryModel.Builder makeAlwaysLockedEntry(BookLangHelper helper, EntryLocationHelper entryHelper) {
        helper.entry("always_locked");
        BookEntryModel.Builder entry = BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:nether_star").withLocation(entryHelper.get(Character.valueOf('x'))).withEntryBackground(0, 1);
        return entry;
    }

    private BookCategoryModel makeHiddenCategory(BookLangHelper helper) {
        helper.category("hidden");
        EntryLocationHelper entryHelper = new EntryLocationHelper();
        entryHelper.setMap("_____________________", "_____________________", "__________l__________", "_____________________", "_____________________");
        helper.entry("always_locked");
        BookEntryModel.Builder entry = BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:nether_star").withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 1).withCondition(BookFalseConditionModel.builder().build());
        return BookCategoryModel.create(this.modLoc(helper.category), helper.categoryName()).withIcon("minecraft:book").withShowCategoryButton(false).withEntry(entry.build());
    }

    private BookCategoryModel makeConditionalCategory(BookLangHelper helper) {
        helper.category("conditional");
        EntryLocationHelper entryHelper = new EntryLocationHelper();
        entryHelper.setMap("_____________________", "_____________________", "__________l__________", "_____________________", "_____________________");
        helper.entry("always_locked");
        BookEntryModel.Builder entry = BookEntryModel.builder().withId(this.modLoc(helper.category + "/" + helper.entry)).withName(helper.entryName()).withDescription(helper.entryDescription()).withIcon("minecraft:nether_star").withLocation(entryHelper.get(Character.valueOf('l'))).withEntryBackground(0, 1).withCondition(BookFalseConditionModel.builder().build());
        return BookCategoryModel.create(this.modLoc(helper.category), helper.categoryName()).withIcon("minecraft:chest").withEntry(entry.build());
    }

    @Override
    protected void generate() {
        BookModel demoBook = this.makeDemoBook();
        this.add(demoBook);
    }
}

