/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network.messages;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.bookstate.BookState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.network.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SaveBookStateMessage
implements Message {
    public Book book;
    ResourceLocation openCategory = null;

    public SaveBookStateMessage(Book book, ResourceLocation openCategory) {
        this.book = book;
        this.openCategory = openCategory;
    }

    public SaveBookStateMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.book.getId());
        buf.writeBoolean(this.openCategory != null);
        if (this.openCategory != null) {
            buf.m_130085_(this.openCategory);
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.book = BookDataManager.get().getBook(buf.m_130281_());
        if (buf.readBoolean()) {
            this.openCategory = buf.m_130281_();
        }
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        BookState currentState = BookStateCapability.getBookStateFor((Player)player, this.book);
        currentState.openCategory = this.openCategory;
        BookStateCapability.setBookStateFor((Player)player, this.book, currentState);
        BookStateCapability.syncFor(player);
    }
}

