/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.handler.BarOverlayRenderer;
import fuzs.overflowingbars.config.ClientConfig;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class HealthBarRenderer {
    public static final HealthBarRenderer INSTANCE = new HealthBarRenderer();
    private final RandomSource random = RandomSource.m_216327_();
    private int tickCount;
    private int lastHealth;
    private int displayHealth;
    private long lastHealthTime;
    private long healthBlinkTime;

    public void onStartTick(Minecraft minecraft) {
        ++this.tickCount;
    }

    public void renderPlayerHealth(PoseStack poseStack, int posX, int posY, Player player, ProfilerFiller profiler) {
        profiler.m_6180_("health");
        BarOverlayRenderer.resetRenderState();
        RenderSystem.m_69478_();
        int currentHealth = Mth.m_14167_((float)player.m_21223_());
        boolean blink = this.healthBlinkTime > (long)this.tickCount && (this.healthBlinkTime - (long)this.tickCount) / 3L % 2L == 1L;
        long millis = Util.m_137550_();
        if (currentHealth < this.lastHealth && player.f_19802_ > 0) {
            this.lastHealthTime = millis;
            this.healthBlinkTime = this.tickCount + 20;
        } else if (currentHealth > this.lastHealth && player.f_19802_ > 0) {
            this.lastHealthTime = millis;
            this.healthBlinkTime = this.tickCount + 10;
        }
        if (millis - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealth;
            this.lastHealthTime = millis;
        }
        this.lastHealth = currentHealth;
        int displayHealth = this.displayHealth;
        this.random.m_188584_((long)(this.tickCount * 312871));
        float maxHealth = Math.max((float)player.m_21133_(Attributes.f_22276_), (float)Math.max(displayHealth, currentHealth));
        int currentAbsorption = Mth.m_14167_((float)player.m_6103_());
        int heartOffsetByRegen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            heartOffsetByRegen = this.tickCount % Mth.m_14167_((float)(Math.min(20.0f, maxHealth) + 5.0f));
        }
        this.renderHearts(poseStack, player, posX, posY, heartOffsetByRegen, maxHealth, currentHealth, displayHealth, currentAbsorption, blink);
        RenderSystem.m_69461_();
        profiler.m_7238_();
    }

    private void renderHearts(PoseStack poseStack, Player player, int posX, int posY, int heartOffsetByRegen, float maxHealth, int currentHealth, int displayHealth, int currentAbsorptionHealth, boolean blink) {
        boolean hardcore = player.f_19853_.m_6106_().m_5466_();
        int normalHearts = Math.min(10, Mth.m_14165_((double)((double)maxHealth / 2.0)));
        int maxAbsorptionHearts = 20 - normalHearts;
        int absorptionHearts = Math.min(20 - normalHearts, Mth.m_14165_((double)((double)currentAbsorptionHealth / 2.0)));
        for (int currentHeart = 0; currentHeart < normalHearts + absorptionHearts; ++currentHeart) {
            boolean orange;
            boolean halfHeart;
            int currentAbsorption;
            int currentPosX = posX + currentHeart % 10 * 8;
            int currentPosY = posY - currentHeart / 10 * 10;
            if (currentHealth + currentAbsorptionHealth <= 4) {
                currentPosY += this.random.m_188503_(2);
            }
            if (currentHeart < normalHearts && heartOffsetByRegen == currentHeart) {
                currentPosY -= 2;
            }
            this.renderHeart(poseStack, HeartType.CONTAINER, currentPosX, currentPosY, blink, false, hardcore);
            if (currentHeart >= normalHearts && (currentAbsorption = currentHeart * 2 - normalHearts * 2) < currentAbsorptionHealth) {
                boolean orange2;
                int maxAbsorptionHealth = maxAbsorptionHearts * 2;
                boolean halfHeart2 = currentAbsorption + 1 == currentAbsorptionHealth % maxAbsorptionHealth;
                boolean bl = orange2 = currentAbsorptionHealth > maxAbsorptionHealth && currentAbsorption + 1 <= (currentAbsorptionHealth - 1) % maxAbsorptionHealth + 1;
                if (halfHeart2 && orange2) {
                    this.renderHeart(poseStack, HeartType.forPlayer(player, true, false), currentPosX, currentPosY, false, false, hardcore);
                }
                this.renderHeart(poseStack, HeartType.forPlayer(player, true, orange2), currentPosX, currentPosY, false, halfHeart2, hardcore);
            }
            if (blink && currentHeart * 2 < Math.min(20, displayHealth)) {
                halfHeart = currentHeart * 2 + 1 == (displayHealth - 1) % 20 + 1;
                boolean bl = orange = displayHealth > 20 && currentHeart * 2 + 1 <= (displayHealth - 1) % 20 + 1;
                if (halfHeart && orange) {
                    this.renderHeart(poseStack, HeartType.forPlayer(player, false, false), currentPosX, currentPosY, true, false, hardcore);
                }
                this.renderHeart(poseStack, HeartType.forPlayer(player, false, orange || ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.colorizeFirstRow && currentHeart * 2 + 1 <= (displayHealth - 1) % 20 + 1), currentPosX, currentPosY, true, halfHeart, hardcore);
            }
            if (currentHeart * 2 >= Math.min(20, currentHealth)) continue;
            halfHeart = currentHeart * 2 + 1 == (currentHealth - 1) % 20 + 1;
            boolean bl = orange = currentHealth > 20 && currentHeart * 2 + 1 <= (currentHealth - 1) % 20 + 1;
            if (halfHeart && orange) {
                this.renderHeart(poseStack, HeartType.forPlayer(player, false, false), currentPosX, currentPosY, false, false, hardcore);
            }
            this.renderHeart(poseStack, HeartType.forPlayer(player, false, orange || ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.colorizeFirstRow && currentHeart * 2 + 1 <= (currentHealth - 1) % 20 + 1), currentPosX, currentPosY, false, halfHeart, hardcore);
        }
    }

    private void renderHeart(PoseStack poseStack, HeartType heartType, int posX, int posY, boolean blink, boolean halfHeart, boolean hardcore) {
        heartType.setIconsSheet();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)heartType.getX(halfHeart, blink), (float)heartType.getY(hardcore), (int)9, (int)9, (int)256, (int)256);
    }

    static enum HeartType {
        CONTAINER(0, false),
        NORMAL(2, true),
        POISONED(4, true),
        WITHERED(6, true),
        ABSORBING(8, false),
        FROZEN(9, false),
        ORANGE(0, 3, 4, BarOverlayRenderer.OVERFLOWING_ICONS_LOCATION, true);

        private static ResourceLocation lastIconsSheet;
        private final int textureIndexX;
        private final int textureIndexY;
        private final int hardcoreIndexY;
        private final ResourceLocation textureSheet;
        private final boolean canBlink;

        private HeartType(int textureIndexX, boolean blink) {
            this(textureIndexX, 0, 5, GuiComponent.f_93098_, blink);
        }

        private HeartType(int textureIndexX, int textureIndexY, int hardcoreIndexY, ResourceLocation textureSheet, boolean blink) {
            this.textureIndexX = textureIndexX;
            this.textureIndexY = textureIndexY;
            this.hardcoreIndexY = hardcoreIndexY;
            this.textureSheet = textureSheet;
            this.canBlink = blink;
        }

        public int getX(boolean halfHeart, boolean blink) {
            int i;
            if (this == CONTAINER) {
                i = blink ? 1 : 0;
            } else {
                int j = halfHeart ? 1 : 0;
                int k = this.canBlink && blink ? 2 : 0;
                i = j + k;
            }
            return (this == ORANGE ? 0 : 16) + (this.textureIndexX * 2 + i) * 9;
        }

        public int getY(boolean hardcore) {
            return (hardcore ? this.hardcoreIndexY : this.textureIndexY) * 9;
        }

        public void setIconsSheet() {
            if (this.textureSheet != lastIconsSheet) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.textureSheet);
                lastIconsSheet = this.textureSheet;
            }
        }

        public static HeartType forPlayer(Player player, boolean absorbing, boolean orange) {
            if (player.m_21023_(MobEffects.f_19615_)) {
                return WITHERED;
            }
            if (player.m_21023_(MobEffects.f_19614_)) {
                return POISONED;
            }
            if (player.m_146890_()) {
                return FROZEN;
            }
            boolean inverse = ((ClientConfig)OverflowingBars.CONFIG.get(ClientConfig.class)).health.inverseColoring;
            if (orange) {
                return absorbing || !inverse ? ORANGE : NORMAL;
            }
            return absorbing ? ABSORBING : (inverse ? ORANGE : NORMAL);
        }
    }
}

