/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.EmptyEntry;
import me.shedaniel.clothconfig2.gui.widget.SearchFieldEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GlobalizedClothConfigScreen
extends AbstractConfigScreen
implements ReferenceBuildingConfigScreen,
Expandable {
    public ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private AbstractWidget cancelButton;
    private AbstractWidget exitButton;
    private final LinkedHashMap<Component, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final ScrollingContainer sideScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(4, 4, GlobalizedClothConfigScreen.this.getSideSliderPosition() - 14 - 4, GlobalizedClothConfigScreen.this.f_96544_ - 8);
        }

        @Override
        public int getMaxScrollHeight() {
            int i = 0;
            for (Reference reference : GlobalizedClothConfigScreen.this.references) {
                if (i != 0) {
                    i = (int)((float)i + 3.0f * reference.getScale());
                }
                float f = i;
                Objects.requireNonNull(GlobalizedClothConfigScreen.this.f_96547_);
                i = (int)(f + 9.0f * reference.getScale());
            }
            return i;
        }
    };
    private Reference lastHoveredReference = null;
    private SearchFieldEntry searchFieldEntry;
    private final ScrollingContainer sideSlider = new ScrollingContainer(){
        private final Rectangle empty = new Rectangle();

        @Override
        public Rectangle getBounds() {
            return this.empty;
        }

        @Override
        public int getMaxScrollHeight() {
            return 1;
        }
    };
    private final List<Reference> references = Lists.newArrayList();
    private final LazyResettable<Integer> sideExpandLimit = new LazyResettable<Integer>(() -> {
        int max = 0;
        for (Reference reference : this.references) {
            Component referenceText = reference.getText();
            int width = this.f_96547_.m_92852_((FormattedText)Component.m_237113_((String)(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ")).m_7220_(referenceText));
            if (width <= max) continue;
            max = width;
        }
        return Math.min(max + 8, this.f_96543_ / 4);
    });
    private boolean requestingReferenceRebuilding = false;

    @ApiStatus.Internal
    public GlobalizedClothConfigScreen(Screen parent, Component title, Map<String, ConfigCategory> categoryMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).m_14419_() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put(category.getCategoryKey(), entries);
        });
        this.sideSlider.scrollTo(0.0, false);
    }

    @Override
    public void requestReferenceRebuilding() {
        this.requestingReferenceRebuilding = true;
    }

    @Override
    public Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.sideExpandLimit.reset();
        this.references.clear();
        this.buildReferences();
        this.listWidget = new ClothConfigScreen.ListWidget(this, this.f_96541_, this.f_96543_ - 14, this.f_96544_, 30, this.f_96544_ - 32, this.getBackgroundLocation());
        this.m_7787_((GuiEventListener)this.listWidget);
        this.listWidget.setLeftPos(14);
        this.listWidget.m_6702_().add(new EmptyEntry(5));
        this.searchFieldEntry = new SearchFieldEntry(this, this.listWidget);
        this.listWidget.m_6702_().add(this.searchFieldEntry);
        this.listWidget.m_6702_().add(new EmptyEntry(5));
        this.categorizedEntries.forEach((category, entries) -> {
            if (!this.listWidget.m_6702_().isEmpty()) {
                this.listWidget.m_6702_().add(new EmptyEntry(5));
            }
            this.listWidget.m_6702_().add(new EmptyEntry(4));
            this.listWidget.m_6702_().add(new CategoryTextEntry((Component)category, (Component)category.m_6881_().m_130940_(ChatFormatting.BOLD)));
            this.listWidget.m_6702_().add(new EmptyEntry(4));
            this.listWidget.m_6702_().addAll((Collection<AbstractConfigEntry<AbstractConfigEntry<?>>>)entries);
        });
        int buttonWidths = Math.min(200, (this.f_96543_ - 50 - 12) / 3);
        this.cancelButton = Button.m_253074_((Component)(this.isEdited() ? Component.m_237115_((String)"text.cloth-config.cancel_discard") : Component.m_237115_((String)"gui.cancel")), widget -> this.quit()).m_252987_(0, this.f_96544_ - 26, buttonWidths, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.exitButton = new Button(0, this.f_96544_ - 26, buttonWidths, 20, (Component)Component.m_237119_(), button -> this.saveAll(true), Supplier::get){

            public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                block0: for (List<AbstractConfigEntry<?>> entries : GlobalizedClothConfigScreen.this.categorizedEntries.values()) {
                    for (AbstractConfigEntry<?> entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break block0;
                    }
                }
                this.f_93623_ = GlobalizedClothConfigScreen.this.isEdited() && !hasErrors;
                this.m_93666_((Component)(hasErrors ? Component.m_237115_((String)"text.cloth-config.error_cannot_save") : Component.m_237115_((String)"text.cloth-config.save_and_done")));
                super.m_86412_(matrices, mouseX, mouseY, delta);
            }
        };
        this.m_142416_((GuiEventListener)this.exitButton);
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    @Override
    public boolean matchesSearch(Iterator<String> tags) {
        return this.searchFieldEntry.matchesSearch(tags);
    }

    private void buildReferences() {
        this.categorizedEntries.forEach((categoryText, entries) -> {
            this.references.add(new CategoryReference((Component)categoryText));
            for (AbstractConfigEntry entry : entries) {
                this.buildReferenceFor(entry, 1);
            }
        });
    }

    private void buildReferenceFor(AbstractConfigEntry<?> entry, int layer) {
        List<ReferenceProvider<?>> referencableEntries = entry.getReferenceProviderEntries();
        if (referencableEntries != null) {
            this.references.add(new ConfigEntryReference(entry, layer));
            for (ReferenceProvider<?> referencableEntry : referencableEntries) {
                this.buildReferenceFor(referencableEntry.provideReferenceEntry(), layer + 1);
            }
        }
    }

    @Override
    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.lastHoveredReference = null;
        if (this.requestingReferenceRebuilding) {
            this.references.clear();
            this.buildReferences();
            this.requestingReferenceRebuilding = false;
        }
        int sliderPosition = this.getSideSliderPosition();
        ScissorsHandler.INSTANCE.scissor(new Rectangle(sliderPosition, 0, this.f_96543_ - sliderPosition, this.f_96544_));
        if (this.isTransparentBackground()) {
            GlobalizedClothConfigScreen.m_93179_((PoseStack)matrices, (int)14, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-1072689136, (int)-804253680);
        } else {
            this.m_264065_(matrices);
            this.overlayBackground(matrices, new Rectangle(14, 0, this.f_96543_, this.f_96544_), 64, 64, 64, 255, 255);
        }
        this.listWidget.width = this.f_96543_ - sliderPosition;
        this.listWidget.setLeftPos(sliderPosition);
        this.listWidget.m_86412_(matrices, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (AbstractConfigEntry<AbstractConfigEntry<?>> child : this.listWidget.m_6702_()) {
            child.lateRender(matrices, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.f_96547_.m_92744_(matrices, this.f_96539_.m_7532_(), (float)sliderPosition + (float)(this.f_96543_ - sliderPosition) / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f, 12.0f, -1);
        ScissorsHandler.INSTANCE.removeLastScissor();
        this.cancelButton.m_252865_(sliderPosition + (this.f_96543_ - sliderPosition) / 2 - this.cancelButton.m_5711_() - 3);
        this.exitButton.m_252865_(sliderPosition + (this.f_96543_ - sliderPosition) / 2 + 3);
        super.m_86412_(matrices, mouseX, mouseY, delta);
        this.sideSlider.updatePosition(delta);
        this.sideScroller.updatePosition(delta);
        if (this.isTransparentBackground()) {
            GlobalizedClothConfigScreen.m_93179_((PoseStack)matrices, (int)0, (int)0, (int)sliderPosition, (int)this.f_96544_, (int)-1240461296, (int)-972025840);
            GlobalizedClothConfigScreen.m_93179_((PoseStack)matrices, (int)0, (int)0, (int)(sliderPosition - 14), (int)this.f_96544_, (int)0x68000000, (int)0x68000000);
        } else {
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buffer = tesselator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172820_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getBackgroundLocation());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            buffer.m_5483_((double)(sliderPosition - 14), (double)this.f_96544_, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f).m_6122_(68, 68, 68, 255).m_5752_();
            buffer.m_5483_((double)sliderPosition, (double)this.f_96544_, 0.0).m_7421_(0.4375f, (float)this.f_96544_ / 32.0f).m_6122_(68, 68, 68, 255).m_5752_();
            buffer.m_5483_((double)sliderPosition, 0.0, 0.0).m_7421_(0.4375f, 0.0f).m_6122_(68, 68, 68, 255).m_5752_();
            buffer.m_5483_((double)(sliderPosition - 14), 0.0, 0.0).m_7421_(0.0f, 0.0f).m_6122_(68, 68, 68, 255).m_5752_();
            buffer.m_5483_(0.0, (double)this.f_96544_, 0.0).m_7421_(0.0f, (float)(this.f_96544_ + this.sideScroller.scrollAmountInt()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            buffer.m_5483_((double)(sliderPosition - 14), (double)this.f_96544_, 0.0).m_7421_((float)(sliderPosition - 14) / 32.0f, (float)(this.f_96544_ + this.sideScroller.scrollAmountInt()) / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            buffer.m_5483_((double)(sliderPosition - 14), 0.0, 0.0).m_7421_((float)(sliderPosition - 14) / 32.0f, (float)this.sideScroller.scrollAmountInt() / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            buffer.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, (float)this.sideScroller.scrollAmountInt() / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
            tesselator.m_85914_();
        }
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        int shadeColor = this.isTransparentBackground() ? 120 : 160;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, (float)(sliderPosition + 4), 0.0f, 100.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)sliderPosition, 0.0f, 100.0f).m_6122_(0, 0, 0, shadeColor).m_5752_();
        buffer.m_252986_(matrix, (float)sliderPosition, (float)this.f_96544_, 100.0f).m_6122_(0, 0, 0, shadeColor).m_5752_();
        buffer.m_252986_(matrix, (float)(sliderPosition + 4), (float)this.f_96544_, 100.0f).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, (float)(sliderPosition - 14), 0.0f, 100.0f).m_6122_(0, 0, 0, shadeColor /= 2).m_5752_();
        buffer.m_252986_(matrix, (float)(sliderPosition - 14 - 4), 0.0f, 100.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)(sliderPosition - 14 - 4), (float)this.f_96544_, 100.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)(sliderPosition - 14), (float)this.f_96544_, 100.0f).m_6122_(0, 0, 0, shadeColor).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        Rectangle slideArrowBounds = new Rectangle(sliderPosition - 14, 0, 14, this.f_96544_);
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.f_96547_.m_271978_(">", (float)(sliderPosition - 7) - (float)this.f_96547_.m_92895_(">") / 2.0f, (float)(this.f_96544_ / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | Mth.m_14045_((int)Mth.m_14165_((double)((1.0 - this.sideSlider.scrollAmount()) * 255.0)), (int)0, (int)255) << 24, false, matrices.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.f_96547_.m_271978_("<", (float)(sliderPosition - 7) - (float)this.f_96547_.m_92895_("<") / 2.0f, (float)(this.f_96544_ / 2), (slideArrowBounds.contains(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) | Mth.m_14045_((int)Mth.m_14165_((double)(this.sideSlider.scrollAmount() * 255.0)), (int)0, (int)255) << 24, false, matrices.m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        immediate.m_109911_();
        Rectangle scrollerBounds = this.sideScroller.getBounds();
        if (!scrollerBounds.isEmpty()) {
            ScissorsHandler.INSTANCE.scissor(new Rectangle(0, 0, sliderPosition - 14, this.f_96544_));
            int scrollOffset = scrollerBounds.y - this.sideScroller.scrollAmountInt();
            for (Reference reference : this.references) {
                matrices.m_85836_();
                matrices.m_85841_(reference.getScale(), reference.getScale(), reference.getScale());
                MutableComponent text = Component.m_237113_((String)(StringUtils.repeat((String)"  ", (int)reference.getIndent()) + "- ")).m_7220_(reference.getText());
                if (this.lastHoveredReference == null) {
                    int n = scrollerBounds.x;
                    int n2 = (int)((float)scrollOffset - 4.0f * reference.getScale());
                    int n3 = (int)((float)this.f_96547_.m_92852_((FormattedText)text) * reference.getScale());
                    Objects.requireNonNull(this.f_96547_);
                    if (new Rectangle(n, n2, n3, (int)((float)(9 + 4) * reference.getScale())).contains(mouseX, mouseY)) {
                        this.lastHoveredReference = reference;
                    }
                }
                this.f_96547_.m_92877_(matrices, text.m_7532_(), (float)scrollerBounds.x, (float)scrollOffset, this.lastHoveredReference == reference ? 16769544 : 0xFFFFFF);
                matrices.m_85849_();
                float f = scrollOffset;
                Objects.requireNonNull(this.f_96547_);
                scrollOffset = (int)(f + (float)(9 + 3) * reference.getScale());
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.sideScroller.renderScrollBar();
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.f_96544_);
        if (button == 0 && slideBounds.contains(mouseX, mouseY) && this.lastHoveredReference != null) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.lastHoveredReference.go();
            return true;
        }
        Rectangle slideArrowBounds = new Rectangle(this.getSideSliderPosition() - 14, 0, 14, this.f_96544_);
        if (button == 0 && slideArrowBounds.contains(mouseX, mouseY)) {
            this.setExpanded(!this.isExpanded());
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean isExpanded() {
        return this.sideSlider.scrollTarget() == 1.0;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.sideSlider.scrollTo(expanded ? 1.0 : 0.0, true, 2000L);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        Rectangle slideBounds = new Rectangle(0, 0, this.getSideSliderPosition() - 14, this.f_96544_);
        if (slideBounds.contains(mouseX, mouseY)) {
            this.sideScroller.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private int getSideSliderPosition() {
        return (int)(this.sideSlider.scrollAmount() * (double)this.sideExpandLimit.get().intValue() + 14.0);
    }

    private static interface Reference {
        default public int getIndent() {
            return 0;
        }

        public Component getText();

        public float getScale();

        public void go();
    }

    private class ConfigEntryReference
    implements Reference {
        private final AbstractConfigEntry<?> entry;
        private final int layer;

        public ConfigEntryReference(AbstractConfigEntry<?> entry, int layer) {
            this.entry = entry;
            this.layer = layer;
        }

        @Override
        public int getIndent() {
            return this.layer;
        }

        @Override
        public Component getText() {
            return this.entry.getFieldName();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int[] i = new int[]{0};
            for (AbstractConfigEntry<AbstractConfigEntry<?>> child : GlobalizedClothConfigScreen.this.listWidget.m_6702_()) {
                int i1 = i[0];
                if (this.goChild(i, null, child)) {
                    return;
                }
                i[0] = i1 + child.getItemHeight();
            }
        }

        private boolean goChild(int[] i, Integer expandedParent, AbstractConfigEntry<?> root) {
            boolean expanded;
            if (root == this.entry) {
                GlobalizedClothConfigScreen.this.listWidget.scrollTo(expandedParent == null ? (double)i[0] : (double)expandedParent.intValue(), true);
                return true;
            }
            int j = i[0];
            i[0] = i[0] + root.getInitialReferenceOffset();
            boolean bl = expanded = root instanceof Expandable && ((Expandable)((Object)root)).isExpanded();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(true);
            }
            List children = root.m_6702_();
            if (root instanceof Expandable) {
                ((Expandable)((Object)root)).setExpanded(expanded);
            }
            for (GuiEventListener child : children) {
                if (!(child instanceof ReferenceProvider)) continue;
                int i1 = i[0];
                if (this.goChild(i, expandedParent != null ? expandedParent : (root instanceof Expandable && !expanded ? Integer.valueOf(j) : null), ((ReferenceProvider)child).provideReferenceEntry())) {
                    return true;
                }
                i[0] = i1 + ((ReferenceProvider)child).provideReferenceEntry().getItemHeight();
            }
            return false;
        }
    }

    private class CategoryReference
    implements Reference {
        private final Component category;

        public CategoryReference(Component category) {
            this.category = category;
        }

        @Override
        public Component getText() {
            return this.category;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public void go() {
            int i = 0;
            for (AbstractConfigEntry<AbstractConfigEntry<?>> child : GlobalizedClothConfigScreen.this.listWidget.m_6702_()) {
                if (child instanceof CategoryTextEntry && ((CategoryTextEntry)child).category == this.category) {
                    GlobalizedClothConfigScreen.this.listWidget.scrollTo(i, true);
                    return;
                }
                i += child.getItemHeight();
            }
        }
    }

    private static class CategoryTextEntry
    extends AbstractConfigListEntry<Object> {
        private final Component category;
        private final Component text;

        public CategoryTextEntry(Component category, Component text) {
            super((Component)Component.m_237113_((String)UUID.randomUUID().toString()), false);
            this.category = category;
            this.text = text;
        }

        @Override
        public int getItemHeight() {
            List strings = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.text, this.getParent().getItemWidth());
            if (strings.isEmpty()) {
                return 0;
            }
            return 4 + strings.size() * 10;
        }

        @Override
        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            return null;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Optional<Object> getDefaultValue() {
            return Optional.empty();
        }

        @Override
        public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
            return false;
        }

        @Override
        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
            int yy = y + 2;
            List texts = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.text, this.getParent().getItemWidth());
            for (FormattedCharSequence text : texts) {
                Minecraft.m_91087_().f_91062_.m_92744_(matrices, text, (float)(x - 4 + entryWidth / 2 - Minecraft.m_91087_().f_91062_.m_92724_(text) / 2), (float)yy, -1);
                yy += 10;
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }
}

