/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs;

import com.corgam.cagedmobs.ClientSetup;
import com.corgam.cagedmobs.addons.theoneprobe.CagedMobsTOPSupport;
import com.corgam.cagedmobs.configs.ClientConfig;
import com.corgam.cagedmobs.configs.ServerConfig;
import com.corgam.cagedmobs.items.DnaSamplerDiamondItem;
import com.corgam.cagedmobs.items.DnaSamplerItem;
import com.corgam.cagedmobs.items.DnaSamplerNetheriteItem;
import com.corgam.cagedmobs.registers.CagedBlockEntities;
import com.corgam.cagedmobs.registers.CagedBlocks;
import com.corgam.cagedmobs.registers.CagedContainers;
import com.corgam.cagedmobs.registers.CagedItems;
import com.corgam.cagedmobs.registers.CagedRecipeSerializers;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cagedmobs")
public class CagedMobs {
    public static final String MOD_ID = "cagedmobs";
    public static final Logger LOGGER = LogManager.getLogger();
    final IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig();
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();

    public CagedMobs() {
        this.eventBus.addListener(ClientSetup::renderLayerSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG.getForgeConfigSpec());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG.getForgeConfigSpec());
        CagedBlocks.CAGED_BLOCKS_REGISTER.register(this.eventBus);
        CagedItems.CAGED_ITEMS_REGISTER.register(this.eventBus);
        CagedBlockEntities.CAGED_BLOCK_ENTITIES_REGISTER.register(this.eventBus);
        CagedRecipeTypes.CAGED_RECIPE_TYPES_REGISTER.register(this.eventBus);
        CagedRecipeSerializers.CAGED_RECIPE_SERIALIZERS_REGISTER.register(this.eventBus);
        CagedContainers.CAGED_MENU_TYPES_REGISTER.register(this.eventBus);
        this.eventBus.addListener(this::addPropertiesToItems);
        this.eventBus.addListener(this::initTOPSupport);
        this.eventBus.addListener(this::registerCagedMobsCreativeTab);
    }

    private void addPropertiesToItems(FMLClientSetupEvent event) {
        ItemProperties.register((Item)((Item)CagedItems.DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity, unusedInt) -> DnaSamplerItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CagedItems.DIAMOND_DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity, unusedInt) -> DnaSamplerDiamondItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)CagedItems.NETHERITE_DNA_SAMPLER.get()), (ResourceLocation)new ResourceLocation("cagedmobs:full"), (itemStack, clientWorld, livingEntity, unusedInt) -> DnaSamplerNetheriteItem.containsEntityType(itemStack) ? 1.0f : 0.0f);
    }

    private void initTOPSupport(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", CagedMobsTOPSupport::new);
        }
    }

    public void registerCagedMobsCreativeTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(new ResourceLocation(MOD_ID, "cagedmobs_tab"), builder -> builder.m_257941_((Component)Component.m_237115_((String)"itemGroup.cagedmobs_tab")).m_257737_(() -> new ItemStack((ItemLike)CagedItems.HOPPING_MOB_CAGE.get())).m_257501_((pParameters, pOutput) -> {
            pOutput.m_246326_((ItemLike)CagedItems.MOB_CAGE.get());
            pOutput.m_246326_((ItemLike)CagedItems.HOPPING_MOB_CAGE.get());
            pOutput.m_246326_((ItemLike)CagedItems.DNA_SAMPLER.get());
            pOutput.m_246326_((ItemLike)CagedItems.DIAMOND_DNA_SAMPLER.get());
            pOutput.m_246326_((ItemLike)CagedItems.NETHERITE_DNA_SAMPLER.get());
            pOutput.m_246326_((ItemLike)CagedItems.SPEED_I_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.SPEED_II_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.SPEED_III_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.LOOTING_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.ARROW_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.COOKING_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.LIGHTNING_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.EXPERIENCE_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.CREATIVE_UPGRADE.get());
            pOutput.m_246326_((ItemLike)CagedItems.DRAGON_SCALE.get());
            pOutput.m_246326_((ItemLike)CagedItems.NETHER_STAR_FRAGMENT.get());
            pOutput.m_246326_((ItemLike)CagedItems.WARDEN_RECEPTOR.get());
            pOutput.m_246326_((ItemLike)CagedItems.SPONGE_FRAGMENT.get());
            pOutput.m_246326_((ItemLike)CagedItems.HONEY_DROP.get());
            pOutput.m_246326_((ItemLike)CagedItems.MILK_DROP.get());
            pOutput.m_246326_((ItemLike)CagedItems.CRYSTALLIZED_EXPERIENCE.get());
            pOutput.m_246326_((ItemLike)CagedItems.CRYSTALLIZED_EXPERIENCE_BLOCK.get());
            pOutput.m_246326_((ItemLike)CagedItems.STAR_INFUSED_NETHERITE_NUGGET.get());
            pOutput.m_246326_((ItemLike)CagedItems.STAR_INFUSED_NETHERITE_INGOT.get());
            pOutput.m_246326_((ItemLike)CagedItems.STAR_INFUSED_NETHERITE_BLOCK.get());
            pOutput.m_246326_((ItemLike)CagedItems.EMPTY_SPAWN_EGG.get());
        }).m_257652_());
    }
}

