/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.jei;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.addons.jei.EntityDataCategory;
import com.corgam.cagedmobs.addons.jei.EntityDataWrapper;
import com.corgam.cagedmobs.items.DnaSamplerItem;
import com.corgam.cagedmobs.registers.CagedItems;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CagedMobsPlugin
implements IModPlugin {
    public static final RecipeType<EntityDataWrapper> ENTITY_RECIPE = RecipeType.create((String)"cagedmobs", (String)"entity", EntityDataWrapper.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("cagedmobs", "jei");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CagedItems.MOB_CAGE.get()), new RecipeType[]{ENTITY_RECIPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CagedItems.HOPPING_MOB_CAGE.get()), new RecipeType[]{ENTITY_RECIPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = RecipesHelper.getRecipeManager();
        ArrayList<EntityData> entities = new ArrayList<EntityData>(RecipesHelper.getEntitiesRecipesList(recipeManager));
        List<EntityType<?>> blacklistedEntities = RecipesHelper.getEntityTypesFromConfigList();
        if (!CagedMobs.SERVER_CONFIG.isEntitiesListInWhitelistMode()) {
            entities.removeIf(data -> blacklistedEntities.contains(data.getEntityType()));
        } else {
            entities.removeIf(data -> !blacklistedEntities.contains(data.getEntityType()));
        }
        registration.addRecipes(ENTITY_RECIPE, entities.stream().map(EntityDataWrapper::new).collect(Collectors.toList()));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new EntityDataCategory(guiHelper, ENTITY_RECIPE)});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        DnaSamplerSubtypeInterpreter interpreter = new DnaSamplerSubtypeInterpreter();
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)CagedItems.NETHERITE_DNA_SAMPLER.get()), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)CagedItems.DIAMOND_DNA_SAMPLER.get()), (IIngredientSubtypeInterpreter)interpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)CagedItems.DNA_SAMPLER.get()), (IIngredientSubtypeInterpreter)interpreter);
    }

    private static class DnaSamplerSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private DnaSamplerSubtypeInterpreter() {
        }

        public String apply(ItemStack ingredient, UidContext context) {
            DnaSamplerItem sampler;
            EntityType<?> entityType;
            Item item = ingredient.m_41720_();
            if (item instanceof DnaSamplerItem && (entityType = (sampler = (DnaSamplerItem)item).getEntityType(ingredient)) != null) {
                return sampler.getEntityType(ingredient).toString();
            }
            return "";
        }
    }
}

