/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.addons.jei;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlockEntity;
import com.corgam.cagedmobs.helpers.EntityRendererHelper;
import com.corgam.cagedmobs.registers.CagedItems;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.entity.AdditionalLootData;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import com.corgam.cagedmobs.serializers.entity.LootData;
import com.corgam.cagedmobs.serializers.environment.EnvironmentData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class EntityDataWrapper
implements IRecipeCategoryExtension {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private final EntityData entityData;
    private final List<ItemStack> envs = NonNullList.m_122779_();
    private final List<LootData> drops = NonNullList.m_122779_();
    private final List<ItemStack> samplers = NonNullList.m_122779_();
    private final List<Integer> cookedIDs = new ArrayList<Integer>();
    private final boolean requiresWater;
    private final int ticks;
    public static float rotation = 0.0f;
    private static double yaw = 0.0;

    public EntityDataWrapper(EntityData entityData) {
        this.entityData = entityData;
        for (EnvironmentData env : RecipesHelper.getEnvsRecipesList(RecipesHelper.getRecipeManager())) {
            if (!RecipesHelper.isEnvValidForEntity(entityData, env)) continue;
            this.envs.addAll(Arrays.asList(env.getInputItem().m_43908_()));
        }
        if (entityData.getSamplerTier() >= 3) {
            this.samplers.add(new ItemStack((ItemLike)CagedItems.NETHERITE_DNA_SAMPLER.get()));
        } else if (entityData.getSamplerTier() == 2) {
            this.samplers.add(new ItemStack((ItemLike)CagedItems.NETHERITE_DNA_SAMPLER.get()));
            this.samplers.add(new ItemStack((ItemLike)CagedItems.DIAMOND_DNA_SAMPLER.get()));
        } else {
            this.samplers.add(new ItemStack((ItemLike)CagedItems.NETHERITE_DNA_SAMPLER.get()));
            this.samplers.add(new ItemStack((ItemLike)CagedItems.DIAMOND_DNA_SAMPLER.get()));
            this.samplers.add(new ItemStack((ItemLike)CagedItems.DNA_SAMPLER.get()));
        }
        int lootIndex = 0;
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData lootData : entityData.getResults()) {
            if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                if (blacklistedItems.contains(lootData.getItem().m_41720_()) || this.drops.contains(lootData)) continue;
                this.drops.add(lootData);
                ++lootIndex;
                if (!lootData.isCooking()) continue;
                this.drops.add(lootData);
                this.cookedIDs.add(lootIndex);
                ++lootIndex;
                continue;
            }
            if (!blacklistedItems.contains(lootData.getItem().m_41720_()) || this.drops.contains(lootData)) continue;
            this.drops.add(lootData);
            ++lootIndex;
            if (!lootData.isCooking()) continue;
            this.drops.add(lootData);
            this.cookedIDs.add(lootIndex);
            ++lootIndex;
        }
        for (Recipe recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ADDITIONAL_LOOT_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            AdditionalLootData additionalLootData;
            if (!(recipe instanceof AdditionalLootData) || (additionalLootData = (AdditionalLootData)recipe).getEntityType() == null || this.entityData.getEntityType() == null || !this.entityData.getEntityType().equals(additionalLootData.getEntityType())) continue;
            for (LootData data : additionalLootData.getResults()) {
                if (!additionalLootData.isRemoveFromEntity()) {
                    if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                        if (blacklistedItems.contains(data.getItem().m_41720_()) || this.drops.contains(data)) continue;
                        this.drops.add(data);
                        ++lootIndex;
                        if (!data.isCooking()) continue;
                        this.drops.add(data);
                        this.cookedIDs.add(lootIndex);
                        ++lootIndex;
                        continue;
                    }
                    if (!blacklistedItems.contains(data.getItem().m_41720_()) || this.drops.contains(data)) continue;
                    this.drops.add(data);
                    ++lootIndex;
                    if (!data.isCooking()) continue;
                    this.drops.add(data);
                    this.cookedIDs.add(lootIndex);
                    ++lootIndex;
                    continue;
                }
                this.drops.removeIf(drop -> drop.getItem().m_41720_().equals(data.getItem().m_41720_()));
            }
        }
        this.ticks = entityData.getTotalGrowTicks();
        this.requiresWater = entityData.ifRequiresWater();
    }

    public List<LootData> getDrops() {
        return this.drops;
    }

    public List<ItemStack> getEnvsItems() {
        return this.envs;
    }

    public EntityData getEntityData() {
        return this.entityData;
    }

    public List<ItemStack> getSamplers() {
        return this.samplers;
    }

    public List<Integer> getCookedIDs() {
        return this.cookedIDs;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getSeconds() {
        return this.ticks / 20;
    }

    public boolean ifRequiresWater() {
        return this.requiresWater;
    }

    public void setRecipe(IRecipeLayoutBuilder builder) {
        SpawnEggItem spawnEgg;
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(this.getSamplers());
        IRecipeSlotBuilder samplersSlot = builder.addSlot(RecipeIngredientRole.INPUT, 15, 82);
        ((IRecipeSlotBuilder)samplersSlot.addItemStacks(this.getSampledSamplers())).setSlotName("samplers");
        if (!CagedMobs.SERVER_CONFIG.areSpawnEggsDisabled() && (spawnEgg = ForgeSpawnEggItem.fromEntityType(this.entityData.getEntityType())) != null) {
            samplersSlot.addItemStack(spawnEgg.m_7968_());
        }
        IRecipeSlotBuilder environmentsSlot = builder.addSlot(RecipeIngredientRole.INPUT, 35, 82);
        ((IRecipeSlotBuilder)environmentsSlot.addItemStacks(this.getEnvsItems())).setSlotName("environments");
        environmentsSlot.addTooltipCallback(this.getEnvTooltip());
        int nextSlotId = 2;
        List<Item> blacklistedItems = RecipesHelper.getItemsFromConfigList();
        for (LootData entry : this.getDrops()) {
            IRecipeSlotBuilder lootSlot;
            int relativeSlotId;
            if (!CagedMobs.SERVER_CONFIG.isItemsListInWhitelistMode()) {
                if (blacklistedItems.contains(entry.getItem().m_41720_())) continue;
                relativeSlotId = nextSlotId - 2;
                lootSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 101 + 19 * (relativeSlotId % 4), 6 + 19 * (relativeSlotId / 4));
                if (entry.isCooking() && this.getCookedIDs().contains(relativeSlotId)) {
                    lootSlot.addItemStack(entry.getCookedItem());
                } else {
                    lootSlot.addItemStack(entry.getItem());
                }
                ++nextSlotId;
                lootSlot.addTooltipCallback(this.getLootTooltip(entry));
                continue;
            }
            if (!blacklistedItems.contains(entry.getItem().m_41720_())) continue;
            relativeSlotId = nextSlotId - 2;
            lootSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 100 + 19 * (relativeSlotId % 4), 5 + 19 * (relativeSlotId / 4));
            if (entry.isCooking() && this.getCookedIDs().contains(relativeSlotId)) {
                lootSlot.addItemStack(entry.getCookedItem());
            } else {
                lootSlot.addItemStack(entry.getItem());
            }
            ++nextSlotId;
            lootSlot.addTooltipCallback(this.getLootTooltip(entry));
        }
    }

    public void draw(PoseStack pGuiGraphics, IGuiHelper guiHelper) {
        guiHelper.getSlotDrawable().draw(pGuiGraphics, 14, 81);
        guiHelper.getSlotDrawable().draw(pGuiGraphics, 34, 81);
        for (int nextSlotId = 2; nextSlotId < 22; ++nextSlotId) {
            int relativeSlotId = nextSlotId - 2;
            guiHelper.getSlotDrawable().draw(pGuiGraphics, 100 + 19 * (relativeSlotId % 4), 5 + 19 * (relativeSlotId / 4));
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Optional<Entity> entity = EntityRendererHelper.createEntity((Level)level, this.getEntityData().getEntityType(), null);
        if (entity.isPresent()) {
            rotation = (rotation + 0.5f) % 360.0f;
            EntityRendererHelper.renderEntity(pGuiGraphics, 33, 120, 38.0 - yaw, 70.0, rotation, entity.get());
            yaw = (yaw + 1.5) % 720.0;
        }
        if (this.getEntityData() != null && this.getEntityData().getEntityType() != null) {
            Minecraft.m_91087_().f_91062_.m_92889_(pGuiGraphics, this.getEntityData().getEntityType().m_20676_(), 5.0f, 2.0f, 8);
        }
        Minecraft.m_91087_().f_91062_.m_92889_(pGuiGraphics, (Component)Component.m_237110_((String)"jei.tooltip.cagedmobs.entity.ticks", (Object[])new Object[]{this.getSeconds()}), 10.0f, 102.0f, 8);
        if (this.ifRequiresWater()) {
            Minecraft.m_91087_().f_91062_.m_92889_(pGuiGraphics, (Component)Component.m_237115_((String)"jei.tooltip.cagedmobs.entity.requiresWater").m_130940_(ChatFormatting.BLUE), 5.0f, 112.0f, 8);
        }
    }

    public List<ItemStack> getSampledSamplers() {
        NonNullList ret = NonNullList.m_122779_();
        for (ItemStack stack : this.samplers) {
            stack = stack.m_41777_();
            EntityType<?> type = this.entityData.getEntityType();
            CompoundTag nbt = new CompoundTag();
            SerializationHelper.serializeEntityTypeNBT(nbt, type);
            stack.m_41751_(nbt);
            ret.add(stack);
        }
        return ret;
    }

    private IRecipeSlotTooltipCallback getEnvTooltip() {
        return (view, tooltip) -> {
            ItemStack displayedItem;
            EnvironmentData env;
            if (view.getDisplayedItemStack().isPresent() && (env = MobCageBlockEntity.getEnvironmentDataFromItemStack(displayedItem = (ItemStack)view.getDisplayedItemStack().get())) != null) {
                tooltip.add(Component.m_237110_((String)"jei.tooltip.cagedmobs.entity.growModifier", (Object[])new Object[]{DECIMAL_FORMAT.format(env.getGrowModifier() * 100.0f - 100.0f)}));
            }
        };
    }

    private IRecipeSlotTooltipCallback getLootTooltip(LootData entry) {
        return (view, tooltip) -> {
            if (view.getDisplayedItemStack().isPresent()) {
                ItemStack displayedItem = (ItemStack)view.getDisplayedItemStack().get();
                tooltip.add(Component.m_237110_((String)"jei.tooltip.cagedmobs.entity.chance", (Object[])new Object[]{DECIMAL_FORMAT.format(entry.getChance() * 100.0f)}));
                if (entry.getMinAmount() == entry.getMaxAmount()) {
                    tooltip.add(Component.m_237110_((String)"jei.tooltip.cagedmobs.entity.amountEqual", (Object[])new Object[]{entry.getMinAmount()}));
                } else {
                    tooltip.add(Component.m_237110_((String)"jei.tooltip.cagedmobs.entity.amount", (Object[])new Object[]{entry.getMinAmount(), entry.getMaxAmount()}));
                }
                if (entry.isLighting()) {
                    tooltip.add(Component.m_237115_((String)"jei.tooltip.cagedmobs.entity.lightning_upgrade").m_130940_(ChatFormatting.YELLOW));
                }
                if (entry.isCooking() && displayedItem.m_41720_().equals(entry.getCookedItem().m_41720_())) {
                    tooltip.add(Component.m_237115_((String)"jei.tooltip.cagedmobs.entity.cooking_upgrade").m_130940_(ChatFormatting.YELLOW));
                }
                if (entry.isArrow()) {
                    tooltip.add(Component.m_237115_((String)"jei.tooltip.cagedmobs.entity.arrow_upgrade").m_130940_(ChatFormatting.YELLOW));
                }
                if (entry.hasColor()) {
                    tooltip.add(Component.m_237115_((String)"jei.tooltip.cagedmobs.entity.colorItem").m_130940_(ChatFormatting.YELLOW));
                }
            }
        };
    }
}

