/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.blocks.mob_cage;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.addons.theoneprobe.ITopInfoProvider;
import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlockEntity;
import com.corgam.cagedmobs.blocks.mob_cage.MobCageContainer;
import com.corgam.cagedmobs.items.DnaSamplerDiamondItem;
import com.corgam.cagedmobs.items.DnaSamplerItem;
import com.corgam.cagedmobs.items.DnaSamplerNetheriteItem;
import com.corgam.cagedmobs.items.EmptySpawnEggItem;
import com.corgam.cagedmobs.items.upgrades.UpgradeItem;
import com.corgam.cagedmobs.registers.CagedBlockEntities;
import com.corgam.cagedmobs.registers.CagedItems;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MobCageBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
ITopInfoProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty HOPPING = BooleanProperty.m_61465_((String)"hopping");
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public MobCageBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HOPPING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{HOPPING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MobCageBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(final BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MobCageBlockEntity) {
            final MobCageBlockEntity cageBE = (MobCageBlockEntity)be;
            ItemStack heldItem = player.m_21120_(hand);
            if (!cageBE.hasEnvironment()) {
                if (MobCageBlockEntity.existsEnvironmentFromItemStack(heldItem)) {
                    cageBE.setEnvironment(heldItem);
                    if (!player.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            if (cageBE.acceptsUpgrades() && heldItem.m_41720_() instanceof UpgradeItem) {
                cageBE.addUpgrade(heldItem);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            Item item = heldItem.m_41720_();
            if (item instanceof DnaSamplerItem) {
                DnaSamplerItem sampler = (DnaSamplerItem)item;
                if (!CagedMobs.SERVER_CONFIG.areSamplersDisabled()) {
                    if (!cageBE.hasEntity()) {
                        if (cageBE.existsEntityDataFromType(sampler.getEntityType(heldItem)) && cageBE.isEnvironmentSuitable(player, sampler.getEntityType(heldItem), state) && !RecipesHelper.isEntityTypeBlacklisted(sampler.getEntityType(heldItem))) {
                            cageBE.setEntityFromSampler(sampler.getEntityType(heldItem), heldItem);
                            if (!player.m_7500_()) {
                                if (CagedMobs.SERVER_CONFIG.areSamplersSingleUse()) {
                                    player.m_21190_(hand);
                                    heldItem.m_41774_(1);
                                } else {
                                    sampler.removeEntityType(heldItem);
                                }
                            }
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                    if (!DnaSamplerItem.containsEntityType(heldItem) && cageBE.getEntity().isPresent()) {
                        if (cageBE.getEntity().get().getSamplerTier() >= 3 && !(heldItem.m_41720_() instanceof DnaSamplerNetheriteItem)) {
                            player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.samplerNotSufficient").m_130940_(ChatFormatting.RED), true);
                            return InteractionResult.FAIL;
                        }
                        if (cageBE.getEntity().get().getSamplerTier() >= 2 && !(heldItem.m_41720_() instanceof DnaSamplerNetheriteItem) && !(heldItem.m_41720_() instanceof DnaSamplerDiamondItem)) {
                            player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.samplerNotSufficient").m_130940_(ChatFormatting.RED), true);
                            return InteractionResult.FAIL;
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.cageAlreadyUsed").m_130940_(ChatFormatting.RED), true);
                        return InteractionResult.FAIL;
                    }
                    sampler.setEntityTypeFromCage(cageBE, heldItem, player, hand);
                    cageBE.m_6596_();
                    cageBE.removeEntity();
                    return InteractionResult.SUCCESS;
                }
            }
            if ((item = heldItem.m_41720_()) instanceof SpawnEggItem) {
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                if (!CagedMobs.SERVER_CONFIG.areSpawnEggsDisabled()) {
                    if (!cageBE.hasEntity()) {
                        EntityType entityType = spawnEggItem.m_43228_(heldItem.m_41784_());
                        if (cageBE.existsEntityDataFromType(entityType) && cageBE.isEnvironmentSuitable(player, entityType, state) && !RecipesHelper.isEntityTypeBlacklisted(entityType)) {
                            cageBE.setEntityFromSampler(entityType, heldItem);
                            if (!player.m_7500_()) {
                                heldItem.m_41774_(1);
                                player.m_36356_(new ItemStack((ItemLike)CagedItems.EMPTY_SPAWN_EGG.get()));
                            }
                            return InteractionResult.SUCCESS;
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.cageAlreadyUsed").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.spawnEggsDisabled").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.CONSUME;
            }
            if (heldItem.m_41720_() instanceof EmptySpawnEggItem) {
                if (!CagedMobs.SERVER_CONFIG.areSpawnEggsDisabled()) {
                    if (cageBE.hasEntity()) {
                        SpawnEggItem spawnEgg = ForgeSpawnEggItem.fromEntityType(cageBE.getEntityType());
                        if (spawnEgg != null) {
                            if (!player.m_7500_()) {
                                player.m_36356_(new ItemStack((ItemLike)spawnEgg));
                                heldItem.m_41774_(1);
                            }
                            cageBE.removeEntity();
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.spawnEggsDisabled").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
            }
            if (heldItem.m_41720_() instanceof SwordItem && (!((Boolean)state.m_61143_((Property)HOPPING)).booleanValue() || CagedMobs.SERVER_CONFIG.ifHoppingCagesDisabled()) && cageBE.isWaitingForHarvest()) {
                cageBE.onPlayerHarvest(cageBE.m_58900_());
                if (!player.m_7500_() && !level.m_5776_()) {
                    heldItem.m_220157_(1, level.f_46441_, null);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_6047_() && cageBE.hasEntity()) {
                cageBE.removeEntity();
                cageBE.m_6596_();
                return InteractionResult.SUCCESS;
            }
            MenuProvider containerProvider = new MenuProvider(){

                public Component m_5446_() {
                    return (Boolean)state.m_61143_((Property)HOPPING) != false ? Component.m_237115_((String)"block.cagedmobs.hopping_mob_cage") : Component.m_237115_((String)"block.cagedmobs.mob_cage");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                    MobCageContainer menu = new MobCageContainer(pContainerId, pPlayer, pos);
                    menu.m_38893_(new ContainerListener(){

                        public void m_7934_(AbstractContainerMenu pContainerToSend, int pDataSlotIndex, ItemStack pStack) {
                            if (pDataSlotIndex == MobCageBlockEntity.ENVIRONMENT_SLOT) {
                                cageBE.updateEnvironment();
                            }
                        }

                        public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
                        }
                    });
                    return menu;
                }
            };
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)cageBE.m_58899_());
            return InteractionResult.SUCCESS;
        }
        throw new IllegalStateException("Mob Cage container provider is missing!");
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MobCageBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)CagedBlockEntities.MOB_CAGE_BLOCK_ENTITY.get()), MobCageBlockEntity::tick);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof MobCageBlockEntity) {
                MobCageBlockEntity tile = (MobCageBlockEntity)blockentity;
                tile.dropInventory();
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack item, @javax.annotation.Nullable BlockGetter getter, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.mainInfo").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.rightClickHarvest").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.envInfo").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.cagedmobs.mob_cage.upgrading").m_130940_(ChatFormatting.GRAY));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity blockEntity = world.m_7702_(data.getPos());
        if (blockEntity instanceof MobCageBlockEntity) {
            MobCageBlockEntity tile = (MobCageBlockEntity)blockEntity;
            if (tile.hasEnvironment() && tile.hasEntity()) {
                probeInfo.progress((int)(tile.getGrowthPercentage() * 100.0f), 100, probeInfo.defaultProgressStyle().suffix("%").filledColor(-12277180).alternateFilledColor(-12277180).backgroundColor(-8165037));
            }
            if (tile.hasEnvironment()) {
                probeInfo.horizontal().text((Component)Component.m_237115_((String)"JADE.tooltip.cagedmobs.cage.environment"));
                ItemStack envItem = tile.getInventoryHandler().getStackInSlot(MobCageBlockEntity.ENVIRONMENT_SLOT);
                if (!envItem.m_41619_()) {
                    probeInfo.horizontal().item(envItem).itemLabel(envItem);
                }
            }
            if (tile.hasEntity()) {
                probeInfo.horizontal().text(Component.m_237115_((String)"JADE.tooltip.cagedmobs.cage.entity").m_130940_(ChatFormatting.GRAY).getString() + Component.m_237115_((String)tile.getEntityType().m_20675_()).m_130940_(ChatFormatting.GRAY).getString());
            }
            if (tile.hasAnyUpgrades()) {
                probeInfo.horizontal().text((Component)Component.m_237115_((String)"TOP.tooltip.cagedmobs.cage.upgrades"));
                IProbeInfo hor = probeInfo.horizontal();
                for (ItemStack upgrade : tile.getUpgradesAsItemStacks()) {
                    if (upgrade.m_41619_()) continue;
                    hor.item(upgrade);
                }
            }
        }
    }
}

