/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.blocks.mob_cage;

import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlockEntity;
import com.corgam.cagedmobs.helpers.EnvironmentItemSlotHandler;
import com.corgam.cagedmobs.helpers.UpgradeItemSlotHandler;
import com.corgam.cagedmobs.items.upgrades.UpgradeItem;
import com.corgam.cagedmobs.registers.CagedBlocks;
import com.corgam.cagedmobs.registers.CagedContainers;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class MobCageContainer
extends AbstractContainerMenu {
    public final BlockPos pos;
    public final Player player;
    private Slot environmentSlot = null;
    private final ArrayList<Slot> upgradeSlots = new ArrayList();

    public MobCageContainer(int pWindowId, Player pPlayer, BlockPos pPos) {
        super((MenuType)CagedContainers.CAGE_CONTAINER.get(), pWindowId);
        this.pos = pPos;
        this.player = pPlayer;
        BlockEntity blockEntity = pPlayer.f_19853_.m_7702_(this.pos);
        if (blockEntity instanceof MobCageBlockEntity) {
            MobCageBlockEntity cage = (MobCageBlockEntity)blockEntity;
            this.environmentSlot = this.m_38897_((Slot)new EnvironmentItemSlotHandler((IItemHandler)cage.getInventoryHandler(), MobCageBlockEntity.ENVIRONMENT_SLOT, 26, 44));
            this.upgradeSlots.add(this.m_38897_((Slot)new UpgradeItemSlotHandler((IItemHandler)cage.getInventoryHandler(), MobCageBlockEntity.ENVIRONMENT_SLOT + 1, 134, 23)));
            this.upgradeSlots.add(this.m_38897_((Slot)new UpgradeItemSlotHandler((IItemHandler)cage.getInventoryHandler(), MobCageBlockEntity.ENVIRONMENT_SLOT + 2, 134, 44)));
            this.upgradeSlots.add(this.m_38897_((Slot)new UpgradeItemSlotHandler((IItemHandler)cage.getInventoryHandler(), MobCageBlockEntity.ENVIRONMENT_SLOT + 3, 134, 65)));
        }
        this.layoutPlayerInventorySlots(pPlayer.m_150109_(), 8, 101);
    }

    private void layoutPlayerInventorySlots(Inventory inventory, int leftCol, int topRow) {
        this.addSlotBox((Container)inventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange((Container)inventory, 0, leftCol, topRow += 58, 9, 18);
    }

    private int addSlotBox(Container playerInventory, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(playerInventory, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private int addSlotRange(Container playerInventory, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_(new Slot(playerInventory, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemstack = slotItem.m_41777_();
            if (pIndex < MobCageBlockEntity.SLOT_COUNT) {
                if (!this.m_38903_(slotItem, MobCageBlockEntity.SLOT_COUNT, 36 + MobCageBlockEntity.SLOT_COUNT, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (slotItem.m_41720_() instanceof UpgradeItem) {
                for (int i = MobCageBlockEntity.ENVIRONMENT_SLOT + 1; i < MobCageBlockEntity.SLOT_COUNT; ++i) {
                    if (((Slot)this.f_38839_.get(i)).m_6657_() || !((Slot)this.f_38839_.get(i)).m_5857_(slotItem)) continue;
                    ItemStack itemstack2 = slotItem.m_255036_(1);
                    slotItem.m_41774_(1);
                    ((Slot)this.f_38839_.get(i)).m_269060_(itemstack2);
                }
            } else if (MobCageBlockEntity.existsEnvironmentFromItemStack(slotItem) && !((Slot)this.f_38839_.get(MobCageBlockEntity.ENVIRONMENT_SLOT)).m_6657_() && ((Slot)this.f_38839_.get(MobCageBlockEntity.ENVIRONMENT_SLOT)).m_5857_(slotItem)) {
                ItemStack itemstack2 = slotItem.m_255036_(1);
                slotItem.m_41774_(1);
                ((Slot)this.f_38839_.get(MobCageBlockEntity.ENVIRONMENT_SLOT)).m_269060_(itemstack2);
            }
            if (slotItem.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, slotItem);
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return MobCageContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)pPlayer.f_19853_, (BlockPos)this.pos), (Player)pPlayer, (Block)((Block)CagedBlocks.MOB_CAGE.get())) || MobCageContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)pPlayer.f_19853_, (BlockPos)this.pos), (Player)pPlayer, (Block)((Block)CagedBlocks.HOPPING_MOB_CAGE.get()));
    }

    public Slot getEnvironmentSlot() {
        return this.environmentSlot;
    }

    public ArrayList<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }
}

