/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.blocks.mob_cage;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlockEntity;
import com.corgam.cagedmobs.registers.CagedItems;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

@OnlyIn(value=Dist.CLIENT)
public class MobCageRenderer
implements BlockEntityRenderer<MobCageBlockEntity> {
    public MobCageRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MobCageBlockEntity tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.getEnvironmentData() != null && CagedMobs.CLIENT_CONFIG.shouldEnvsRender()) {
            matrix.m_85836_();
            matrix.m_85841_(0.74f, 0.015f, 0.74f);
            matrix.m_85837_(0.17, 5.0, 0.17);
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            dispatcher.m_110912_(tile.getEnvironmentData().getRenderState(), matrix, buffer, combinedLightIn, combinedOverlayIn);
            matrix.m_85849_();
        }
        if (tile.hasEntity() && CagedMobs.CLIENT_CONFIG.shouldEntitiesRender()) {
            matrix.m_85836_();
            matrix.m_85837_(0.5, 0.0, 0.5);
            Entity entity = tile.getCachedEntity(tile.m_58904_());
            if (entity != null) {
                float maxSize = this.getEntitySize(entity);
                float maxEntityDimension = Math.max(entity.m_20205_(), entity.m_20206_());
                if ((double)maxEntityDimension > 1.0) {
                    maxSize /= maxEntityDimension;
                }
                matrix.m_85837_(0.0, (double)0.1f, 0.0);
                if (CagedMobs.CLIENT_CONFIG.shouldGrowthRender()) {
                    float growthPercentage = tile.getGrowthPercentage() * maxSize;
                    if (tile.hasUpgrades((Item)CagedItems.CREATIVE_UPGRADE.get(), 1)) {
                        growthPercentage = maxSize;
                    }
                    matrix.m_85841_(growthPercentage, growthPercentage, growthPercentage);
                } else {
                    matrix.m_85841_(maxSize, maxSize, maxSize);
                }
                if (entity instanceof Sheep) {
                    ((Sheep)entity).m_29855_(DyeColor.m_41053_((int)tile.getColor()));
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91290_().m_114384_(entity, 0.0, 0.0, this.getEntityZ(entity), 0.0f, partialTicks, matrix, buffer, combinedLightIn));
            }
            matrix.m_85849_();
        }
    }

    private double getEntityZ(Entity entity) {
        if (entity instanceof Dolphin) {
            return 0.25;
        }
        if (entity instanceof ElderGuardian) {
            return 1.2;
        }
        if (entity instanceof Guardian) {
            return 0.7;
        }
        if (entity instanceof Hoglin || entity instanceof Zoglin) {
            return -0.3f;
        }
        return 0.0;
    }

    private float getEntitySize(Entity entity) {
        if (entity instanceof Dolphin || entity instanceof Panda || entity instanceof Pig || entity instanceof PolarBear || entity instanceof Squid || entity instanceof Turtle || entity instanceof Hoglin || entity instanceof Ravager || entity instanceof Shulker || entity instanceof Zoglin) {
            return 0.32f;
        }
        if (entity instanceof AbstractHorse) {
            return 0.4f;
        }
        if (entity instanceof Guardian || entity instanceof Phantom) {
            return 0.25f;
        }
        if (entity instanceof EnderDragon) {
            return 0.8f;
        }
        return 0.5f;
    }
}

