/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.helpers;

import com.corgam.cagedmobs.CagedMobs;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.Level;

public class EntityRendererHelper {
    public static Optional<Entity> createEntity(Level level, EntityType<?> entityType, CompoundTag startingNbt) {
        Optional entity = Optional.empty();
        try {
            if (startingNbt == null) {
                startingNbt = new CompoundTag();
            }
            startingNbt.m_128359_("id", EntityType.m_20613_(entityType).toString());
            if (level != null && level.m_5776_()) {
                entity = EntityType.m_20642_((CompoundTag)startingNbt, (Level)level);
            }
        }
        catch (Exception e) {
            CagedMobs.LOGGER.error("[CagedMobs] Rendering entity in the JEI failed!", (Throwable)e);
        }
        return entity;
    }

    public static void renderEntity(PoseStack graphics, int x, int y, double yaw, double pitch, float rotation, Entity entity) {
        graphics.m_85836_();
        float scale = EntityRendererHelper.getScaleForEntityType(entity);
        graphics.m_252880_((float)x, (float)(y -= EntityRendererHelper.getOffsetForEntityType(entity)), 50.0f);
        graphics.m_85841_(-scale, scale, scale);
        graphics.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        graphics.m_252781_(Axis.f_252436_.m_252977_(rotation -= (float)EntityRendererHelper.getOffsetForEntityType(entity)));
        MultiBufferSource.BufferSource buff = Minecraft.m_91087_().m_91269_().m_110104_();
        try {
            Minecraft.m_91087_().m_91290_().m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, graphics, (MultiBufferSource)buff, 0xF000F0);
        }
        catch (Exception e) {
            graphics.m_252880_((float)x, (float)y, -50.0f);
            graphics.m_85841_(scale, -scale, -scale);
            graphics.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            CagedMobs.LOGGER.error("[CagedMobs] Rendering entity in the JEI failed!", (Throwable)e);
        }
        buff.m_109911_();
        graphics.m_85849_();
    }

    public static float getScaleForEntityType(Entity entity) {
        float width = entity.m_20205_();
        float height = entity.m_20206_();
        if (entity.m_6095_().toString().contains("twilightforest.ur_ghast")) {
            return 2.0f;
        }
        if (entity.m_6095_().toString().contains("greekfantasy.charybdis")) {
            return 3.0f;
        }
        if (entity.m_6095_().toString().contains("twilightforest.hydra")) {
            return 3.2f;
        }
        if (entity.m_6095_().toString().contains("twilightforest.yeti_alpha")) {
            return 6.0f;
        }
        if (entity.m_6095_().toString().contains("minecraft.ender_dragon")) {
            return 5.0f;
        }
        if (entity.m_6095_().toString().contains("twilightforest.armored_giant")) {
            return 6.0f;
        }
        if (entity.m_6095_().toString().contains("twilightforest.giant_miner")) {
            return 6.0f;
        }
        if (entity.m_6095_().toString().contains("twilightforest.mini_ghast")) {
            return 10.0f;
        }
        if (entity.m_6095_().toString().contains("outvoted:kraken")) {
            return 2.0f;
        }
        if (entity.m_6095_().toString().contains("mowziesmobs:frostmaw")) {
            return 10.0f;
        }
        if (entity.m_6095_().toString().contains("alexsmobs:cachalot_whale")) {
            return 0.2f;
        }
        if (entity.m_6095_().toString().contains("greekfantasy:giant_boar")) {
            return 10.0f;
        }
        if (entity.m_6095_().toString().contains("alexsmobs:crocodile")) {
            return 6.0f;
        }
        if (entity.m_6095_().toString().contains("alexsmobs:hammerhead_shark")) {
            return 6.0f;
        }
        if (entity.m_6095_().toString().contains("upgrade_aquatic:great_thrasher")) {
            return 2.0f;
        }
        if (entity.m_6095_().toString().contains("fireandice:cyclops")) {
            return 2.0f;
        }
        if (entity.m_6095_().toString().contains("alexsmobs:cachalot_whale")) {
            return 0.5f;
        }
        if (entity.m_6095_().toString().contains("alexsmobs:laviathan")) {
            return 0.5f;
        }
        if (entity.m_6095_().toString().contains("alexsmobs:void_worm")) {
            return 1.0f;
        }
        if (entity instanceof ElderGuardian) {
            return 10.0f;
        }
        if (entity instanceof AbstractFish) {
            return 25.0f;
        }
        if (entity instanceof Ghast) {
            return 5.2f;
        }
        if (entity instanceof Sniffer) {
            return 16.0f;
        }
        if (width <= height) {
            if (height >= 3.0f) {
                return 10.0f;
            }
            if ((double)height >= 2.5) {
                return 15.0f;
            }
            if ((double)height >= 1.9) {
                return 18.0f;
            }
        }
        return 20.0f;
    }

    public static int getOffsetForEntityType(Entity entity) {
        if (entity instanceof Phantom || entity instanceof AbstractFish || entity instanceof EnderDragon || entity instanceof Dolphin || entity instanceof Guardian || entity instanceof Turtle) {
            return 60;
        }
        if (entity instanceof Ghast || entity instanceof Squid) {
            return 65;
        }
        return 50;
    }
}

