/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.items;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.blocks.mob_cage.MobCageBlockEntity;
import com.corgam.cagedmobs.items.DnaSamplerDiamondItem;
import com.corgam.cagedmobs.items.DnaSamplerNetheriteItem;
import com.corgam.cagedmobs.registers.CagedRecipeTypes;
import com.corgam.cagedmobs.serializers.RecipesHelper;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DnaSamplerItem
extends Item {
    public DnaSamplerItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!CagedMobs.SERVER_CONFIG.areSamplersDisabled()) {
            InteractionHand hand;
            if (target.f_19853_.m_5776_() || !(attacker instanceof Player)) {
                return false;
            }
            Player player = (Player)attacker;
            if (player.m_21205_().equals(stack)) {
                hand = InteractionHand.MAIN_HAND;
            } else if (player.m_21206_().equals(stack)) {
                hand = InteractionHand.OFF_HAND;
            } else {
                return false;
            }
            if (DnaSamplerItem.canBeCached((Entity)target) && !RecipesHelper.isEntityTypeBlacklisted(target.m_6095_())) {
                if (DnaSamplerItem.samplerTierSufficient(stack, (Entity)target)) {
                    CompoundTag nbt = new CompoundTag();
                    SerializationHelper.serializeEntityTypeNBT(nbt, target.m_6095_());
                    if (target instanceof Sheep) {
                        Sheep sheep = (Sheep)target;
                        DyeColor color = sheep.m_29874_();
                        nbt.m_128405_("Color", color.m_41060_());
                    }
                    stack.m_41751_(nbt);
                    player.m_21008_(hand, stack);
                    return true;
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.cagedmobs.dna_sampler.not_sufficient").m_130940_(ChatFormatting.RED), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.cagedmobs.dna_sampler.not_cachable").m_130940_(ChatFormatting.RED), true);
            }
        }
        return false;
    }

    private static boolean samplerTierSufficient(ItemStack stack, Entity target) {
        EntityType type = target.m_6095_();
        boolean sufficient = false;
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ENTITY_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            EntityData entityData;
            if (!(recipe instanceof EntityData) || (entityData = (EntityData)recipe).getEntityType() == null || !entityData.getEntityType().equals((Object)type) || entityData.getSamplerTier() > DnaSamplerItem.getSamplerTierInt(stack.m_41720_())) continue;
            sufficient = true;
            break;
        }
        return sufficient;
    }

    private static int getSamplerTierInt(Item item) {
        if (item instanceof DnaSamplerNetheriteItem) {
            return 3;
        }
        if (item instanceof DnaSamplerDiamondItem) {
            return 2;
        }
        return 1;
    }

    private static boolean canBeCached(Entity clickedEntity) {
        boolean contains = false;
        for (Recipe<?> recipe : RecipesHelper.getRecipes((RecipeType)CagedRecipeTypes.ENTITY_RECIPE.get(), RecipesHelper.getRecipeManager()).values()) {
            EntityData entityData;
            if (!(recipe instanceof EntityData) || (entityData = (EntityData)recipe).getEntityType() == null || !entityData.getEntityType().equals((Object)clickedEntity.m_6095_())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6047_() && itemstack.m_41782_()) {
            this.removeEntityType(itemstack);
            player.m_6674_(hand);
            InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.getTooltip(stack));
        tooltip.add((Component)this.getInformationForTier().m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.cagedmobs.dna_sampler.makeEmpty").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"item.cagedmobs.dna_sampler.getBackEntity").m_130940_(ChatFormatting.GRAY));
        if (CagedMobs.SERVER_CONFIG.areSamplersDisabled()) {
            tooltip.add((Component)Component.m_237115_((String)"item.cagedmobs.dna_sampler.disabled").m_130940_(ChatFormatting.RED));
        }
    }

    private MutableComponent getInformationForTier() {
        if (this instanceof DnaSamplerNetheriteItem) {
            return Component.m_237115_((String)"item.cagedmobs.dna_sampler.tier3Info");
        }
        if (this instanceof DnaSamplerDiamondItem) {
            return Component.m_237115_((String)"item.cagedmobs.dna_sampler.tier2Info");
        }
        return Component.m_237115_((String)"item.cagedmobs.dna_sampler.tier1Info");
    }

    private Component getTooltip(ItemStack stack) {
        if (!DnaSamplerItem.containsEntityType(stack)) {
            return Component.m_237115_((String)"item.cagedmobs.dna_sampler.empty").m_130940_(ChatFormatting.YELLOW);
        }
        EntityType<?> type = SerializationHelper.deserializeEntityTypeNBT(stack.m_41783_());
        if (type != null) {
            return Component.m_237115_((String)type.m_20675_()).m_130940_(ChatFormatting.YELLOW);
        }
        return Component.m_237115_((String)"item.cagedmobs.dna_sampler.unknown_entity").m_130940_(ChatFormatting.YELLOW);
    }

    public static boolean containsEntityType(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("entity");
    }

    public void removeEntityType(ItemStack stack) {
        stack.m_41749_("entity");
        stack.m_41749_("Color");
    }

    public void setEntityTypeFromCage(MobCageBlockEntity cage, ItemStack stack, Player player, InteractionHand hand) {
        EntityType<?> type = cage.getEntityType();
        CompoundTag nbt = new CompoundTag();
        SerializationHelper.serializeEntityTypeNBT(nbt, type);
        if (type.toString().contains("sheep")) {
            nbt.m_128405_("Color", cage.getColor());
        }
        stack.m_41751_(nbt);
        player.m_21008_(hand, stack);
    }

    public EntityType<?> getEntityType(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_() != null) {
            return SerializationHelper.deserializeEntityTypeNBT(stack.m_41783_());
        }
        return null;
    }
}

