/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.entity;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.entity.AdditionalLootData;
import com.corgam.cagedmobs.serializers.entity.EntityDataSerializer;
import com.corgam.cagedmobs.serializers.entity.LootData;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AdditionalLootDataSerializer
implements RecipeSerializer<AdditionalLootData> {
    public AdditionalLootData fromJson(ResourceLocation id, JsonObject json) {
        EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, json);
        List<LootData> results = EntityDataSerializer.deserializeLootData(id, json, entityType);
        boolean removeFromEntity = false;
        if (json.has("removeFromEntity")) {
            removeFromEntity = GsonHelper.m_13912_((JsonObject)json, (String)"removeFromEntity");
        }
        return new AdditionalLootData(id, entityType, results, removeFromEntity);
    }

    public AdditionalLootData fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        try {
            EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, buffer);
            ArrayList<LootData> results = new ArrayList<LootData>();
            int length = buffer.readInt();
            for (int i = 0; i < length; ++i) {
                results.add(LootData.deserializeBuffer(buffer));
            }
            boolean removeFromEntity = buffer.readBoolean();
            return new AdditionalLootData(id, entityType, results, removeFromEntity);
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read additionalLootData with id: " + id.toString() + " from packet buffer.");
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, AdditionalLootData recipe) {
        try {
            SerializationHelper.serializeEntityType(buffer, recipe.getEntityType());
            buffer.writeInt(recipe.getResults().size());
            for (LootData data : recipe.getResults()) {
                LootData.serializeBuffer(buffer, data);
            }
            buffer.writeBoolean(recipe.isRemoveFromEntity());
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write additionalLootData with id: " + recipe.m_6423_().toString() + " to the packet buffer.");
        }
    }
}

