/*
 * Decompiled with CFR 0.152.
 */
package com.corgam.cagedmobs.serializers.entity;

import com.corgam.cagedmobs.CagedMobs;
import com.corgam.cagedmobs.serializers.SerializationHelper;
import com.corgam.cagedmobs.serializers.entity.EntityData;
import com.corgam.cagedmobs.serializers.entity.LootData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class EntityDataSerializer
implements RecipeSerializer<EntityData> {
    public EntityData fromJson(ResourceLocation id, JsonObject json) {
        EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, json);
        Set<String> validEnvs = EntityDataSerializer.deserializeEnvsData(id, json);
        int growTicks = GsonHelper.m_13927_((JsonObject)json, (String)"growTicks");
        boolean requiresWater = false;
        if (json.has("requiresWater")) {
            requiresWater = GsonHelper.m_13912_((JsonObject)json, (String)"requiresWater");
        }
        List<LootData> results = EntityDataSerializer.deserializeLootData(id, json, entityType);
        int samplerTier = GsonHelper.m_13927_((JsonObject)json, (String)"samplerTier");
        if (growTicks <= 0) {
            throw new IllegalArgumentException("MobDataRecipe with id: " + id.toString() + " has an invalid growth tick rate. It must use a positive integer.");
        }
        if (samplerTier < 1 || samplerTier > 3) {
            throw new IllegalArgumentException("MobDataRecipe with id: " + id.toString() + " has an invalid sampler tier. It must use tiers: 1,2 or 3.");
        }
        return new EntityData(id, entityType, validEnvs, growTicks, requiresWater, results, samplerTier);
    }

    public EntityData fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        try {
            EntityType<?> entityType = SerializationHelper.deserializeEntityType(id, buffer);
            HashSet<String> validEnvs = new HashSet<String>();
            SerializationHelper.deserializeStringCollection(buffer, validEnvs);
            int growTicks = buffer.readInt();
            boolean requiresWater = buffer.readBoolean();
            ArrayList<LootData> results = new ArrayList<LootData>();
            int length = buffer.readInt();
            for (int i = 0; i < length; ++i) {
                results.add(LootData.deserializeBuffer(buffer));
            }
            int tier = buffer.readInt();
            return new EntityData(id, entityType, validEnvs, growTicks, requiresWater, results, tier);
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to read mobData with id: " + id.toString() + " from packet buffer.", e);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, EntityData recipe) {
        try {
            SerializationHelper.serializeEntityType(buffer, recipe.getEntityType());
            SerializationHelper.serializeStringCollection(buffer, recipe.getValidEnvs());
            buffer.writeInt(recipe.getTotalGrowTicks());
            buffer.writeBoolean(recipe.ifRequiresWater());
            buffer.writeInt(recipe.getResults().size());
            for (LootData data : recipe.getResults()) {
                LootData.serializeBuffer(buffer, data);
            }
            buffer.writeInt(recipe.getSamplerTier());
        }
        catch (Exception e) {
            CagedMobs.LOGGER.catching((Throwable)e);
            throw new IllegalStateException("Failed to write mobData with id: " + recipe.m_6423_() + " to the packet buffer.", e);
        }
    }

    private static Set<String> deserializeEnvsData(ResourceLocation ownerId, JsonObject json) {
        HashSet<String> categories = new HashSet<String>();
        for (JsonElement elem : json.getAsJsonArray("environments")) {
            categories.add(elem.getAsString().toLowerCase());
        }
        return categories;
    }

    static List<LootData> deserializeLootData(ResourceLocation ownerId, JsonObject json, EntityType<?> entityType) {
        ArrayList<LootData> loots = new ArrayList<LootData>();
        for (JsonElement elem : json.getAsJsonArray("results")) {
            if (!elem.isJsonObject()) continue;
            LootData lootData = LootData.deserialize(elem.getAsJsonObject());
            if (elem.getAsJsonObject().has("nbtName") && elem.getAsJsonObject().has("nbtData")) {
                ItemStack newItem = EntityDataSerializer.writeNBTtoItem(elem.getAsJsonObject().getAsJsonPrimitive("nbtName").getAsString(), elem.getAsJsonObject().getAsJsonPrimitive("nbtData").getAsString(), lootData.getItem());
                lootData.setItem(newItem);
            }
            loots.add(lootData);
        }
        return loots;
    }

    private static ItemStack writeNBTtoItem(String nbtName, String nbtData, ItemStack stack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(nbtName, nbtData);
        stack.m_41751_(nbt);
        return stack;
    }
}

