/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.yeoxuhang.geodeplus.client.model.layer.GeodePlusModelLayersRegistry;
import net.yeoxuhang.geodeplus.common.block.entity.WrappistPedestalBlockEntity;

public class WrappistPedestalBlockEntityRenderer<T extends WrappistPedestalBlockEntity>
implements BlockEntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private static final ResourceLocation TEXTURE = new ResourceLocation("geode_plus", "textures/entity/wrappist_pedestal/wrappist_pedestal.png");
    private static final ResourceLocation XMAS = new ResourceLocation("geode_plus", "textures/entity/wrappist_pedestal/christmas.png");
    private static ModelPart wrappist_pedestal;
    private final ModelPart crystals;
    private final ModelPart crystal1;
    private final ModelPart crystal2;
    private final ModelPart crystal3;
    private final ModelPart crystal4;
    private boolean xmasTextures;

    public WrappistPedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(GeodePlusModelLayersRegistry.WRAPPIST_PEDESTAL);
        wrappist_pedestal = modelpart.m_171324_("wrappist_pedestal");
        this.crystals = wrappist_pedestal.m_171324_("crystals");
        this.crystal1 = this.crystals.m_171324_("crystal1");
        this.crystal2 = this.crystals.m_171324_("crystal2");
        this.crystal3 = this.crystals.m_171324_("crystal3");
        this.crystal4 = this.crystals.m_171324_("crystal4");
        this.itemRenderer = context.m_234447_();
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition wrappist_pedestal = partdefinition.m_171599_("wrappist_pedestal", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition crystals = wrappist_pedestal.m_171599_("crystals", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition crystal1 = crystals.m_171599_("crystal1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)-7.0f));
        crystal1.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -3.0f, 0.0f, 5.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition crystal2 = crystals.m_171599_("crystal2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)0.0f));
        crystal2.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.0f, -2.0f, 0.0f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)-0.2618f));
        PartDefinition crystal3 = crystals.m_171599_("crystal3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)7.0f));
        crystal3.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -3.0f, 0.0f, 5.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition crystal4 = crystals.m_171599_("crystal4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-1.0f, (float)0.0f));
        crystal4.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-2.0f, -2.0f, 0.0f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.2618f));
        wrappist_pedestal.m_171599_("pedestal", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-7.0f, -6.0f, -7.0f, 14.0f, 8.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -12.0f, -7.0f, 14.0f, 6.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T entity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        Level world = entity.m_58904_();
        assert (world != null);
        long gameTime = world.m_46467_();
        float offsetY = (float)Math.sin((float)gameTime / 8.0f) * 0.025f;
        float wrappistBlockEntity = ((WrappistPedestalBlockEntity)((Object)entity)).tick();
        float crystalTick = wrappistBlockEntity / 35.0f;
        float tick = wrappistBlockEntity / 10.0f;
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
        if (this.xmasTextures) {
            wrappist_pedestal.m_104306_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)XMAS)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            wrappist_pedestal.m_104306_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.crystals.m_171327_(0.0f, -crystalTick % 360.0f, 0.0f);
        wrappist_pedestal.m_104227_(8.0f, -2.0f, -8.0f);
        if (entity.m_58898_() && !((WrappistPedestalBlockEntity)((Object)entity)).m_7983_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, (double)offsetY - 1.0, -0.5);
            poseStack.m_85841_(0.35f, 0.35f, 0.35f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(tick % 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            this.itemRenderer.m_269128_(((WrappistPedestalBlockEntity)((Object)entity)).m_8020_(0), ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, poseStack, multiBufferSource, entity.m_58904_(), combinedOverlayIn);
            poseStack.m_85849_();
        }
    }
}

