/*
 * Decompiled with CFR 0.152.
 */
package net.yeoxuhang.geodeplus.forge.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import net.yeoxuhang.geodeplus.platform.forge.RegistryHelperImpl;

public class GeodePlusLangProvider
extends LanguageProvider {
    private static final String NORMAL_CHARS = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = " \u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";
    private final boolean upsideDown;

    public GeodePlusLangProvider(PackOutput packOutput, String locale, boolean upsideDown) {
        super(packOutput, "geode_plus", locale);
        this.upsideDown = upsideDown;
    }

    protected void addTranslations() {
        RegistryHelperImpl.BLOCKS.getEntries().forEach(this::addBlock);
        RegistryHelperImpl.ITEMS.getEntries().stream().filter(item -> !(item.get() instanceof BlockItem)).forEach(this::addItem);
        this.add("itemGroup.geode_plus", "Geode+");
        this.add("itemGroup.geode_plus.tab", "Geode+");
    }

    public void add(String key, String value) {
        if (this.upsideDown) {
            super.add(key, GeodePlusLangProvider.toUpsideDown(value));
        } else {
            super.add(key, value);
        }
    }

    private void addBlock(RegistryObject<Block> block) {
        String key = block.getId().m_135815_();
        super.add("block.geode_plus." + key, this.convertToName(key));
    }

    private void addItem(RegistryObject<Item> item) {
        String key = item.getId().m_135815_();
        super.add("item.geode_plus." + key, this.convertToName(key));
    }

    private String convertToName(String key) {
        StringBuilder builder = new StringBuilder(key.substring(0, 1).toUpperCase() + key.substring(1));
        for (int i = 1; i < builder.length(); ++i) {
            if (builder.charAt(i) != '_') continue;
            builder.deleteCharAt(i);
            builder.replace(i, i + 1, " " + Character.toUpperCase(builder.charAt(i)));
        }
        String name = builder.toString();
        return this.upsideDown ? GeodePlusLangProvider.toUpsideDown(name) : name;
    }

    private static String toUpsideDown(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = name.length() - 1; i >= 0; --i) {
            if (i > 2 && name.substring(i - 3, i + 1).equals("%1$s")) {
                builder.append(name, i - 3, i + 1);
                i -= 4;
                continue;
            }
            char upsideDown = UPSIDE_DOWN_CHARS.charAt(NORMAL_CHARS.indexOf(name.charAt(i)));
            builder.append(upsideDown);
        }
        return builder.toString();
    }
}

