/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.mightymail.blockentity;

import com.mrcrayfish.mightymail.Config;
import com.mrcrayfish.mightymail.block.MailboxBlock;
import com.mrcrayfish.mightymail.blockentity.BasicLootBlockEntity;
import com.mrcrayfish.mightymail.core.ModBlockEntities;
import com.mrcrayfish.mightymail.mail.DeliveryService;
import com.mrcrayfish.mightymail.mail.Mailbox;
import com.mrcrayfish.mightymail.util.Utils;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MailboxBlockEntity
extends BasicLootBlockEntity {
    protected UUID uuid = UUID.randomUUID();
    protected WeakReference<Mailbox> mailboxRef;

    public MailboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MAIL_BOX.get(), pos, state, (Integer)Config.SERVER.mailboxInventoryRows.get() * 9);
    }

    public UUID getId() {
        return this.uuid;
    }

    public boolean deliverItem(ItemStack mail) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) {
                this.m_6836_(i, mail);
                this.setUnchecked();
                return true;
            }
            if (stack.m_41613_() == stack.m_41741_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)mail) || stack.m_41613_() + mail.m_41613_() > stack.m_41741_()) continue;
            stack.m_41769_(mail.m_41613_());
            this.m_6596_();
            this.setUnchecked();
            return true;
        }
        return false;
    }

    public void setUnchecked() {
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)MailboxBlock.ENABLED, (Comparable)Boolean.valueOf(true)), 3);
    }

    public Mailbox getMailbox() {
        ServerLevel serverLevel;
        Optional<DeliveryService> optional;
        Level level;
        if (this.mailboxRef != null) {
            Mailbox mailbox = (Mailbox)this.mailboxRef.get();
            if (mailbox != null && !mailbox.removed().booleanValue()) {
                return mailbox;
            }
            this.mailboxRef = null;
        }
        if ((level = this.f_58857_) instanceof ServerLevel && (optional = DeliveryService.get((serverLevel = (ServerLevel)level).m_7654_())).isPresent()) {
            DeliveryService service = optional.get();
            Mailbox mailbox = service.getOrCreateMailBox(this);
            this.mailboxRef = new WeakReference<Mailbox>(mailbox);
            return mailbox;
        }
        return null;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "mailbox", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        int rows = this.m_6643_() / 9;
        return new ChestMenu(this.getChestMenu(rows), windowId, playerInventory, (Container)this, rows);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        ChestMenu chestMenu;
        return menu instanceof ChestMenu && (chestMenu = (ChestMenu)menu).m_39261_() == this;
    }

    public MenuType<ChestMenu> getChestMenu(int rows) {
        return switch (rows) {
            case 1 -> MenuType.f_39957_;
            case 2 -> MenuType.f_39958_;
            case 3 -> MenuType.f_39959_;
            case 4 -> MenuType.f_39960_;
            case 5 -> MenuType.f_39961_;
            case 6 -> MenuType.f_39962_;
            default -> throw new IllegalArgumentException("Rows can only be a minimum of one and a maximum of six");
        };
    }

    public Component m_5446_() {
        String customName;
        Mailbox mailbox = this.getMailbox();
        if (mailbox != null && (customName = (String)mailbox.customName().getValue()) != null && !customName.isBlank()) {
            return Component.m_237113_((String)customName);
        }
        return super.m_5446_();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("UUID", 11)) {
            this.uuid = tag.m_128342_("UUID");
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("UUID", this.uuid);
    }
}

