/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.highlights.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.highlights.base.HighlightLine;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public record Highlight(ResourceLocation id, List<HighlightLine> lines) {
    public static Highlight of(ResourceLocation id, List<HighlightLine> lines) {
        return new Highlight(id, Collections.unmodifiableList(lines));
    }

    public static Codec<Highlight> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)HighlightLine.CODEC.listOf().fieldOf("lines").forGetter(Highlight::lines)).apply((Applicative)instance, Highlight::of));
    }

    public Highlight copy() {
        return new Highlight(null, this.lines.stream().map(HighlightLine::copy).toList());
    }

    public void render(VertexConsumer consumer, PoseStack poseStack, Vec3 cameraPos, BlockPos blockPos) {
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            float x = (float)((double)blockPos.m_123341_() - cameraPos.m_7096_());
            float y = (float)((double)blockPos.m_123342_() - cameraPos.m_7098_());
            float z = (float)((double)blockPos.m_123343_() - cameraPos.m_7094_());
            for (HighlightLine line : this.lines) {
                line.render(poseStack, consumer, x, y, z);
            }
        }
    }
}

