/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.item.tabs;

import com.teamresourceful.resourcefullib.common.item.tabs.forge.ResourcefulCreativeTabImpl;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ResourcefulCreativeTab {
    public final ResourceLocation id;
    public Supplier<ItemStack> icon;
    public boolean hideScrollBar;
    public boolean hideTitle;
    public final List<ResourcefulRegistry<ItemLike>> registries = new ArrayList<ResourcefulRegistry<ItemLike>>();
    public final List<Supplier<ItemStack>> stacks = new ArrayList<Supplier<ItemStack>>();

    public ResourcefulCreativeTab(ResourceLocation id) {
        this.id = id;
    }

    public ResourcefulCreativeTab setItemIcon(Supplier<? extends ItemLike> icon) {
        return this.setStackIcon(() -> new ItemStack((ItemLike)icon.get()));
    }

    public ResourcefulCreativeTab setStackIcon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    public ResourcefulCreativeTab hideTitle() {
        this.hideTitle = true;
        return this;
    }

    public ResourcefulCreativeTab hideScrollBar() {
        this.hideScrollBar = true;
        return this;
    }

    public <I extends ItemLike, T extends ResourcefulRegistry<I>> ResourcefulCreativeTab addRegistry(T registry) {
        this.registries.add(registry);
        return this;
    }

    public ResourcefulCreativeTab addStack(Supplier<ItemStack> stack) {
        this.stacks.add(stack);
        return this;
    }

    public ResourcefulCreativeTab addStack(ItemStack stack) {
        this.stacks.add(() -> stack);
        return this;
    }

    public ResourcefulCreativeTab addStack(ItemLike item) {
        this.stacks.add(() -> new ItemStack(item));
        return this;
    }

    public Supplier<CreativeModeTab> build() {
        return ResourcefulCreativeTab.create(this);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Supplier<CreativeModeTab> create(ResourcefulCreativeTab tab) {
        return ResourcefulCreativeTabImpl.create(tab);
    }
}

