/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.networking;

import com.teamresourceful.resourcefullib.common.networking.PacketChannelHelper;
import com.teamresourceful.resourcefullib.common.networking.base.NetworkDirection;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;

public class NetworkChannel {
    private final ResourceLocation channel;

    public NetworkChannel(String modid, int protocolVersion, String channel) {
        this.channel = new ResourceLocation(modid, channel);
        PacketChannelHelper.registerChannel(this.channel, protocolVersion);
    }

    public final <T extends Packet<T>> void registerPacket(NetworkDirection direction, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        if (direction == NetworkDirection.CLIENT_TO_SERVER) {
            PacketChannelHelper.registerC2SPacket(this.channel, id, handler, packetClass);
        } else {
            PacketChannelHelper.registerS2CPacket(this.channel, id, handler, packetClass);
        }
    }

    public final <T extends Packet<T>> void sendToServer(T packet) {
        PacketChannelHelper.sendToServer(this.channel, packet);
    }

    public final <T extends Packet<T>> void sendToPlayer(T packet, Player player) {
        PacketChannelHelper.sendToPlayer(this.channel, packet, player);
    }

    public final <T extends Packet<T>> void sendToPlayers(T packet, Collection<? extends Player> players) {
        players.forEach(player -> this.sendToPlayer(packet, (Player)player));
    }

    public final <T extends Packet<T>> void sendToAllPlayers(T packet, MinecraftServer server) {
        this.sendToPlayers(packet, server.m_6846_().m_11314_());
    }

    public final <T extends Packet<T>> void sendToPlayersInLevel(T packet, Level level) {
        this.sendToPlayers(packet, level.m_6907_());
    }

    public final <T extends Packet<T>> void sendToAllLoaded(T packet, Level level, BlockPos pos) {
        ChunkSource chunkSource;
        LevelChunk chunk = level.m_46745_(pos);
        if (chunk != null && (chunkSource = level.m_7726_()) instanceof ServerChunkCache) {
            ServerChunkCache serverCache = (ServerChunkCache)chunkSource;
            serverCache.f_8325_.m_183262_(chunk.m_7697_(), false).forEach(player -> this.sendToPlayer(packet, (Player)player));
        }
    }

    public final <T extends Packet<T>> void sendToPlayersInRange(T packet, Level level, BlockPos pos, double range) {
        for (Player player : level.m_6907_()) {
            if (!(player.m_20183_().m_123331_((Vec3i)pos) <= range)) continue;
            this.sendToPlayer(packet, player);
        }
    }
}

