/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.armorposer.client.gui.widgets.NumberFieldWidget;
import com.mrbysco.armorposer.client.gui.widgets.ToggleButton;
import com.mrbysco.armorposer.platform.Services;
import com.mrbysco.armorposer.util.ArmorStandData;
import java.util.Objects;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorStandScreen
extends Screen {
    private final ArmorStand entityArmorStand;
    private final ArmorStandData armorStandData;
    private final String[] buttonLabels = new String[]{"invisible", "no_base_plate", "no_gravity", "show_arms", "small", "rotation"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm"};
    private NumberFieldWidget rotationTextField;
    private final ToggleButton[] toggleButtons = new ToggleButton[5];
    private final NumberFieldWidget[] poseTextFields = new NumberFieldWidget[18];
    private final boolean allowScrolling;

    public ArmorStandScreen(ArmorStand entityArmorStand) {
        super(GameNarrator.f_93310_);
        int i;
        this.entityArmorStand = entityArmorStand;
        this.armorStandData = new ArmorStandData();
        this.armorStandData.readFromNBT(entityArmorStand.m_20240_(new CompoundTag()));
        this.allowScrolling = Services.PLATFORM.allowScrolling();
        for (i = 0; i < this.buttonLabels.length; ++i) {
            this.buttonLabels[i] = I18n.m_118938_((String)("armorposer.gui.label." + this.buttonLabels[i]), (Object[])new Object[0]);
        }
        for (i = 0; i < this.sliderLabels.length; ++i) {
            this.sliderLabels[i] = I18n.m_118938_((String)("armorposer.gui.label." + this.sliderLabels[i]), (Object[])new Object[0]);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        int i;
        super.m_7856_();
        int offsetX = 110;
        int offsetY = 50;
        for (i = 0; i < this.toggleButtons.length; ++i) {
            int x = offsetX;
            int y = offsetY + i * 22;
            int width = 40;
            int height = 20;
            this.toggleButtons[i] = new ToggleButton.Builder(this.armorStandData.getBooleanValue(i), button -> {
                ToggleButton toggleButton;
                toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
                this.textFieldUpdated();
            }).bounds(x, y, width, height).build();
            this.m_142416_((GuiEventListener)this.toggleButtons[i]);
        }
        this.rotationTextField = new NumberFieldWidget(this.f_96547_, 1 + offsetX, 1 + offsetY + this.toggleButtons.length * 22, 38, 17, (Component)Component.m_237115_((String)"field.rotation"));
        this.rotationTextField.m_94144_(String.valueOf((int)this.armorStandData.rotation));
        this.rotationTextField.m_94199_(4);
        this.m_7787_((GuiEventListener)this.rotationTextField);
        offsetX = this.f_96543_ - 20 - 100;
        for (i = 0; i < this.poseTextFields.length; ++i) {
            int id = 5 + i;
            int x = 1 + offsetX + i % 3 * 35;
            int y = 1 + offsetY + i / 3 * 22;
            int width = 28;
            int height = 17;
            String value = String.valueOf((int)this.armorStandData.pose[i]);
            this.poseTextFields[i] = new NumberFieldWidget(this.f_96547_, x, y, width, height, (Component)Component.m_237110_((String)"field.%s", (Object[])new Object[]{i}));
            this.poseTextFields[i].m_94144_(value);
            this.poseTextFields[i].m_94199_(4);
            this.m_7787_((GuiEventListener)this.poseTextFields[i]);
        }
        offsetY = this.f_96544_ / 4 + 120 + 12;
        offsetX = 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"armorposer.gui.label.copy"), button -> {
            CompoundTag compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.f_96541_ != null) {
                this.f_96541_.f_91068_.m_90911_(clipboardData);
            }
        }).m_252987_(offsetX, offsetY, 64, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"armorposer.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.f_96541_ != null) {
                    clipboardData = this.f_96541_.f_91068_.m_90876_();
                }
                CompoundTag compound = TagParser.m_129359_(clipboardData);
                this.readFieldsFromNBT(compound);
                this.updateEntity(this.entityArmorStand, compound);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).m_252987_(offsetX + 66, offsetY, 64, 20).m_253136_());
        offsetX = this.f_96543_ - 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            this.updateEntity(this.entityArmorStand, this.writeFieldsToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }).m_252987_(offsetX - 194, offsetY, 96, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> {
            this.updateEntity(this.entityArmorStand, this.armorStandData.writeToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }).m_252987_(offsetX - 96, offsetY, 96, 20).m_253136_());
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int y;
        int i;
        this.m_7333_(matrixStack);
        ArmorStandScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"armorposer.gui.title"), (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        this.rotationTextField.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        for (NumberFieldWidget textField : this.poseTextFields) {
            textField.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        }
        int offsetY = 50;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.f_96547_);
            y = offsetY + i * 22 + (10 - 9 / 2);
            ArmorStandScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.buttonLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        offsetX = this.f_96543_ - 20 - 100;
        ArmorStandScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"X", (int)offsetX, (int)37, (int)0xA0A0A0);
        ArmorStandScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Y", (int)(offsetX + 35), (int)37, (int)0xA0A0A0);
        ArmorStandScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)"Z", (int)(offsetX + 70), (int)37, (int)0xA0A0A0);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            int x = offsetX - this.f_96547_.m_92895_(this.sliderLabels[i]) - 10;
            Objects.requireNonNull(this.f_96547_);
            y = offsetY + i * 22 + (10 - 9 / 2);
            ArmorStandScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.sliderLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        super.m_86600_();
        this.rotationTextField.m_94120_();
        for (NumberFieldWidget textField : this.poseTextFields) {
            textField.m_94120_();
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean typed = super.m_5534_(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        block5: {
            block4: {
                if (!this.allowScrolling || !(delta > 0.0)) break block4;
                if (this.rotationTextField.m_93696_()) {
                    int nextValue = (int)(this.rotationTextField.getFloat() + 1.0f);
                    this.rotationTextField.m_94144_(String.valueOf(nextValue));
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldWidget textField : this.poseTextFields) {
                    if (!textField.m_198029_()) continue;
                    int nextValue = (int)(textField.getFloat() + 1.0f);
                    textField.m_94144_(String.valueOf(nextValue));
                    this.textFieldUpdated();
                    return true;
                }
                break block5;
            }
            if (!this.allowScrolling || !(delta < 0.0)) break block5;
            if (this.rotationTextField.m_93696_()) {
                int previousValue = (int)(this.rotationTextField.getFloat() - 1.0f);
                this.rotationTextField.m_94144_(String.valueOf(previousValue));
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldWidget textField : this.poseTextFields) {
                if (!textField.m_198029_()) continue;
                int previousValue = (int)(textField.getFloat() - 1.0f);
                textField.m_94144_(String.valueOf(previousValue));
                this.textFieldUpdated();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].m_93696_()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].m_94201_();
                this.poseTextFields[i].m_93692_(false);
                int j = !Screen.m_96638_() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].m_93692_(true);
                this.poseTextFields[j].m_94192_(0);
                this.poseTextFields[j].m_94208_(this.poseTextFields[j].m_94155_().length());
            }
        } else {
            if (this.rotationTextField.m_7933_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldWidget textField : this.poseTextFields) {
                if (!textField.m_7933_(keyCode, scanCode, modifiers)) continue;
                this.textFieldUpdated();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.rotationTextField.m_6375_(mouseX, mouseY, button);
        for (NumberFieldWidget textField : this.poseTextFields) {
            textField.m_6375_(mouseX, mouseY, button);
            this.textFieldUpdated();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.entityArmorStand, this.writeFieldsToNBT());
    }

    private CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Invisible", this.toggleButtons[0].getValue());
        compound.m_128379_("NoBasePlate", this.toggleButtons[1].getValue());
        compound.m_128379_("NoGravity", this.toggleButtons[2].getValue());
        compound.m_128379_("ShowArms", this.toggleButtons[3].getValue());
        compound.m_128379_("Small", this.toggleButtons[4].getValue());
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.rotationTextField.getFloat()).floatValue()));
        compound.m_128365_("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[0].getFloat()).floatValue()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[1].getFloat()).floatValue()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[2].getFloat()).floatValue()));
        poseTag.m_128365_("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[3].getFloat()).floatValue()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[4].getFloat()).floatValue()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[5].getFloat()).floatValue()));
        poseTag.m_128365_("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[6].getFloat()).floatValue()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[7].getFloat()).floatValue()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[8].getFloat()).floatValue()));
        poseTag.m_128365_("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[9].getFloat()).floatValue()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[10].getFloat()).floatValue()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[11].getFloat()).floatValue()));
        poseTag.m_128365_("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[12].getFloat()).floatValue()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[13].getFloat()).floatValue()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[14].getFloat()).floatValue()));
        poseTag.m_128365_("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[15].getFloat()).floatValue()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[16].getFloat()).floatValue()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)Float.valueOf(this.poseTextFields[17].getFloat()).floatValue()));
        poseTag.m_128365_("RightArm", (Tag)poseRightArmTag);
        compound.m_128365_("Pose", (Tag)poseTag);
        return compound;
    }

    private void readFieldsFromNBT(CompoundTag compound) {
        int i;
        ArmorStandData armorStandData = new ArmorStandData();
        armorStandData.readFromNBT(compound);
        for (i = 0; i < this.toggleButtons.length; ++i) {
            this.toggleButtons[i].setValue(armorStandData.getBooleanValue(i));
        }
        this.rotationTextField.m_94144_(String.valueOf((int)armorStandData.rotation));
        for (i = 0; i < this.poseTextFields.length; ++i) {
            this.poseTextFields[i].m_94144_(String.valueOf((int)armorStandData.pose[i]));
        }
    }

    public static void openScreen(ArmorStand armorStandEntity) {
        Minecraft.m_91087_().m_91152_((Screen)new ArmorStandScreen(armorStandEntity));
    }

    public void updateEntity(ArmorStand armorStand, CompoundTag compound) {
        Services.PLATFORM.updateEntity(armorStand, compound);
    }
}

