/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.packets;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraftforge.network.NetworkEvent;

public class ArmorStandSyncMessage {
    private final UUID entityUUID;
    private final CompoundTag data;

    public ArmorStandSyncMessage(UUID playerUUID, CompoundTag tag) {
        this.entityUUID = playerUUID;
        this.data = tag;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.m_130079_(this.data);
    }

    public static ArmorStandSyncMessage decode(FriendlyByteBuf packetBuffer) {
        return new ArmorStandSyncMessage(packetBuffer.m_130259_(), packetBuffer.m_130260_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerLevel world;
            Entity entity;
            if (ctx.getDirection().getReceptionSide().isServer() && ctx.getSender() != null && (entity = (world = ctx.getSender().m_9236_()).m_8791_(this.entityUUID)) instanceof ArmorStand) {
                ArmorStand armorStandEntity = (ArmorStand)entity;
                CompoundTag entityTag = armorStandEntity.m_20240_(new CompoundTag());
                CompoundTag entityTagCopy = entityTag.m_6426_();
                if (!this.data.m_128456_()) {
                    entityTagCopy.m_128391_(this.data);
                    UUID uuid = armorStandEntity.m_20148_();
                    armorStandEntity.m_20258_(entityTagCopy);
                    armorStandEntity.m_20084_(uuid);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

