/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class Eye
extends FlyingMob
implements Enemy {
    Vec3 moveTargetPoint = Vec3.f_82478_;
    BlockPos anchorPoint = BlockPos.f_121853_;
    AttackPhase attackPhase = AttackPhase.CIRCLE;
    @Nullable
    Mob owner;
    private boolean hasLimitedLife;
    private int limitedLifeTicks;

    public Eye(EntityType<? extends Eye> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.f_21364_ = 5;
        this.f_21342_ = new EyeMoveControl((Mob)this);
        this.f_21365_ = new EyeLookControl((Mob)this);
    }

    @Nullable
    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob p_33995_) {
        this.owner = p_33995_;
    }

    public void setLimitedLife(int p_33988_) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = p_33988_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 0.2).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 30.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EyeAttackStrategyGoal());
        this.f_21345_.m_25352_(2, (Goal)new EyeSweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new EyeCircleAroundAnchorGoal());
        this.f_21346_.m_25352_(1, (Goal)new EyeAttackPlayerTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new CopyOwnerTargetGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected BodyRotationControl m_7560_() {
        return new EyeBodyRotationControl((Mob)this);
    }

    protected boolean m_8028_() {
        return true;
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_33126_, DifficultyInstance p_33127_, MobSpawnType p_33128_, @Nullable SpawnGroupData p_33129_, @Nullable CompoundTag p_33130_) {
        this.anchorPoint = this.m_20183_().m_6630_(5);
        return super.m_6518_(p_33126_, p_33127_, p_33128_, p_33129_, p_33130_);
    }

    public void m_7378_(CompoundTag p_33132_) {
        super.m_7378_(p_33132_);
        if (p_33132_.m_128441_("AX")) {
            this.anchorPoint = new BlockPos(p_33132_.m_128451_("AX"), p_33132_.m_128451_("AY"), p_33132_.m_128451_("AZ"));
        }
    }

    public void m_7380_(CompoundTag p_33141_) {
        super.m_7380_(p_33141_);
        p_33141_.m_128405_("AX", this.anchorPoint.m_123341_());
        p_33141_.m_128405_("AY", this.anchorPoint.m_123342_());
        p_33141_.m_128405_("AZ", this.anchorPoint.m_123343_());
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6549_(EntityType<?> p_33111_) {
        return true;
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class EyeMoveControl
    extends MoveControl {
        private float speed;

        public EyeMoveControl(Mob p_33241_) {
            super(p_33241_);
            this.speed = 0.1f;
        }

        public void m_8126_() {
            if (Eye.this.f_19862_) {
                Eye.this.m_146922_(Eye.this.m_146908_() + 180.0f);
                this.speed = 0.1f;
            }
            double d0 = Eye.this.moveTargetPoint.f_82479_ - Eye.this.m_20185_();
            double d1 = Eye.this.moveTargetPoint.f_82480_ - Eye.this.m_20186_();
            double d2 = Eye.this.moveTargetPoint.f_82481_ - Eye.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = Eye.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(Eye.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                Eye.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                Eye.this.f_20883_ = Eye.this.m_146908_();
                this.speed = Mth.m_14145_((float)f, (float)Eye.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : Mth.m_14121_((float)this.speed, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                Eye.this.m_146926_(f4);
                float f5 = Eye.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speed * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speed * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speed * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = Eye.this.m_20184_();
                Eye.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class EyeLookControl
    extends LookControl {
        public EyeLookControl(Mob p_33235_) {
            super(p_33235_);
        }

        public void m_8128_() {
        }
    }

    class EyeAttackStrategyGoal
    extends Goal {
        private int nextSweepTick;

        EyeAttackStrategyGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = Eye.this.m_5448_();
            return livingentity != null ? Eye.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            Eye.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            Eye.this.anchorPoint = Eye.this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, Eye.this.anchorPoint).m_6630_(10 + Eye.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (Eye.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    Eye.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + Eye.this.f_19796_.m_188503_(4)) * 20);
                }
            }
        }

        private void setAnchorAboveTarget() {
            Eye.this.anchorPoint = Eye.this.m_5448_().m_20183_().m_6630_(20 + Eye.this.f_19796_.m_188503_(20));
            if (Eye.this.anchorPoint.m_123342_() < Eye.this.f_19853_.m_5736_()) {
                Eye.this.anchorPoint = new BlockPos(Eye.this.anchorPoint.m_123341_(), Eye.this.f_19853_.m_5736_() + 1, Eye.this.anchorPoint.m_123343_());
            }
        }
    }

    class EyeSweepAttackGoal
    extends EyeMoveTargetGoal {
        private boolean isScaredOfCat;
        private int catSearchTick;

        EyeSweepAttackGoal() {
        }

        public boolean m_8036_() {
            return Eye.this.m_5448_() != null && Eye.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Eye.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (livingentity instanceof Player) {
                Player player = (Player)livingentity;
                if (livingentity.m_5833_() || player.m_7500_()) {
                    return false;
                }
            }
            if (!this.m_8036_()) {
                return false;
            }
            if (Eye.this.f_19797_ > this.catSearchTick) {
                this.catSearchTick = Eye.this.f_19797_ + 20;
                List list = Eye.this.f_19853_.m_6443_(Cat.class, Eye.this.m_20191_().m_82400_(16.0), EntitySelector.f_20402_);
                for (Cat cat : list) {
                    cat.m_28167_();
                }
                this.isScaredOfCat = !list.isEmpty();
            }
            return !this.isScaredOfCat;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            Eye.this.m_6710_(null);
            Eye.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = Eye.this.m_5448_();
            if (livingentity != null) {
                Eye.this.moveTargetPoint = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
                if (Eye.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                    Eye.this.m_7327_((Entity)livingentity);
                    Eye.this.attackPhase = AttackPhase.CIRCLE;
                    if (!Eye.this.m_20067_()) {
                        Eye.this.f_19853_.m_46796_(1039, Eye.this.m_20183_(), 0);
                    }
                } else if (Eye.this.f_19862_ || Eye.this.f_20916_ > 0) {
                    Eye.this.attackPhase = AttackPhase.CIRCLE;
                }
            }
        }
    }

    class EyeCircleAroundAnchorGoal
    extends EyeMoveTargetGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        EyeCircleAroundAnchorGoal() {
        }

        public boolean m_8036_() {
            return Eye.this.m_5448_() == null || Eye.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + Eye.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + Eye.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = Eye.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (Eye.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + Eye.this.f_19796_.m_188501_() * 9.0f;
            }
            if (Eye.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (Eye.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = Eye.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (Eye.this.moveTargetPoint.f_82480_ < Eye.this.m_20186_() && !Eye.this.f_19853_.m_46859_(Eye.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (Eye.this.moveTargetPoint.f_82480_ > Eye.this.m_20186_() && !Eye.this.f_19853_.m_46859_(Eye.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)Eye.this.anchorPoint)) {
                Eye.this.anchorPoint = Eye.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            Eye.this.moveTargetPoint = Vec3.m_82528_((Vec3i)Eye.this.anchorPoint).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class EyeAttackPlayerTargetGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int nextScanTick = EyeAttackPlayerTargetGoal.m_186073_((int)20);

        EyeAttackPlayerTargetGoal() {
        }

        public boolean m_8036_() {
            if (this.nextScanTick > 0) {
                --this.nextScanTick;
                return false;
            }
            this.nextScanTick = EyeAttackPlayerTargetGoal.m_186073_((int)60);
            List list = Eye.this.f_19853_.m_45955_(this.attackTargeting, (LivingEntity)Eye.this, Eye.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!Eye.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_)) continue;
                    Eye.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = Eye.this.m_5448_();
            return livingentity != null ? Eye.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(Mob p_34056_) {
            super(p_34056_, false);
            this.copyOwnerTargeting = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return Eye.this.owner != null && Eye.this.owner.m_5448_() != null && this.m_26150_(Eye.this.owner.m_5448_(), this.copyOwnerTargeting);
        }

        public void m_8056_() {
            Eye.this.m_6710_(Eye.this.owner.m_5448_());
            super.m_8056_();
        }
    }

    class EyeBodyRotationControl
    extends BodyRotationControl {
        public EyeBodyRotationControl(Mob p_33216_) {
            super(p_33216_);
        }

        public void m_8121_() {
            Eye.this.f_20885_ = Eye.this.f_20883_;
            Eye.this.f_20883_ = Eye.this.m_146908_();
        }
    }

    abstract class EyeMoveTargetGoal
    extends Goal {
        public EyeMoveTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return Eye.this.moveTargetPoint.m_82531_(Eye.this.m_20185_(), Eye.this.m_20186_(), Eye.this.m_20189_()) < 4.0;
        }
    }
}

