/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity;

import com.nitespring.monsterplus.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class GlowSkeleton
extends AbstractSkeleton {
    private static final EntityDataAccessor<Integer> DATA_BRIGHT_TICKS_REMAINING = SynchedEntityData.m_135353_(GlowSquid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GlowSkeleton(EntityType<? extends GlowSkeleton> p_33570_, Level p_33571_) {
        super(p_33570_, p_33571_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BRIGHT_TICKS_REMAINING, (Object)0);
    }

    public void m_8107_() {
        super.m_8107_();
        int i = this.getBrightTicksRemaining();
        if (i > 0) {
            this.setBrightTicks(i - 1);
        }
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
    }

    public boolean m_6469_(DamageSource p_147114_, float p_147115_) {
        boolean flag = super.m_6469_(p_147114_, p_147115_);
        if (flag) {
            this.setBrightTicks(100);
        }
        return flag;
    }

    private void setBrightTicks(int p_147120_) {
        this.f_19804_.m_135381_(DATA_BRIGHT_TICKS_REMAINING, (Object)p_147120_);
    }

    public int getBrightTicksRemaining() {
        return (Integer)this.f_19804_.m_135370_(DATA_BRIGHT_TICKS_REMAINING);
    }

    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
        boolean r = this.m_217043_().m_188499_();
        if (r) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        } else {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        }
    }

    public static boolean checkGlowSkeletonSpawnRules(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos blockPos, RandomSource p_219018_) {
        return p_219015_.m_46791_() != Difficulty.PEACEFUL && GlowSkeleton.m_219009_((ServerLevelAccessor)p_219015_, (BlockPos)blockPos, (RandomSource)p_219018_) && GlowSkeleton.m_217057_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)blockPos, (RandomSource)p_219018_) && blockPos.m_123342_() <= 40 && (Boolean)CommonConfig.spawn_glow_skeleton.get() != false;
    }

    protected AbstractArrow m_7932_(ItemStack p_33846_, float p_33847_) {
        AbstractArrow abstractarrow = super.m_7932_(p_33846_, p_33847_);
        if (abstractarrow instanceof Arrow) {
            ((Arrow)abstractarrow).m_36870_(new MobEffectInstance(MobEffects.f_19619_, 600));
        }
        return abstractarrow;
    }

    public boolean m_7327_(Entity p_34169_) {
        if (!super.m_7327_(p_34169_)) {
            return false;
        }
        if (p_34169_ instanceof LivingEntity) {
            ((LivingEntity)p_34169_).m_147207_(new MobEffectInstance(MobEffects.f_19619_, 600), (Entity)this);
        }
        return true;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.7).m_22268_(Attributes.f_22277_, 30.0);
    }

    public boolean m_142079_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource p_33579_) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7878_() {
        return SoundEvents.f_12383_;
    }
}

