/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity;

import com.nitespring.monsterplus.common.entity.LavaSquid;
import com.nitespring.monsterplus.config.CommonConfig;
import com.nitespring.monsterplus.core.init.EntityInit;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MotherLavaSquid
extends LavaSquid {
    int birthTick = 0;

    public MotherLavaSquid(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 100.0);
    }

    public static boolean checkMotherLavaSquidSpawnRules(EntityType<MotherLavaSquid> p_218985_, LevelAccessor p_218986_, MobSpawnType p_218987_, BlockPos p_218988_, RandomSource p_218989_) {
        return p_218986_.m_46791_() != Difficulty.PEACEFUL && MotherLavaSquid.m_217057_(p_218985_, (LevelAccessor)p_218986_, (MobSpawnType)p_218987_, (BlockPos)p_218988_, (RandomSource)p_218989_) && (Boolean)CommonConfig.spawn_mother_lava_squid.get() != false;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MotherLavaSquidAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LavaSquid.SquidRandomMovementGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]).m_26044_(new Class[]{LavaSquid.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, true));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        ++this.birthTick;
        if (this.birthTick >= 400) {
            this.birthTick = 0;
            LavaSquid son = new LavaSquid((EntityType<? extends Monster>)((EntityType)EntityInit.LAVA_SQUID.get()), this.m_9236_());
            son.m_146884_(this.m_20182_());
            this.m_9236_().m_7967_((Entity)son);
        }
    }

    static class MotherLavaSquidAttackGoal
    extends Goal {
        private final LavaSquid mob;
        private int attackStep;
        private int attackTime;
        private int lastSeen;
        private Class<?>[] toIgnoreAlert;
        private int alertOthersTick;

        public MotherLavaSquidAttackGoal(LavaSquid p_32247_) {
            this.mob = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.mob.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
            this.alertOthers();
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.mob.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.mob.m_7327_((Entity)livingentity);
                    }
                    this.mob.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.mob.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.mob.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.mob.m_20189_();
                    if (this.attackTime <= 0) {
                        Random rand = new Random();
                        int rng = rand.nextInt(10) + 1;
                        if (rng >= 8 && this.attackStep == 1) {
                            LargeFireball smallfireball = new LargeFireball(this.mob.f_19853_, (LivingEntity)this.mob, d1 / d0, d2 / d0, d3 / d0, 2);
                            smallfireball.m_6034_(this.mob.m_20185_() + 3.0 * d1 / d0, this.mob.m_20227_(0.5) + 3.0 * d2 / d0, this.mob.m_20189_() + 3.0 * d3 / d0);
                            this.mob.f_19853_.m_7967_((Entity)smallfireball);
                            this.attackTime = 60;
                        } else {
                            ++this.attackStep;
                            if (this.attackStep == 1) {
                                this.attackTime = 60;
                            } else if (this.attackStep <= 13) {
                                this.attackTime = 6;
                            } else {
                                this.attackTime = 100;
                                this.attackStep = 0;
                            }
                        }
                        if (this.attackStep > 1) {
                            if (!this.mob.m_20067_()) {
                                this.mob.f_19853_.m_5898_((Player)null, 1018, this.mob.m_20183_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                double x = this.mob.m_20185_() + 50.0 * Math.sqrt(d2 * d2 + d3 * d3) / d0 * Math.cos((double)(this.attackStep - 1) * Math.PI / 6.0);
                                double y = this.mob.m_20227_(0.5) + 50.0 * Math.sqrt(d1 * d1 + d3 * d3) / d0 * Math.sin((double)(this.attackStep - 1) * Math.PI / 6.0);
                                double z = this.mob.m_20189_() + 50.0 * Math.sqrt(d2 * d2 + d1 * d1) / d0 * Math.cos((double)(this.attackStep - 1) * Math.PI / 6.0);
                                double d = Math.sqrt((livingentity.m_20185_() - x) * (livingentity.m_20185_() - x) + (livingentity.m_20227_(0.5) - y) * (livingentity.m_20227_(0.5) - y) + (livingentity.m_20189_() - z) * (livingentity.m_20189_() - z));
                                SmallFireball smallfireball = new SmallFireball(this.mob.f_19853_, (LivingEntity)this.mob, (livingentity.m_20185_() - x) / d, (livingentity.m_20227_(0.5) - y) / d, (livingentity.m_20189_() - z) / d);
                                smallfireball.m_6034_(x, y, z);
                                this.mob.f_19853_.m_7967_((Entity)smallfireball);
                            }
                        }
                    }
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.mob.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
            ++this.alertOthersTick;
            if (this.alertOthersTick >= 600) {
                this.alertOthers();
            }
        }

        protected void alertOthers() {
            double d0 = this.getFollowDistance();
            AABB aabb = AABB.m_82333_((Vec3)this.mob.m_20182_()).m_82377_(d0, 10.0, d0);
            List list = this.mob.f_19853_.m_6443_(LavaSquid.class, aabb, EntitySelector.f_20408_);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Mob mob = (Mob)iterator.next();
                if (this.mob == mob || mob.m_5448_() != null) continue;
                if (this.toIgnoreAlert != null) {
                    boolean flag = false;
                    for (Class<?> oclass : this.toIgnoreAlert) {
                        if (mob.getClass() != oclass) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                }
                this.alertOther(mob, this.mob.m_21188_());
            }
            return;
        }

        protected void alertOther(Mob p_26042_, LivingEntity p_26043_) {
            p_26042_.m_6710_(p_26043_);
        }

        private double getFollowDistance() {
            return this.mob.m_21133_(Attributes.f_22277_);
        }
    }
}

