/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.monsterplus.common.entity.projectiles;

import com.nitespring.monsterplus.common.entity.projectiles.CrystalSpikes;
import com.nitespring.monsterplus.core.init.EntityInit;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SpikeCountdown
extends Entity {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private int lifeTicks = 40;
    private float damage;
    private int warmupDelayTicks;
    private boolean sentSpike = false;

    public SpikeCountdown(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    public SpikeCountdown(Level worldIn, float damageIn, double posX, double posY, double posZ, float p_36930_, int warmUpDelayTicks, LivingEntity ownerIn, int tickDelayIn) {
        this((EntityType)EntityInit.SPIKE_COUNTDOWN.get(), worldIn);
        this.warmupDelayTicks = warmUpDelayTicks;
        this.setOwner(ownerIn);
        this.m_146922_(p_36930_ * 57.295776f);
        this.m_6034_(posX, posY, posZ);
        this.damage = damageIn;
        this.lifeTicks = tickDelayIn;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag p_20052_) {
        this.warmupDelayTicks = p_20052_.m_128451_("Warmup");
        if (p_20052_.m_128403_("Owner")) {
            this.ownerUUID = p_20052_.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag p_20139_) {
        p_20139_.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            p_20139_.m_128362_("Owner", this.ownerUUID);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setOwner(@Nullable LivingEntity p_36939_) {
        this.owner = p_36939_;
        this.ownerUUID = p_36939_ == null ? null : p_36939_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lifeTicks;
        if (this.lifeTicks <= 0 && !this.sentSpike) {
            this.f_19853_.m_7967_((Entity)new CrystalSpikes(this.f_19853_, this.damage, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, this.f_19859_, this.warmupDelayTicks, this.getOwner()));
            this.sentSpike = true;
        }
        if (this.lifeTicks <= -10 - this.warmupDelayTicks) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        for (int k = 0; k < 13; ++k) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(1.0), this.m_20182_().f_82480_, this.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
    }
}

