/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.config.Config;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILENAME = "enderitemod.json";
    private static File file;

    public static void load() {
        File file = ConfigLoader.getFile();
        if (!file.exists()) {
            EnderiteMod.CONFIG = new Config();
            ConfigLoader.save();
        } else {
            ConfigLoader.read();
            ConfigLoader.save();
        }
    }

    private static void read() {
        EnderiteMod.CONFIG = ConfigLoader.get();
    }

    public static void save() {
        File file = ConfigLoader.getFile();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(GSON.toJson((Object)EnderiteMod.CONFIG));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void set(Config config) {
        EnderiteMod.CONFIG = config;
        ConfigLoader.save();
    }

    public static Config get() {
        Config config;
        File file = ConfigLoader.getFile();
        FileReader reader = new FileReader(file);
        try {
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("Enderitemod config not found, creating a new one");
                Config newconfig = new Config();
                ConfigLoader.set(newconfig);
                return newconfig;
            }
        }
        reader.close();
        return config;
    }

    private static File getFile() {
        if (file == null) {
            file = new File(Platform.getConfigFolder().toFile(), FILENAME);
        }
        return file;
    }
}

