/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.materials.EnderiteMaterial;
import net.enderitemc.enderitemod.misc.EnderiteCrossbowUser;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EnderiteCrossbow
extends CrossbowItem {
    private boolean charged = false;
    private boolean loaded = false;

    public EnderiteCrossbow(Item.Properties settings) {
        super(settings);
    }

    public Predicate<ItemStack> m_6442_() {
        return f_43006_;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (EnderiteCrossbow.isCharged(itemStack)) {
            EnderiteCrossbow.shootAll(world, (LivingEntity)user, hand, itemStack, EnderiteCrossbow.getSpeed(itemStack), 1.0f);
            EnderiteCrossbow.setCharged(itemStack, false);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if (!user.m_6298_(itemStack).m_41619_()) {
            if (!EnderiteCrossbow.isCharged(itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i = this.m_8105_(stack) - remainingUseTicks;
        float f = EnderiteCrossbow.getPullProgress(i, stack);
        if (f >= 1.0f && !EnderiteCrossbow.isCharged(stack) && EnderiteCrossbow.loadProjectiles(user, stack)) {
            EnderiteCrossbow.setCharged(stack, true);
            SoundSource soundCategory = user instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11841_, soundCategory, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean loadProjectiles(LivingEntity shooter, ItemStack projectile) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)projectile);
        int j = i == 0 ? 1 : 3;
        boolean bl = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack itemStack = shooter.m_6298_(projectile);
        ItemStack itemStack2 = itemStack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack2.m_41777_();
            }
            if (itemStack.m_41619_() && bl) {
                itemStack = new ItemStack((ItemLike)Items.f_42412_);
                itemStack2 = itemStack.m_41777_();
            }
            if (EnderiteCrossbow.loadProjectile(shooter, projectile, itemStack, k > 0, bl)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity shooter, ItemStack crossbow, ItemStack projectile, boolean simulated, boolean creative) {
        ItemStack itemStack2;
        boolean bl;
        if (projectile.m_41619_()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.m_41720_() instanceof ArrowItem;
        if (!(bl || creative || simulated)) {
            itemStack2 = projectile.m_41620_(1);
            if (projectile.m_41619_() && shooter instanceof Player) {
                ((Player)shooter).m_150109_().m_36057_(projectile);
            }
        } else {
            itemStack2 = projectile.m_41777_();
        }
        EnderiteCrossbow.putProjectile(crossbow, itemStack2);
        return true;
    }

    public static boolean isCharged(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128471_("Charged");
    }

    public static void setCharged(ItemStack stack, boolean charged) {
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128379_("Charged", charged);
    }

    private static void putProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundTag compoundTag = crossbow.m_41784_();
        ListTag listTag2 = compoundTag.m_128425_("ChargedProjectiles", 9) ? compoundTag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundTag2 = new CompoundTag();
        projectile.m_41739_(compoundTag2);
        listTag2.add((Object)compoundTag2);
        compoundTag.m_128365_("ChargedProjectiles", (Tag)listTag2);
    }

    private static List<ItemStack> getProjectiles(ItemStack crossbow) {
        ListTag listTag;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundTag = crossbow.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("ChargedProjectiles", 9) && (listTag = compoundTag.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = listTag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundTag2));
            }
        }
        return list;
    }

    private static void clearProjectiles(ItemStack crossbow) {
        CompoundTag compoundTag = crossbow.m_41783_();
        if (compoundTag != null) {
            ListTag listTag = compoundTag.m_128437_("ChargedProjectiles", 9);
            listTag.clear();
            compoundTag.m_128365_("ChargedProjectiles", (Tag)listTag);
        }
    }

    public static boolean hasProjectile(ItemStack crossbow, Item projectile) {
        return EnderiteCrossbow.getProjectiles(crossbow).stream().anyMatch(s -> s.m_41720_() == projectile);
    }

    private static void shoot(Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.f_46443_) {
            AbstractArrow projectileEntity2;
            boolean bl;
            boolean bl2 = bl = projectile.m_41720_() == Items.f_42688_;
            if (bl) {
                projectileEntity2 = new FireworkRocketEntity(world, projectile, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                projectileEntity2 = EnderiteCrossbow.createArrow(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    projectileEntity2.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof EnderiteCrossbowUser) {
                EnderiteCrossbowUser crossbowUser = (EnderiteCrossbowUser)shooter;
                crossbowUser.m_5811_(crossbowUser.m_5448_(), crossbow, (Projectile)projectileEntity2, simulated);
            } else {
                Vec3 vec3d = shooter.m_20289_(1.0f);
                Quaternionf quaternion = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
                Vec3 vec3d2 = shooter.m_20252_(1.0f);
                Vector3f vector3f = vec3d2.m_252839_();
                vector3f.rotate((Quaternionfc)quaternion);
                ((Projectile)projectileEntity2).m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
            }
            crossbow.m_41622_(bl ? 3 : 1, shooter, e -> e.m_21190_(hand));
            world.m_7967_((Entity)projectileEntity2);
            world.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    private static AbstractArrow createArrow(Level world, LivingEntity entity, ItemStack crossbow, ItemStack arrow) {
        ArrowItem arrowItem = (ArrowItem)(arrow.m_41720_() instanceof ArrowItem ? arrow.m_41720_() : Items.f_42412_);
        AbstractArrow persistentProjectileEntity = arrowItem.m_6394_(world, arrow, entity);
        persistentProjectileEntity.m_6593_((Component)Component.m_237113_((String)"Enderite Arrow"));
        if (entity instanceof Player) {
            persistentProjectileEntity.m_36762_(true);
        }
        persistentProjectileEntity.m_36781_((double)EnderiteMod.CONFIG.tools.enderiteCrossbowAD);
        persistentProjectileEntity.m_36740_(SoundEvents.f_11840_);
        persistentProjectileEntity.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow);
        if (i > 0) {
            persistentProjectileEntity.m_36767_((byte)i);
        }
        return persistentProjectileEntity;
    }

    public static void shootAll(Level world, LivingEntity entity, InteractionHand hand, ItemStack stack, float speed, float divergence) {
        List<ItemStack> list = EnderiteCrossbow.getProjectiles(stack);
        float[] fs = EnderiteCrossbow.getSoundPitches(entity.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            ItemStack itemStack = list.get(i);
            boolean bl2 = bl = entity instanceof Player && ((Player)entity).m_150110_().f_35937_;
            if (itemStack.m_41619_()) continue;
            if (i == 0) {
                EnderiteCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                EnderiteCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            EnderiteCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 10.0f);
        }
        EnderiteCrossbow.postShoot(world, entity, stack);
    }

    private static float[] getSoundPitches(RandomSource random) {
        boolean bl = random.m_188499_();
        return new float[]{1.0f, EnderiteCrossbow.getSoundPitch(bl, random), EnderiteCrossbow.getSoundPitch(!bl, random)};
    }

    private static float getSoundPitch(boolean flag, RandomSource random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void postShoot(Level world, LivingEntity entity, ItemStack stack) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            if (!world.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayerEntity, stack);
            }
            serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        }
        EnderiteCrossbow.clearProjectiles(stack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent soundEvent = this.getQuickChargeSound(i);
            SoundEvent soundEvent2 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(stack.m_41779_() - remainingUseTicks) / (float)EnderiteCrossbow.getPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), soundEvent2, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return EnderiteCrossbow.getPullTime(stack) + 30;
    }

    public static int getPullTime(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return i == 0 ? 35 : 35 - 5 * i;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    private SoundEvent getQuickChargeSound(int stage) {
        switch (stage) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    private static float getPullProgress(int useTicks, ItemStack stack) {
        float f = (float)useTicks / (float)EnderiteCrossbow.getPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        List<ItemStack> list = EnderiteCrossbow.getProjectiles(stack);
        if (EnderiteCrossbow.isCharged(stack) && !list.isEmpty()) {
            ItemStack itemStack = list.get(0);
            tooltip.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_130946_(" ").m_7220_(itemStack.m_41611_()));
            if (context.m_7050_() && itemStack.m_41720_() == Items.f_42688_) {
                ArrayList list2 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemStack, world, (List)list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list2.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
    }

    private static float getSpeed(ItemStack stack) {
        return stack.m_41720_() == EnderiteMod.ENDERITE_CROSSBOW.get() && EnderiteCrossbow.hasProjectile(stack, Items.f_42688_) ? 2.1f : EnderiteMod.CONFIG.tools.enderiteCrossbowArrowSpeed;
    }

    public int m_6615_() {
        return 8;
    }

    public int m_6473_() {
        return EnderiteMaterial.ENDERITE.m_6601_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return EnderiteMaterial.ENDERITE.m_6282_().test(ingredient);
    }
}

