/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.client.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ClientConfig;
import fuzs.easymagic.mixin.client.accessor.ChiseledBookShelfBlockAccessor;
import fuzs.puzzleslib.api.client.screen.v2.TooltipRenderHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;

public class ChiseledBookshelfTooltipHandler {
    public static void tryRenderBookTooltip(Minecraft minecraft, PoseStack poseStack, float tickDelta, int screenWidth, int screenHeight) {
        BlockEntity blockEntity;
        int hitSlot;
        Optional<Vec2> optional;
        if (!ChiseledBookshelfTooltipHandler.canRenderTooltip(minecraft)) {
            return;
        }
        BlockHitResult hitResult = (BlockHitResult)minecraft.f_91077_;
        BlockState state = minecraft.f_91073_.m_8055_(hitResult.m_82425_());
        if (state.m_60713_(Blocks.f_244299_) && (optional = ChiseledBookShelfBlockAccessor.easymagic$callGetRelativeHitCoordinatesForBlockFace(hitResult, (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))).isPresent() && ((Boolean)state.m_61143_((Property)ChiseledBookShelfBlock.f_260698_.get(hitSlot = ChiseledBookShelfBlockAccessor.easymagic$callGetHitSlot(optional.get())))).booleanValue() && (blockEntity = minecraft.f_91073_.m_7702_(hitResult.m_82425_())) instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity blockEntity2 = (ChiseledBookShelfBlockEntity)blockEntity;
            ItemStack stack = blockEntity2.m_8020_(hitSlot);
            if (stack.m_41619_()) {
                return;
            }
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.m_69465_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ChiseledBookshelfTooltipHandler.renderBookTooltip(poseStack, screenWidth, screenHeight, stack);
        }
    }

    private static boolean canRenderTooltip(Minecraft minecraft) {
        Entity entity;
        if (((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).chiseledBookshelfTooltip == ClientConfig.ChiseledBookshelfTooltip.DISABLED) {
            return false;
        }
        if (!minecraft.f_91066_.f_92062_ && minecraft.f_91066_.m_92176_().m_90612_() && minecraft.f_91072_ != null && minecraft.f_91072_.m_105295_() != GameType.SPECTATOR && (entity = minecraft.f_91075_) instanceof Player) {
            Player player = (Player)entity;
            if (minecraft.f_91077_ != null && minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                return player.m_6144_() || ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).chiseledBookshelfTooltip == ClientConfig.ChiseledBookshelfTooltip.ENABLED;
            }
        }
        return false;
    }

    private static void renderBookTooltip(PoseStack poseStack, int screenWidth, int screenHeight, ItemStack stack) {
        int posX = screenWidth / 2 - 12 + 22 + ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).offsetX;
        int posY = screenHeight / 2 + 12 - ChiseledBookshelfTooltipHandler.getFullTooltipHeight(stack) / 2 + ((ClientConfig)EasyMagic.CONFIG.get(ClientConfig.class)).offsetY;
        TooltipRenderHelper.renderTooltip((PoseStack)poseStack, (int)posX, (int)posY, (ItemStack)stack);
    }

    private static int getFullTooltipHeight(ItemStack stack) {
        List components = TooltipRenderHelper.getTooltip((ItemStack)stack);
        int height = components.size() == 1 ? -2 : 0;
        return height += components.stream().mapToInt(ClientTooltipComponent::m_142103_).sum();
    }
}

